/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.apache.commons.io.IOUtils;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.FileExtension;
import org.bsc.confluence.model.Site;
import org.bsc.markdown.MarkdownParserContext;
import org.bsc.markdown.MarkdownProcessor;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SiteProcessor {
    private static Optional<InputStream> getResourceAsStream(String source) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream(source);
        if (is == null) {
            cl = Site.class.getClassLoader();
            is = cl.getResourceAsStream(source);
        }
        return Optional.ofNullable(is);
    }

    public static <T> T processUri(URI uri, BiFunction<Optional<Exception>, Optional<InputStream>, T> callback) {
        Optional<InputStream> result;
        Objects.requireNonNull(uri, "uri is null!");
        Objects.requireNonNull(callback, "callback is null!");
        String scheme = uri.getScheme();
        Objects.requireNonNull(scheme, String.format("uri [%s] is invalid!", String.valueOf(uri)));
        String source = uri.getRawSchemeSpecificPart();
        if ("classpath".equalsIgnoreCase(scheme)) {
            result = SiteProcessor.getResourceAsStream(source);
            if (!result.isPresent()) {
                Exception ex = new Exception(String.format("resource [%s] doesn't exist in classloader", source));
                return callback.apply(Optional.of(ex), Optional.empty());
            }
        } else {
            try {
                URL url = uri.toURL();
                result = Optional.ofNullable(url.openStream());
            }
            catch (IOException e) {
                Exception ex = new Exception(String.format("error opening url [%s]!", source), e);
                return callback.apply(Optional.of(ex), Optional.empty());
            }
        }
        return callback.apply(Optional.empty(), result);
    }

    public static <P extends Site.Page> CompletableFuture<PageContent> processPageUri(Site site, P child, ConfluenceService.Model.Page page, URI uri, String pagePrefixToApply) {
        Objects.requireNonNull(uri, "uri is null!");
        String scheme = uri.getScheme();
        Objects.requireNonNull(scheme, String.format("uri [%s] is invalid!", String.valueOf(uri)));
        CompletableFuture<PageContent> result = new CompletableFuture<PageContent>();
        String source = uri.getRawSchemeSpecificPart();
        String path = uri.getRawPath();
        boolean isMarkdown = FileExtension.MARKDOWN.isExentionOf(path);
        boolean isStorage = FileExtension.XML.isExentionOf(path) || FileExtension.XHTML.isExentionOf(path);
        ConfluenceService.Storage.Representation representation = isStorage ? ConfluenceService.Storage.Representation.STORAGE : ConfluenceService.Storage.Representation.WIKI;
        String content = null;
        if ("classpath".equalsIgnoreCase(scheme)) {
            Optional<InputStream> is = SiteProcessor.getResourceAsStream(source);
            if (!is.isPresent()) {
                result.completeExceptionally(new Exception(String.format("page [%s] doesn't exist in classloader", source)));
                return result;
            }
            try {
                String candidateContent = IOUtils.toString((InputStream)is.get(), (Charset)Charset.defaultCharset());
                content = isMarkdown ? SiteProcessor.processMarkdown(site, child, page, candidateContent, pagePrefixToApply) : candidateContent;
            }
            catch (IOException e) {
                result.completeExceptionally(new Exception(String.format("error processing markdown for page [%s] ", source)));
                return result;
            }
        }
        try {
            URL url = uri.toURL();
            InputStream is = url.openStream();
            String candidateContent = IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset());
            content = isMarkdown ? SiteProcessor.processMarkdown(site, child, page, candidateContent, pagePrefixToApply) : candidateContent;
        }
        catch (IOException e) {
            result.completeExceptionally(new Exception(String.format("error opening/processing page [%s]!", source), e));
            return result;
        }
        result.complete(PageContent.of(content, representation));
        return result;
    }

    public static <P extends Site.Page> CompletableFuture<PageContent> processUriContent(Site site, P child, URI uri, String homePageTitle) {
        String content;
        ConfluenceService.Storage.Representation representation;
        Objects.requireNonNull(uri, "uri is null!");
        String scheme = uri.getScheme();
        Objects.requireNonNull(scheme, String.format("uri [%s] is invalid!", uri));
        CompletableFuture<PageContent> result = new CompletableFuture<PageContent>();
        String source = uri.getRawSchemeSpecificPart();
        String path = uri.getRawPath();
        boolean isMarkdown = FileExtension.MARKDOWN.isExentionOf(path);
        boolean isStorage = FileExtension.XML.isExentionOf(path) || FileExtension.XHTML.isExentionOf(path);
        ConfluenceService.Storage.Representation representation2 = representation = isStorage ? ConfluenceService.Storage.Representation.STORAGE : ConfluenceService.Storage.Representation.WIKI;
        if ("classpath".equalsIgnoreCase(scheme)) {
            Optional<InputStream> is = SiteProcessor.getResourceAsStream(source);
            if (!is.isPresent()) {
                result.completeExceptionally(new Exception(String.format("resource [%s] doesn't exist in classloader", source)));
                return result;
            }
            try {
                String candidateContent = IOUtils.toString((InputStream)is.get(), (Charset)Charset.defaultCharset());
                content = isMarkdown ? SiteProcessor.processMarkdown(site, child, null, candidateContent, homePageTitle) : candidateContent;
            }
            catch (IOException e) {
                result.completeExceptionally(new Exception(String.format("error processing page [%s] ", source)));
                return result;
            }
        }
        try {
            URL url = uri.toURL();
            InputStream is = url.openStream();
            String candidateContent = IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset());
            content = isMarkdown ? SiteProcessor.processMarkdown(site, child, null, candidateContent, homePageTitle) : candidateContent;
        }
        catch (IOException e) {
            result.completeExceptionally(new Exception(String.format("error opening url [%s]!", source), e));
            return result;
        }
        result.complete(PageContent.of(content, representation));
        return result;
    }

    public static String processMarkdown(final Site site, final Site.Page child, final ConfluenceService.Model.Page page, String content, final String pagePrefixToApply) throws IOException {
        return MarkdownProcessor.shared.processMarkdown(new MarkdownParserContext(){

            @Override
            public boolean isSkipHtml() {
                return MarkdownProcessor.shared.isSkipHtml();
            }

            @Override
            public Optional<Site> getSite() {
                return Optional.ofNullable(site);
            }

            @Override
            public Optional<Site.Page> getPage() {
                return Optional.ofNullable(child);
            }

            @Override
            public Optional<String> getPagePrefixToApply() {
                return Optional.ofNullable(pagePrefixToApply);
            }

            @Override
            public boolean isLinkPrefixEnabled() {
                if (child.isIgnoreVariables().booleanValue()) {
                    return false;
                }
                return Optional.ofNullable(page).map(p -> !p.getTitle().contains("[")).orElse(true);
            }
        }, content);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class PageContent {
        final String content;
        final ConfluenceService.Storage.Representation type;

        public String getContent() {
            return this.content;
        }

        public ConfluenceService.Storage.Representation getType() {
            return this.type;
        }

        public static PageContent of(String content, ConfluenceService.Storage.Representation type) {
            return new PageContent(content, type);
        }

        private PageContent(String content, ConfluenceService.Storage.Representation type) {
            Objects.requireNonNull(content);
            Objects.requireNonNull(type);
            this.content = content;
            this.type = type;
        }

        @Deprecated
        public InputStream getInputStream() {
            return IOUtils.toInputStream((String)this.content, (Charset)Charset.defaultCharset());
        }

        public InputStream getInputStream(Charset charset) throws IOException {
            return IOUtils.toInputStream((String)this.content, (String)charset.toString());
        }

        public String getContent(Charset charset) {
            if (charset != Charset.defaultCharset()) {
                return new String(this.content.getBytes(Charset.defaultCharset()), charset);
            }
            return this.content;
        }
    }
}

