/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.preprocessor;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModelException;
import freemarker.template.Version;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bsc.confluence.preprocessor.SitePocessorService;

public class PreprocessorImpl
implements SitePocessorService {
    private static final Version VERSION = Configuration.VERSION_2_3_29;
    private final Configuration cfg = new Configuration(VERSION);

    public PreprocessorImpl() {
        this.cfg.setDefaultEncoding(StandardCharsets.UTF_8.name());
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.cfg.setLogTemplateExceptions(false);
        this.cfg.setWrapUncheckedExceptions(true);
        this.cfg.setFallbackOnNullLoopVariable(false);
    }

    public String getName() {
        return "freemarker";
    }

    public CompletableFuture<String> process(String input, Map<String, Object> variables) {
        CompletableFuture<String> result = new CompletableFuture<String>();
        try {
            Template t = new Template(UUID.randomUUID().toString(), (Reader)new StringReader(input), this.cfg);
            StringWriter out = new StringWriter();
            t.process(this.getModel(variables), (Writer)out);
            result.complete(out.toString());
        }
        catch (TemplateException | IOException e) {
            result.completeExceptionally(new IllegalArgumentException("Error while processing the template!", e));
        }
        return result;
    }

    private Map<String, Object> getModel(Map<String, Object> variables) throws TemplateModelException {
        HashMap<String, Object> model = new HashMap<String, Object>(variables);
        BeansWrapper beans = new BeansWrapper(VERSION);
        model.put("enums", beans.getEnumModels());
        model.put("statics", beans.getStaticModels());
        model.put("Paths", beans.getStaticModels().get(Paths.class.getName()));
        model.put("Files", beans.getStaticModels().get(Files.class.getName()));
        return model;
    }
}

