/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.reporting;

import biz.source_code.miniTemplator.MiniTemplator;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.bsc.maven.plugin.confluence.ConfluenceUtils;
import org.bsc.maven.reporting.Child;
import org.codehaus.swizzle.confluence.Attachment;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.Page;
import org.jfrog.maven.annomojo.annotations.MojoParameter;

public abstract class AbstractConfluenceReportMojo
extends AbstractMavenReport {
    @MojoParameter(description="additional properties pass to template processor")
    private Map properties;
    @MojoParameter(expression="${confluence.endPoint}", defaultValue="http://localhost:8080/rpc/xmlrpc")
    private String endPoint;
    @MojoParameter(expression="${confluence.spaceKey}", required=true)
    private String spaceKey;
    @MojoParameter(expression="${confluence.parentPage}", defaultValue="Home")
    private String parentPageTitle;
    @MojoParameter(expression="${confluence.userName}", defaultValue="admin")
    private String username;
    @MojoParameter(expression="${confluence.password}")
    private String password;
    @MojoParameter(expression="${project}", readonly=true, required=true)
    protected MavenProject project;
    @MojoParameter(defaultValue="${basedir}/src/site/confluence/template.wiki", description="MiniTemplator source. Default location is ${basedir}/src/site/confluence")
    protected File templateWiki;
    @MojoParameter(description="child pages - &lt;child&gt;&lt;name/&gt;[&lt;source/&gt]&lt;/child&gt")
    private List children = Collections.emptyList();
    @MojoParameter(description="attachment folder", defaultValue="${basedir}/src/site/confluence/attachments")
    private File attachmentFolder;

    public final Map getProperties() {
        if (null == this.properties) {
            this.properties = new HashMap(5);
        }
        return this.properties;
    }

    public final String getEndPoint() {
        return this.endPoint;
    }

    public final String getSpaceKey() {
        return this.spaceKey;
    }

    public final String getParentPageTitle() {
        return this.parentPageTitle;
    }

    public final String getUsername() {
        return this.username;
    }

    public final String getPassword() {
        return this.password;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void addProperties(MiniTemplator t) {
        Map properties = this.getProperties();
        if (properties == null || properties.isEmpty()) {
            this.getLog().info((CharSequence)"no properties set!");
        } else {
            for (Map.Entry e : properties.entrySet()) {
                this.getLog().debug((CharSequence)String.format("property %s = %s", e.getKey(), e.getValue()));
                try {
                    t.setVariable((String)e.getKey(), (String)e.getValue(), true);
                }
                catch (MiniTemplator.VariableNotDefinedException e1) {
                    this.getLog().warn((CharSequence)String.format("variable %s not defined in template", e.getKey()));
                }
            }
        }
    }

    protected void generateChildren(Confluence confluence, String spaceKey, String parentPageTitle, String titlePrefix) {
        this.getLog().info((CharSequence)String.format("generateChildren # [%d]", this.children.size()));
        for (Child child : this.children) {
            File source = child.getSource(this.getProject());
            this.getLog().info((CharSequence)child.toString());
            try {
                MiniTemplator t = new MiniTemplator((Reader)new FileReader(source));
                Page p = ConfluenceUtils.getOrCreatePage((Confluence)confluence, (String)spaceKey, (String)parentPageTitle, (String)String.format("%s - %s", titlePrefix, child.getName()));
                this.addProperties(t);
                p.setContent(t.generateOutput());
                confluence.storePage(p);
            }
            catch (Exception e) {
                String msg = "error loading template";
                this.getLog().error((CharSequence)"error loading template", (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generateAttachments(Confluence confluence, Page page) {
        this.getLog().info((CharSequence)String.format("generateAttachments pageId [%s]", page.getId()));
        File[] files = this.attachmentFolder.listFiles();
        if (files == null || files.length == 0) {
            this.getLog().info((CharSequence)String.format("No attachments found in folder [%s] ", this.attachmentFolder.getPath()));
            return;
        }
        String version = "0";
        File[] arr$ = files;
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            block7: {
                Attachment a;
                File f;
                block10: {
                    block8: {
                        block11: {
                            Date date;
                            block9: {
                                if (i$ >= len$) {
                                    return;
                                }
                                f = arr$[i$];
                                if (f.isDirectory() || f.isHidden()) break block7;
                                a = null;
                                try {
                                    a = confluence.getAttachment(page.getId(), f.getName(), "0");
                                }
                                catch (Exception e) {
                                    this.getLog().warn((CharSequence)String.format("Error getting attachment [%s] from confluence: [%s]", f.getName(), e.getMessage()));
                                }
                                if (a == null) break block8;
                                date = a.getCreated();
                                if (date != null) break block9;
                                this.getLog().warn((CharSequence)String.format("creation date of attachments [%s] is undefined. It will be replaced! ", a.getFileName()));
                                break block10;
                            }
                            if (f.lastModified() <= date.getTime()) break block11;
                            this.getLog().info((CharSequence)String.format("attachment [%s] is more recent than the remote one. It will be replaced! ", a.getFileName()));
                            break block10;
                        }
                        this.getLog().info((CharSequence)String.format("attachment [%s] skipped! no updated detected", a.getFileName()));
                        break block7;
                    }
                    a = new Attachment();
                    a.setComment("attached by maven-confluence-plugin");
                    a.setFileName(f.getName());
                    a.setContentType("application/octet-stream");
                }
                try {
                    ConfluenceUtils.addAttchment((Confluence)confluence, (Page)page, (Attachment)a, (File)f);
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)String.format("Error uploading attachment [%s] ", f.getName()), (Throwable)e);
                }
            }
            ++i$;
        }
    }
}

