/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.reporting;

import biz.source_code.miniTemplator.MiniTemplator;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.scm.manager.ScmManager;
import org.bsc.maven.plugin.confluence.ConfluenceUtils;
import org.bsc.maven.reporting.AbstractConfluenceReportMojo;
import org.bsc.maven.reporting.ReportingResolutionListener;
import org.bsc.maven.reporting.renderer.DependenciesRenderer;
import org.bsc.maven.reporting.renderer.ProjectSummaryRenderer;
import org.bsc.maven.reporting.renderer.ScmRenderer;
import org.bsc.maven.reporting.sink.ConfluenceSink;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.Page;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoPhase;

@MojoPhase(value="site")
@MojoGoal(value="confluence-summary")
public class ConfluenceReportMojo
extends AbstractConfluenceReportMojo {
    private static final String PROJECT_DEPENDENCIES_VAR = "project.dependencies";
    private static final String PROJECT_SCM_MANAGER_VAR = "project.scmManager";
    private static final String PROJECT_SUMMARY_VAR = "project.summary";
    @MojoParameter(expression="${localRepository}", required=true, readonly=true)
    protected ArtifactRepository localRepository;
    @MojoComponent
    protected ArtifactMetadataSource artifactMetadataSource;
    @MojoComponent
    private ArtifactCollector collector;
    @MojoComponent
    protected ArtifactFactory factory;
    @MojoComponent
    private MavenProjectBuilder mavenProjectBuilder;
    @MojoComponent
    protected I18N i18n;
    @MojoParameter(expression="${project.reporting.outputDirectory}")
    protected File outputDirectory;
    @MojoParameter(expression="${component.org.apache.maven.scm.manager.ScmManager}", required=true, readonly=true)
    protected ScmManager scmManager;
    @MojoParameter(expression="${project.artifactId}", required=true)
    private String checkoutDirectoryName;
    @MojoParameter(defaultValue="${project.scm.connection}")
    private String anonymousConnection;
    @MojoParameter(defaultValue="${project.scm.developerConnection}")
    private String developerConnection;
    @MojoParameter(defaultValue="${project.scm.url}")
    private String webAccessUrl;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"execute");
        super.execute();
    }

    private void confluenceLogout(Confluence confluence) {
        if (null == confluence) {
            return;
        }
        try {
            if (!confluence.logout()) {
                this.getLog().warn((CharSequence)"confluence logout has failed!");
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"confluence logout has failed due exception ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeReport(Locale locale) throws MavenReportException {
        this.getLog().info((CharSequence)"executeReport ");
        String title = this.project.getArtifactId() + "-" + this.project.getVersion();
        this.getProperties().put("pageTitle", title);
        this.getProperties().put("artifactId", this.project.getArtifactId());
        this.getProperties().put("version", this.project.getVersion());
        MiniTemplator t = null;
        if (this.templateWiki == null || !this.templateWiki.exists()) {
            this.getLog().warn((CharSequence)"template not set! default using ...");
            InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("defaultTemplate.wiki");
            if (is == null) {
                String msg = "default template cannot be found";
                this.getLog().error((CharSequence)"default template cannot be found");
                throw new MavenReportException("default template cannot be found");
            }
            try {
                t = new MiniTemplator((Reader)new InputStreamReader(is));
            }
            catch (Exception e) {
                String msg = "error loading template";
                this.getLog().error((CharSequence)"error loading template", (Throwable)e);
                throw new MavenReportException("error loading template", e);
            }
        }
        try {
            t = new MiniTemplator(this.templateWiki);
        }
        catch (Exception e) {
            String msg = "error loading template";
            this.getLog().error((CharSequence)"error loading template", (Throwable)e);
            throw new MavenReportException("error loading template", e);
        }
        super.addProperties(t);
        StringWriter w = new StringWriter(10240);
        ConfluenceSink sink = new ConfluenceSink(w, this.getSink());
        new ProjectSummaryRenderer((Sink)sink, this.project, this.i18n, locale).render();
        try {
            t.setVariable(PROJECT_SUMMARY_VAR, w.toString());
        }
        catch (MiniTemplator.VariableNotDefinedException e) {
            this.getLog().warn((CharSequence)String.format("variable %s not defined in template", PROJECT_SUMMARY_VAR));
        }
        w = new StringWriter(10240);
        sink = new ConfluenceSink(w, this.getSink());
        new ScmRenderer(this.scmManager, (Sink)sink, this.project.getModel(), this.i18n, locale, this.checkoutDirectoryName, this.webAccessUrl, this.anonymousConnection, this.developerConnection).render();
        try {
            t.setVariable(PROJECT_SCM_MANAGER_VAR, w.toString());
        }
        catch (MiniTemplator.VariableNotDefinedException e) {
            this.getLog().warn((CharSequence)String.format("variable %s not defined in template", PROJECT_SCM_MANAGER_VAR));
        }
        w = new StringWriter(10240);
        sink = new ConfluenceSink(w, this.getSink());
        new DependenciesRenderer((Sink)sink, this.project, this.mavenProjectBuilder, this.localRepository, this.factory, this.i18n, locale, this.resolveProject(), this.getLog()).render();
        try {
            t.setVariable(PROJECT_DEPENDENCIES_VAR, w.toString());
        }
        catch (MiniTemplator.VariableNotDefinedException e) {
            this.getLog().warn((CharSequence)String.format("variable %s not defined in template", PROJECT_DEPENDENCIES_VAR));
        }
        String wiki = t.generateOutput();
        Confluence confluence = null;
        try {
            confluence = new Confluence(this.getEndPoint());
            confluence.login(this.getUsername(), this.getPassword());
            Page p = ConfluenceUtils.getOrCreatePage((Confluence)confluence, (String)this.getSpaceKey(), (String)this.getParentPageTitle(), (String)title);
            p.setContent(wiki);
            confluence.storePage(p);
            this.generateChildren(confluence, this.getSpaceKey(), title, title);
            this.generateAttachments(confluence, p);
            this.confluenceLogout(confluence);
        }
        catch (Exception e) {
            try {
                this.getLog().warn((CharSequence)"has been imposssible connect to confluence due exception", (Throwable)e);
                this.confluenceLogout(confluence);
            }
            catch (Throwable throwable) {
                this.confluenceLogout(confluence);
                throw throwable;
            }
        }
        System.out.println("========================================");
        System.out.println(wiki);
        System.out.println("========================================");
    }

    public void generate(Sink aSink, SinkFactory aSinkFactory, Locale aLocale) throws MavenReportException {
        this.getLog().info((CharSequence)("generate " + aSink));
        super.generate(aSink, aSinkFactory, aLocale);
    }

    private ReportingResolutionListener resolveProject() {
        Map managedVersions = null;
        try {
            managedVersions = this.createManagedVersionMap(this.project.getId(), this.project.getDependencyManagement());
        }
        catch (ProjectBuildingException e) {
            this.getLog().error((CharSequence)"An error occurred while resolving project dependencies.", (Throwable)e);
        }
        ReportingResolutionListener listener = new ReportingResolutionListener();
        try {
            this.collector.collect(this.project.getDependencyArtifacts(), this.project.getArtifact(), managedVersions, this.localRepository, this.project.getRemoteArtifactRepositories(), this.artifactMetadataSource, null, Collections.singletonList(listener));
        }
        catch (ArtifactResolutionException e) {
            this.getLog().error((CharSequence)"An error occurred while resolving project dependencies.", (Throwable)e);
        }
        return listener;
    }

    private Map createManagedVersionMap(String projectId, DependencyManagement dependencyManagement) throws ProjectBuildingException {
        HashMap<String, Artifact> map;
        if (dependencyManagement != null && dependencyManagement.getDependencies() != null) {
            map = new HashMap<String, Artifact>();
            for (Dependency d : dependencyManagement.getDependencies()) {
                try {
                    VersionRange versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
                    Artifact artifact = this.factory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope());
                    map.put(d.getManagementKey(), artifact);
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new ProjectBuildingException(projectId, "Unable to parse version '" + d.getVersion() + "' for dependency '" + d.getManagementKey() + "': " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            map = Collections.EMPTY_MAP;
        }
        return map;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.toString();
    }

    protected Renderer getSiteRenderer() {
        this.getLog().info((CharSequence)"getSiteRenderer");
        return null;
    }

    public String getDescription(Locale locale) {
        return "confluence";
    }

    public String getOutputName() {
        return "confluence";
    }

    public String getName(Locale locale) {
        return "confluence";
    }
}

