/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.reporting.sink;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Stack;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.bsc.maven.plugin.confluence.ConfluenceUtils;

public class ConfluenceSink
extends SiteRendererSink {
    Stack<Command> commandStack = new Stack();
    Stack<String> dataStack = new Stack();
    Sink _s;
    PrintWriter _w;

    public ConfluenceSink(Writer w, Sink delegate) {
        super(null);
        this._s = delegate;
        this._w = new PrintWriter(w);
    }

    public Writer getWriter() {
        return this._w;
    }

    public void horizontalRule() {
        this._w.println("---");
        this._s.horizontalRule();
    }

    public void sectionTitle() {
        this._w.print("sectionTitle");
        this._s.sectionTitle();
    }

    public void anchor_() {
        this._s.anchor_();
    }

    public void anchor(String name) {
        this._w.printf("{anchor:%s} ", ConfluenceUtils.encodeAnchor((String)name));
        this._s.anchor(name);
    }

    public void author_() {
        this._s.author_();
    }

    public void author() {
        this._w.print("author");
        this._s.author();
    }

    public void body_() {
        this._s.body_();
    }

    public void body() {
        this._s.body();
    }

    public void bold_() {
        this._w.print('*');
        this._s.bold_();
    }

    public void bold() {
        this._w.print('*');
        this._s.bold();
    }

    public void close() {
        this._w.flush();
        this._w.flush();
    }

    public void date_() {
        this._s.date_();
    }

    public void date() {
        this._w.print("date");
        this._s.date();
    }

    public void definedTerm_() {
        this._s.definedTerm_();
    }

    public void definedTerm() {
        this._w.print("definedTerm");
        this._s.definedTerm();
    }

    public void definition_() {
        this._s.definition_();
    }

    public void definition() {
        this._w.print("definition");
        this._s.definition();
    }

    public void definitionList_() {
        this._s.definitionList_();
    }

    public void definitionList() {
        this._w.print("definitionList");
        this._s.definitionList();
    }

    public void definitionListItem_() {
        this._s.definitionListItem_();
    }

    public void definitionListItem() {
        this._w.print("definitionListItem");
        this._s.definitionListItem();
    }

    public void figure_() {
        this._s.figure_();
    }

    public void figure() {
        this._w.print("figure");
        this._s.figure();
    }

    public void figureCaption_() {
        this._s.figureCaption_();
    }

    public void figureCaption() {
        this._w.print("figureCaption");
        this._s.figureCaption();
    }

    public void figureGraphics(String name) {
        this._s.figureGraphics(name);
    }

    public void flush() {
        this._w.flush();
        this._s.flush();
    }

    public void head_() {
        this._s.head_();
    }

    public void head() {
        this._s.head();
    }

    public void italic_() {
        this._w.print('_');
        this._s.italic_();
    }

    public void italic() {
        this._w.print('_');
        this._s.italic();
    }

    public void lineBreak() {
        this._w.println("\\\\");
        this._s.lineBreak();
    }

    public void link_() {
        this.commandStack.pop();
        String link = this.dataStack.pop();
        this._w.printf("|%s]", ConfluenceUtils.encodeAnchor((String)link));
        this._w.println();
        this._s.link_();
    }

    public void link(String name) {
        this.dataStack.push(name);
        this.commandStack.push(Command.LINK);
        this._w.print('[');
        this._s.link(name);
    }

    public void list_() {
        this._s.list_();
    }

    public void list() {
        this._w.print('*');
        this._s.list();
    }

    public void listItem_() {
        this._s.listItem_();
    }

    public void listItem() {
        this._w.print("* ");
        this._s.listItem();
    }

    public void monospaced_() {
        this._w.println("}}");
        this._s.monospaced_();
    }

    public void monospaced() {
        this._w.print("{{");
        this._s.monospaced();
    }

    public void nonBreakingSpace() {
        this._s.nonBreakingSpace();
    }

    public void numberedList_() {
        this._s.numberedList_();
    }

    public void numberedList(int numbering) {
        this._w.printf("numberedList(%d)", numbering);
        this._s.numberedList(numbering);
    }

    public void numberedListItem_() {
        this._s.numberedListItem_();
    }

    public void numberedListItem() {
        this._s.numberedListItem();
    }

    public void pageBreak() {
        this._w.println("----");
        this._s.pageBreak();
    }

    public void paragraph_() {
        this._w.println();
        this._s.paragraph_();
    }

    public void paragraph() {
        this._s.paragraph();
    }

    public void rawText(String text) {
        this._w.printf("rawText(%s)", text);
        this._s.rawText(text);
    }

    public void section1_() {
        this._s.section1_();
    }

    public void section1() {
        this._s.section1();
    }

    public void section2_() {
        this._s.section2_();
    }

    public void section2() {
        this._s.section2();
    }

    public void section3_() {
        this._s.section3_();
    }

    public void section3() {
        this._s.section3();
    }

    public void section4_() {
        this._s.section4_();
    }

    public void section4() {
        this._s.section4();
    }

    public void section5_() {
        this._s.section5_();
    }

    public void section5() {
        this._s.section5();
    }

    public void sectionTitle_() {
        this._w.print("h1. ");
        this._s.sectionTitle_();
    }

    public void sectionTitle1_() {
        this._w.println();
        this._s.sectionTitle1_();
    }

    public void sectionTitle1() {
        this._w.print("h1. ");
        this._s.sectionTitle1();
    }

    public void sectionTitle2_() {
        this._w.println();
        this._s.sectionTitle2_();
    }

    public void sectionTitle2() {
        this._w.print("h2. ");
        this._s.sectionTitle2();
    }

    public void sectionTitle3_() {
        this._w.println();
        this._s.sectionTitle3_();
    }

    public void sectionTitle3() {
        this._w.print("h3. ");
        this._s.sectionTitle3();
    }

    public void sectionTitle4_() {
        this._w.println();
        this._s.sectionTitle4_();
    }

    public void sectionTitle4() {
        this._w.print("h4. ");
        this._s.sectionTitle4();
    }

    public void sectionTitle5_() {
        this._w.println();
        this._s.sectionTitle5_();
    }

    public void sectionTitle5() {
        this._w.print("h5. ");
        this._s.sectionTitle5();
    }

    public void table_() {
        this._s.table_();
    }

    public void table() {
        this._w.println();
        this._s.table();
    }

    public void tableCaption_() {
        this._s.tableCaption_();
    }

    public void tableCaption() {
        this._w.print("tableCaption");
        this._s.tableCaption();
    }

    public void tableCell_() {
        this._s.tableCell_();
    }

    public void tableCell() {
        if (this.commandStack.isEmpty()) {
            this.commandStack.push(Command.CELL);
        }
        this._w.print('|');
        try {
            this._s.tableCell();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void tableCell(String width) {
        if (this.commandStack.isEmpty()) {
            this.commandStack.push(Command.CELL);
        }
        this._w.print('|');
        this._s.tableCell(width);
    }

    public void tableHeaderCell_() {
        this._s.tableHeaderCell_();
    }

    public void tableHeaderCell() {
        if (this.commandStack.isEmpty()) {
            this.commandStack.push(Command.HEADER);
        }
        this._w.print("||");
        try {
            this._s.tableHeaderCell();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void tableHeaderCell(String width) {
        if (this.commandStack.isEmpty()) {
            this.commandStack.push(Command.HEADER);
        }
        this._w.print("||");
        this._s.tableHeaderCell(width);
    }

    public void tableRow_() {
        Command c = this.commandStack.pop();
        if (Command.CELL == c) {
            this._w.println('|');
        } else if (Command.HEADER == c) {
            this._w.println("||");
        } else {
            this._w.println();
        }
        this._s.tableRow_();
    }

    public void tableRow() {
        this._s.tableRow();
    }

    public void tableRows_() {
        this._s.tableRows_();
    }

    public void tableRows(int[] justification, boolean grid) {
        this._s.tableRows(justification, grid);
    }

    public void text(String text) {
        Command c;
        this._s.text(text);
        if (!this.commandStack.isEmpty() && Command.TITLE == (c = this.commandStack.peek())) {
            return;
        }
        this._w.print(ConfluenceUtils.decode((String)text));
    }

    public void title_() {
        this.commandStack.pop();
        this._s.title_();
    }

    public void title() {
        this.commandStack.push(Command.TITLE);
        this._s.title();
    }

    public void verbatim_() {
        this._w.println("{noFormat}");
        this._s.verbatim_();
    }

    public void verbatim(boolean boxed) {
        this._w.println("{noFormat}");
        this._s.verbatim(boxed);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Command {
        HEADER,
        CELL,
        LINK,
        ANCHOR,
        TITLE;

    }
}

