/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.plugin.confluence;

import biz.source_code.miniTemplator.MiniTemplator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.generator.Generator;
import org.bsc.maven.plugin.confluence.ConfluenceGeneratePluginDocMojo;
import org.bsc.maven.plugin.confluence.ConfluenceUtils;
import org.bsc.maven.plugin.confluence.ConfluenceWikiWriter;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.Page;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginConfluenceDocGenerator
implements Generator {
    public static final String DEFAULT_PLUGIN_TEMPLATE_WIKI = "defaultPluginTemplate.wiki";
    private final Confluence confluence;
    private final Page parentPage;
    private final File templateWiki;
    private final ConfluenceGeneratePluginDocMojo mojo;

    public PluginConfluenceDocGenerator(ConfluenceGeneratePluginDocMojo mojo, Confluence confluence, Page parentPage, File templateWiki) {
        this.mojo = mojo;
        this.confluence = confluence;
        this.parentPage = parentPage;
        this.templateWiki = templateWiki;
    }

    public void execute(File destinationDirectory, PluginDescriptor pluginDescriptor) throws IOException {
        try {
            this.processMojoDescriptors(pluginDescriptor);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void execute(File destinationDirectory, PluginToolsRequest request) throws IOException {
        try {
            this.processMojoDescriptors(request.getPluginDescriptor());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    protected void processMojoDescriptors(PluginDescriptor pluginDescriptor) throws Exception {
        List mojos = pluginDescriptor.getMojos();
        if (mojos == null) {
            this.mojo.getLog().warn((CharSequence)"no mojos found [pluginDescriptor.getMojos()]");
            return;
        }
        String title = pluginDescriptor.getArtifactId() + "-" + pluginDescriptor.getVersion();
        this.mojo.getProperties().put("pageTitle", title);
        this.mojo.getProperties().put("artifactId", this.mojo.getProject().getArtifactId());
        this.mojo.getProperties().put("version", this.mojo.getProject().getVersion());
        MiniTemplator t = null;
        if (this.templateWiki == null || !this.templateWiki.exists()) {
            this.mojo.getLog().warn((CharSequence)"template not set! default using ...");
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_PLUGIN_TEMPLATE_WIKI);
            if (is == null) {
                String msg = "default template cannot be found";
                this.mojo.getLog().error((CharSequence)"default template cannot be found");
                throw new MavenReportException("default template cannot be found");
            }
            try {
                t = new MiniTemplator((Reader)new InputStreamReader(is));
            }
            catch (Exception e) {
                String msg = "error loading template";
                this.mojo.getLog().error((CharSequence)"error loading template", (Throwable)e);
                throw new MavenReportException("error loading template", e);
            }
        }
        try {
            t = new MiniTemplator(this.templateWiki);
        }
        catch (Exception e) {
            String msg = "error loading template";
            this.mojo.getLog().error((CharSequence)"error loading template", (Throwable)e);
            throw new MavenReportException("error loading template", e);
        }
        this.mojo.addProperties(t);
        Page page = ConfluenceUtils.getOrCreatePage((Confluence)this.confluence, (Page)this.parentPage, (String)title);
        if (!this.mojo.isSnapshot() && this.mojo.isRemoveSnapshots()) {
            String snapshot = title.concat("-SNAPSHOT");
            this.mojo.getLog().info((CharSequence)String.format("removing page [%s]!", snapshot));
            boolean deleted = ConfluenceUtils.removePage((Confluence)this.confluence, (Page)this.parentPage, (String)snapshot);
            if (deleted) {
                this.mojo.getLog().info((CharSequence)String.format("Page [%s] has been removed!", snapshot));
            }
        }
        StringWriter writer = new StringWriter(102400);
        this.writeSummary(writer, pluginDescriptor, mojos);
        writer.flush();
        try {
            t.setVariable("plugin.summary", writer.toString());
        }
        catch (MiniTemplator.VariableNotDefinedException e) {
            this.mojo.getLog().warn((CharSequence)String.format("variable %s not defined in template", "plugin.summary"));
        }
        writer = new StringWriter(102400);
        this.writeGoals(writer, mojos);
        writer.flush();
        try {
            t.setVariable("plugin.goals", writer.toString());
        }
        catch (MiniTemplator.VariableNotDefinedException e) {
            this.mojo.getLog().warn((CharSequence)String.format("variable %s not defined in template", "plugin.goals"));
        }
        StringBuilder wiki = new StringBuilder().append("{info:title=").append("auto generated page").append('}').append("this page has been generated by plugin: ").append("[org.bsc.maven:maven-confluence-reporting-plugin|http://code.google.com/p/maven-confluence-plugin/]").append("{info}").append('\n').append(t.generateOutput());
        page.setContent(wiki.toString());
        page = this.confluence.storePage(page);
    }

    private void writeSummary(Writer writer, PluginDescriptor pluginDescriptor, List<MojoDescriptor> mojos) {
        ConfluenceWikiWriter w = new ConfluenceWikiWriter(writer);
        w.printBiggerHeading("Description");
        String description = pluginDescriptor.getDescription();
        if (null != description) {
            w.println(description);
        }
        w.printNewParagraph();
    }

    private void writeGoals(Writer writer, List<MojoDescriptor> mojos) {
        ConfluenceWikiWriter w = new ConfluenceWikiWriter(writer);
        w.printBiggerHeading("Plugin Goals");
        for (MojoDescriptor descriptor : mojos) {
            w.appendBullet().printLinkToAnchor(descriptor.getGoal(), descriptor.getFullGoalName());
        }
        w.printNewParagraph();
        for (MojoDescriptor descriptor : mojos) {
            this.writeGoal(w, descriptor);
        }
    }

    private void writeGoal(ConfluenceWikiWriter w, MojoDescriptor mojoDescriptor) {
        w.appendBigHeading().appendAnchor(mojoDescriptor.getGoal(), mojoDescriptor.getFullGoalName()).println();
        String description = mojoDescriptor.getDescription() != null ? mojoDescriptor.getDescription() : "No description.";
        w.printQuote(description);
        w.printNewParagraph();
        this.writeGoalAttributes(mojoDescriptor, w);
        w.printNewParagraph();
        this.writeGoalParameterTable(mojoDescriptor, w);
    }

    private void writeGoalAttributes(MojoDescriptor mojoDescriptor, ConfluenceWikiWriter w) {
        w.printNormalHeading("Mojo Attributes");
        String value = mojoDescriptor.getDeprecated();
        if (StringUtils.isNotEmpty((String)value)) {
            w.printBullet("This plugin goal has been deprecated: " + value);
        }
        if (mojoDescriptor.isProjectRequired()) {
            w.printBullet("Requires a Maven 2.0 project to execute.");
        }
        if (mojoDescriptor.isAggregator()) {
            w.printBullet("Executes as an aggregator plugin.");
        }
        if (mojoDescriptor.isDirectInvocationOnly()) {
            w.printBullet("Executes by direct invocation only.");
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.isDependencyResolutionRequired()))) {
            w.printBullet("Requires dependency resolution of artifacts in scope: <code>" + value + "</code>");
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getSince()))) {
            w.printBullet("Since version: <code>" + value + "</code>");
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getPhase()))) {
            w.printBullet("Automatically executes within the lifecycle phase: <code>" + value + "</code>");
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getExecutePhase()))) {
            w.printBullet("Invokes the execution of the lifecycle phase <code>" + value + "</code> prior to executing itself.");
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getExecuteGoal()))) {
            w.printBullet("Invokes the execution of this plugin's goal <code>" + value + "</code> prior to executing itself.");
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getExecuteLifecycle()))) {
            w.printBullet("Executes in its own lifecycle: <code>" + value + "</code>");
        }
        if (mojoDescriptor.isOnlineRequired()) {
            w.printBullet("Requires that mvn runs in online mode.");
        }
        if (!mojoDescriptor.isInheritedByDefault()) {
            w.printBullet("Is NOT inherited by default in multi-project builds.");
        }
    }

    private void writeGoalParameterTable(MojoDescriptor mojoDescriptor, ConfluenceWikiWriter w) {
        List parameterList = mojoDescriptor.getParameters();
        List<Parameter> list = this.filterParameters(parameterList);
        if (list != null && list.size() > 0) {
            this.writeParameterSummary(list, w);
            this.writeParameterDetails(list, w);
        }
    }

    private List<Parameter> filterParameters(List<Parameter> parameterList) {
        ArrayList<Parameter> filtered = new ArrayList<Parameter>();
        if (parameterList != null) {
            for (Parameter parameter : parameterList) {
                String expression;
                if (!parameter.isEditable() || (expression = parameter.getExpression()) != null && expression.startsWith("${component.")) continue;
                filtered.add(parameter);
            }
        }
        return filtered;
    }

    private void writeParameterDetails(List<Parameter> parameterList, ConfluenceWikiWriter w) {
        w.printNormalHeading("Parameter Details");
        w.printNewParagraph();
        for (Parameter parameter : parameterList) {
            w.printSmallHeading(parameter.getName());
            String description = parameter.getDescription();
            if (StringUtils.isEmpty((String)description)) {
                description = "No Description.";
            }
            w.println(ConfluenceUtils.decode((String)description));
            this.writeDetail("Deprecated", parameter.getDeprecated(), w);
            this.writeDetail("Type", parameter.getType(), w);
            this.writeDetail("Since", parameter.getSince(), w);
            if (parameter.isRequired()) {
                this.writeDetail("Required", "Yes", w);
            } else {
                this.writeDetail("Required", "No", w);
            }
            this.writeDetail("Expression", parameter.getExpression(), w);
            this.writeDetail("Default", parameter.getDefaultValue(), w);
        }
    }

    private void writeDetail(String param, String value, ConfluenceWikiWriter w) {
        if (StringUtils.isNotEmpty((String)value)) {
            w.printf("|%s|%s|\n", ConfluenceUtils.decode((String)param), ConfluenceUtils.decode((String)value));
        }
    }

    private void writeParameterSummary(List<Parameter> parameterList, ConfluenceWikiWriter w) {
        List<Parameter> optionalParams;
        List<Parameter> requiredParams = this.getParametersByRequired(true, parameterList);
        if (requiredParams.size() > 0) {
            this.writeParameterList("Required Parameters", requiredParams, w);
        }
        if ((optionalParams = this.getParametersByRequired(false, parameterList)).size() > 0) {
            this.writeParameterList("Optional Parameters", optionalParams, w);
        }
    }

    private void writeParameterList(String title, List<Parameter> parameterList, ConfluenceWikiWriter w) {
        w.printNormalHeading(title);
        w.printNewParagraph();
        w.printf("||%s||%s||%s||\n", "Name", "Type", "Description");
        for (Parameter parameter : parameterList) {
            int index = parameter.getType().lastIndexOf(".");
            w.print('|');
            w.print(parameter.getName());
            w.print('|');
            w.print(parameter.getType().substring(index + 1));
            w.print('|');
            String description = parameter.getDescription();
            if (StringUtils.isEmpty((String)description)) {
                description = "No description.";
            }
            if (StringUtils.isNotEmpty((String)parameter.getDeprecated())) {
                description = "Deprecated. " + description;
            }
            w.print(ConfluenceUtils.decode((String)description.replace('\n', ' ')));
            if (StringUtils.isNotEmpty((String)parameter.getDefaultValue())) {
                w.printf(" Default value is %s", ConfluenceUtils.decode((String)parameter.getDefaultValue()));
            }
            w.println('|');
        }
    }

    private List<Parameter> getParametersByRequired(boolean required, List<Parameter> parameterList) {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (Parameter parameter : parameterList) {
            if (parameter.isRequired() != required) continue;
            list.add(parameter);
        }
        return list;
    }
}

