/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.plugin.confluence;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.tools.plugin.DefaultPluginToolsRequest;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.scanner.MojoScanner;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.bsc.maven.plugin.confluence.ConfluenceUtils;
import org.bsc.maven.plugin.confluence.PluginConfluenceDocGenerator;
import org.bsc.maven.reporting.AbstractConfluenceReportMojo;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.ConfluenceFactory;
import org.codehaus.swizzle.confluence.Page;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoExecute;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;

@MojoExecute(phase="compile")
@MojoGoal(value="plugin-confluence-summary")
public class ConfluenceGeneratePluginDocMojo
extends AbstractConfluenceReportMojo {
    @MojoParameter(expression="${project.build.directory}/generated-site/confluence", required=true)
    private String outputDirectory;
    @MojoComponent
    protected MojoScanner mojoScanner;
    @MojoParameter(expression="${encoding}", defaultValue="${project.build.sourceEncoding}")
    private String encoding;

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        this.getLog().info((CharSequence)String.format("executeReport isSnapshot = [%b] isRemoveSnapshots = [%b]", this.isSnapshot(), this.isRemoveSnapshots()));
        if (!this.project.getPackaging().equals("maven-plugin")) {
            return;
        }
        super.initTemplateProperties();
        String goalPrefix = PluginDescriptor.getGoalPrefixFromArtifactId((String)this.project.getArtifactId());
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setGroupId(this.project.getGroupId());
        pluginDescriptor.setArtifactId(this.project.getArtifactId());
        pluginDescriptor.setVersion(this.project.getVersion());
        pluginDescriptor.setGoalPrefix(goalPrefix);
        try {
            ArrayList dependencies = new ArrayList();
            dependencies.addAll(PluginUtils.toComponentDependencies((List)this.project.getRuntimeDependencies()));
            dependencies.addAll(PluginUtils.toComponentDependencies((List)this.project.getCompileDependencies()));
            pluginDescriptor.setDependencies(dependencies);
            DefaultPluginToolsRequest request = new DefaultPluginToolsRequest(this.project, pluginDescriptor);
            request.setEncoding(this.encoding);
            try {
                this.mojoScanner.populatePluginDescriptor((PluginToolsRequest)request);
            }
            catch (InvalidPluginDescriptorException e) {
                this.getLog().warn((CharSequence)("Plugin without mojos. " + e.getMessage()));
            }
            pluginDescriptor.setDescription(this.project.getDescription());
            this.generatePluginDocumentation(pluginDescriptor);
        }
        catch (ExtractionException e) {
            throw new MavenReportException("Error extracting plugin descriptor: '" + e.getLocalizedMessage() + "'", (Exception)((Object)e));
        }
    }

    public String getDescription(Locale locale) {
        return ConfluenceGeneratePluginDocMojo.getBundle(locale).getString("report.plugin.description");
    }

    public String getName(Locale locale) {
        return "confluence-plugin-report";
    }

    public String getOutputName() {
        return "confluence-plugin-report";
    }

    private void generatePluginDocumentation(PluginDescriptor pluginDescriptor) throws MavenReportException {
        try {
            Confluence.ProxyInfo proxyInfo = null;
            Proxy activeProxy = this.mavenSettings.getActiveProxy();
            if (activeProxy != null) {
                proxyInfo = new Confluence.ProxyInfo(activeProxy.getHost(), activeProxy.getPort(), activeProxy.getUsername(), activeProxy.getPassword());
            }
            Confluence confluence = ConfluenceFactory.createInstanceDetectingVersion((String)this.getEndPoint(), proxyInfo, (String)this.getUsername(), (String)this.getPassword());
            this.getLog().info((CharSequence)ConfluenceUtils.getVersion((Confluence)confluence));
            File outputDir = new File(this.getOutputDirectory());
            outputDir.mkdirs();
            this.getLog().info((CharSequence)("speceKey=" + this.getSpaceKey() + " parentPageTitle=" + this.getParentPageTitle()));
            Page p = confluence.getPage(this.getSpaceKey(), this.getParentPageTitle());
            PluginConfluenceDocGenerator generator = new PluginConfluenceDocGenerator(this, confluence, p, this.templateWiki);
            DefaultPluginToolsRequest request = new DefaultPluginToolsRequest(this.project, pluginDescriptor);
            generator.execute(outputDir, (PluginToolsRequest)request);
            String title = this.getTitle();
            this.generateChildren(confluence, this.getSpaceKey(), title, title);
            confluence.logout();
        }
        catch (Exception e) {
            throw new MavenReportException("Error writing plugin documentation", e);
        }
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("plugin-report", locale, ConfluenceGeneratePluginDocMojo.class.getClassLoader());
    }

    protected Renderer getSiteRenderer() {
        this.getLog().info((CharSequence)"getSiteRenderer");
        return null;
    }
}

