/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.reporting;

import biz.source_code.miniTemplator.MiniTemplator;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.settings.Settings;
import org.bsc.maven.plugin.confluence.ConfluenceUtils;
import org.bsc.maven.reporting.Child;
import org.codehaus.swizzle.confluence.Attachment;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.Page;
import org.jfrog.maven.annomojo.annotations.MojoParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfluenceReportMojo
extends AbstractMavenReport {
    @MojoParameter(description="additional properties pass to template processor")
    private Map properties;
    @MojoParameter(expression="${confluence.endPoint}", defaultValue="http://localhost:8080/rpc/xmlrpc")
    private String endPoint;
    @MojoParameter(expression="${confluence.spaceKey}", required=true)
    private String spaceKey;
    @MojoParameter(expression="${confluence.parentPage}", defaultValue="Home")
    private String parentPageTitle;
    @MojoParameter(expression="${confluence.userName}", defaultValue="admin")
    private String username;
    @MojoParameter(expression="${confluence.password}", required=true)
    private String password;
    @MojoParameter(expression="${project}", readonly=true, required=true)
    protected MavenProject project;
    @MojoParameter(defaultValue="${basedir}/src/site/confluence/template.wiki", description="MiniTemplator source. Default location is ${basedir}/src/site/confluence")
    protected File templateWiki;
    @MojoParameter(deprecated="use children folder instead", description="child pages - &lt;child&gt;&lt;name/&gt;[&lt;source/&gt]&lt;/child&gt")
    private List children = Collections.emptyList();
    @MojoParameter(description="attachment folder", defaultValue="${basedir}/src/site/confluence/attachments")
    private File attachmentFolder;
    @MojoParameter(description="children folder", defaultValue="${basedir}/src/site/confluence/children")
    private File childrenFolder;
    @MojoParameter(expression="${confluence.removeSnapshots}", required=false, defaultValue="false", description="During publish of documentation related to a new release, if it's true, the pages related to SNAPSHOT will be removed ")
    protected boolean removeSnapshots = false;
    @MojoParameter(description="Labels to add")
    List labels;
    @MojoParameter(readonly=true, expression="${settings}")
    protected Settings mavenSettings;
    @MojoParameter(expression="${project.build.finalName}", required=false, description="Confluence Page Title - since 3.1.3")
    private String title;
    @MojoParameter(expression="${wikiFilesExt}", required=false, defaultValue=".wiki", description="wiki files' extension - since 3.2.1")
    private String wikiFilesExt;

    protected final String getTitle() {
        return this.title;
    }

    public String getFileExt() {
        return this.wikiFilesExt.charAt(0) == '.' ? this.wikiFilesExt : ".".concat(this.wikiFilesExt);
    }

    public final Map<String, String> getProperties() {
        if (null == this.properties) {
            this.properties = new HashMap(5);
        }
        return this.properties;
    }

    public final String getEndPoint() {
        return this.endPoint;
    }

    public final String getSpaceKey() {
        return this.spaceKey;
    }

    public final String getParentPageTitle() {
        return this.parentPageTitle;
    }

    public final String getUsername() {
        return this.username;
    }

    public final String getPassword() {
        return this.password;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public boolean isRemoveSnapshots() {
        return this.removeSnapshots;
    }

    public boolean isSnapshot() {
        String version = this.project.getVersion();
        return version != null && version.endsWith("-SNAPSHOT");
    }

    public List<String> getLabels() {
        return this.labels == null ? Collections.emptyList() : this.labels;
    }

    protected void initTemplateProperties() {
        this.getProperties().put("pageTitle", this.getTitle());
        this.getProperties().put("parentPageTitle", this.getParentPageTitle());
        this.getProperties().put("artifactId", this.project.getArtifactId());
        this.getProperties().put("version", this.project.getVersion());
        this.getProperties().put("groupId", this.project.getGroupId());
        this.getProperties().put("name", this.project.getName());
        this.getProperties().put("description", this.project.getDescription());
        Properties projectProps = this.project.getProperties();
        if (projectProps != null) {
            for (Map.Entry<Object, Object> e : projectProps.entrySet()) {
                this.getProperties().put(String.valueOf(e.getKey()), String.valueOf(e.getValue()));
            }
        }
    }

    public void addProperties(MiniTemplator t) {
        Map<String, String> props = this.getProperties();
        if (props == null || props.isEmpty()) {
            this.getLog().info((CharSequence)"no properties set!");
        } else {
            for (Map.Entry<String, String> e : props.entrySet()) {
                this.getLog().debug((CharSequence)String.format("property %s = %s", e.getKey(), e.getValue()));
                try {
                    t.setVariable(e.getKey(), e.getValue(), true);
                }
                catch (MiniTemplator.VariableNotDefinedException e1) {
                    this.getLog().warn((CharSequence)String.format("variable %s not defined in template", e.getKey()));
                }
            }
        }
    }

    private boolean generateChild(Confluence confluence, String spaceKey, String parentPageTitle, Child child, String titlePrefix) {
        File source = child.getSource(this.getProject(), this.getFileExt());
        this.getLog().info((CharSequence)String.format("generateChild spacekey=[%s] parentPageTtile=[%s]\n%s", spaceKey, parentPageTitle, child.toString()));
        try {
            String snapshot;
            boolean deleted;
            if (!this.isSnapshot() && this.isRemoveSnapshots() && (deleted = ConfluenceUtils.removePage((Confluence)confluence, (String)spaceKey, (String)parentPageTitle, (String)(snapshot = titlePrefix.concat("-SNAPSHOT"))))) {
                this.getLog().info((CharSequence)String.format("Page [%s] has been removed!", snapshot));
            }
            String pageName = String.format("%s - %s", titlePrefix, child.getName());
            Page p = ConfluenceUtils.getOrCreatePage((Confluence)confluence, (String)spaceKey, (String)parentPageTitle, (String)pageName);
            if (source != null && source.isFile() && source.exists()) {
                MiniTemplator t = new MiniTemplator((Reader)new FileReader(source));
                this.addProperties(t);
                p.setContent(t.generateOutput());
            }
            p = confluence.storePage(p);
            for (String label : this.getLabels()) {
                confluence.addLabelByName(label, Long.parseLong(p.getId()));
            }
            child.setName(pageName);
            return true;
        }
        catch (Exception e) {
            String msg = "error loading template";
            this.getLog().error((CharSequence)"error loading template", (Throwable)e);
            return false;
        }
    }

    protected void generateChildrenFromChild(final Confluence confluence, File folder, final String spaceKey, final Child parentChild) {
        this.getLog().info((CharSequence)String.format("generateChildrenFromChild [%s]", folder.getAbsolutePath()));
        if (folder.exists() && folder.isDirectory()) {
            folder.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    AbstractConfluenceReportMojo.this.getLog().info((CharSequence)String.format("generateChildrenFromChild\n\t process file [%s]", file.getPath()));
                    if (file.isHidden() || file.getName().charAt(0) == '.') {
                        return false;
                    }
                    if (file.isDirectory()) {
                        Child child = new Child();
                        child.setName(file.getName());
                        child.setSource(new File(file, AbstractConfluenceReportMojo.this.templateWiki.getName()));
                        if (AbstractConfluenceReportMojo.this.generateChild(confluence, spaceKey, parentChild.getName(), child, parentChild.getName())) {
                            AbstractConfluenceReportMojo.this.generateChildrenFromChild(confluence, file, spaceKey, child);
                        }
                        return true;
                    }
                    String fileName = file.getName();
                    if (!file.isFile() || !file.canRead() || !fileName.endsWith(AbstractConfluenceReportMojo.this.getFileExt()) || fileName.equals(AbstractConfluenceReportMojo.this.templateWiki.getName())) {
                        return false;
                    }
                    Child child = new Child();
                    int extensionLen = AbstractConfluenceReportMojo.this.getFileExt().length();
                    child.setName(fileName.substring(0, fileName.length() - extensionLen));
                    child.setSource(file);
                    AbstractConfluenceReportMojo.this.generateChild(confluence, spaceKey, parentChild.getName(), child, parentChild.getName());
                    return false;
                }
            });
        }
    }

    protected void generateChildren(final Confluence confluence, final String spaceKey, final String parentPageTitle, final String titlePrefix) {
        this.getLog().info((CharSequence)String.format("generateChildren # [%d]", this.children.size()));
        for (Child child : this.children) {
            this.generateChild(confluence, spaceKey, parentPageTitle, child, titlePrefix);
        }
        if (this.childrenFolder.exists() && this.childrenFolder.isDirectory()) {
            this.childrenFolder.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    AbstractConfluenceReportMojo.this.getLog().info((CharSequence)String.format("generateChildren\n\t process file [%s]", file.getPath()));
                    if (file.isHidden() || file.getName().charAt(0) == '.') {
                        return false;
                    }
                    if (file.isDirectory()) {
                        Child parentChild = new Child();
                        parentChild.setName(file.getName());
                        parentChild.setSource(new File(file, AbstractConfluenceReportMojo.this.templateWiki.getName()));
                        if (AbstractConfluenceReportMojo.this.generateChild(confluence, spaceKey, parentPageTitle, parentChild, titlePrefix)) {
                            AbstractConfluenceReportMojo.this.generateChildrenFromChild(confluence, file, spaceKey, parentChild);
                        }
                        return false;
                    }
                    String fileName = file.getName();
                    if (!file.isFile() || !file.canRead() || !fileName.endsWith(AbstractConfluenceReportMojo.this.getFileExt()) || fileName.equals(AbstractConfluenceReportMojo.this.templateWiki.getName())) {
                        return false;
                    }
                    Child child = new Child();
                    int extensionLen = AbstractConfluenceReportMojo.this.getFileExt().length();
                    child.setName(fileName.substring(0, fileName.length() - extensionLen));
                    child.setSource(file);
                    AbstractConfluenceReportMojo.this.generateChild(confluence, spaceKey, parentPageTitle, child, titlePrefix);
                    return false;
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generateAttachments(Confluence confluence, Page page) {
        this.getLog().info((CharSequence)String.format("generateAttachments pageId [%s]", page.getId()));
        File[] files = this.attachmentFolder.listFiles();
        if (files == null || files.length == 0) {
            this.getLog().info((CharSequence)String.format("No attachments found in folder [%s] ", this.attachmentFolder.getPath()));
            return;
        }
        String version = "0";
        File[] arr$ = files;
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            block7: {
                Attachment a;
                File f;
                block10: {
                    block8: {
                        block11: {
                            Date date;
                            block9: {
                                if (i$ >= len$) {
                                    return;
                                }
                                f = arr$[i$];
                                if (f.isDirectory() || f.isHidden()) break block7;
                                a = null;
                                try {
                                    a = confluence.getAttachment(page.getId(), f.getName(), "0");
                                }
                                catch (Exception e) {
                                    this.getLog().warn((CharSequence)String.format("Error getting attachment [%s] from confluence: [%s]", f.getName(), e.getMessage()));
                                }
                                if (a == null) break block8;
                                date = a.getCreated();
                                if (date != null) break block9;
                                this.getLog().warn((CharSequence)String.format("creation date of attachments [%s] is undefined. It will be replaced! ", a.getFileName()));
                                break block10;
                            }
                            if (f.lastModified() <= date.getTime()) break block11;
                            this.getLog().info((CharSequence)String.format("attachment [%s] is more recent than the remote one. It will be replaced! ", a.getFileName()));
                            break block10;
                        }
                        this.getLog().info((CharSequence)String.format("attachment [%s] skipped! no updated detected", a.getFileName()));
                        break block7;
                    }
                    a = new Attachment();
                    a.setComment("attached by maven-confluence-plugin");
                    a.setFileName(f.getName());
                    a.setContentType("application/octet-stream");
                }
                try {
                    ConfluenceUtils.addAttchment((Confluence)confluence, (Page)page, (Attachment)a, (File)f);
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)String.format("Error uploading attachment [%s] ", f.getName()), (Throwable)e);
                }
            }
            ++i$;
        }
    }
}

