/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.plugin.confluence;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.tools.plugin.DefaultPluginToolsRequest;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.generator.GeneratorUtils;
import org.apache.maven.tools.plugin.scanner.MojoScanner;
import org.bsc.maven.plugin.confluence.ConfluenceUtils;
import org.bsc.maven.plugin.confluence.PluginConfluenceDocGenerator;
import org.bsc.maven.reporting.AbstractConfluenceReportMojo;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.ConfluenceFactory;
import org.codehaus.swizzle.confluence.Page;

@Mojo(name="plugin-confluence-summary", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.SITE)
public class ConfluenceGeneratePluginDocMojo
extends AbstractConfluenceReportMojo {
    @Parameter(defaultValue="${project.build.directory}/generated-site/confluence", required=true)
    private String outputDirectory;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    protected ArtifactRepository local;
    @Parameter(defaultValue="${project.artifacts}", required=true, readonly=true)
    protected Set<Artifact> dependencies;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    protected List<ArtifactRepository> remoteRepos;
    @Component
    protected MojoScanner mojoScanner;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected static List<ComponentDependency> toComponentDependencies(List<Dependency> dependencies) {
        return GeneratorUtils.toComponentDependencies(dependencies);
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        this.getLog().info((CharSequence)String.format("executeReport isSnapshot = [%b] isRemoveSnapshots = [%b]", this.isSnapshot(), this.isRemoveSnapshots()));
        if (!this.project.getPackaging().equals("maven-plugin")) {
            return;
        }
        try {
            this.loadUserInfoFromSettings();
        }
        catch (MojoExecutionException ex) {
            throw new MavenReportException("error reading credential", (Exception)((Object)ex));
        }
        super.initTemplateProperties();
        String goalPrefix = PluginDescriptor.getGoalPrefixFromArtifactId((String)this.project.getArtifactId());
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setGroupId(this.project.getGroupId());
        pluginDescriptor.setArtifactId(this.project.getArtifactId());
        pluginDescriptor.setVersion(this.project.getVersion());
        pluginDescriptor.setGoalPrefix(goalPrefix);
        try {
            ArrayList<ComponentDependency> deps = new ArrayList<ComponentDependency>();
            deps.addAll(ConfluenceGeneratePluginDocMojo.toComponentDependencies(this.project.getRuntimeDependencies()));
            deps.addAll(ConfluenceGeneratePluginDocMojo.toComponentDependencies(this.project.getCompileDependencies()));
            pluginDescriptor.setDependencies(deps);
            pluginDescriptor.setDescription(this.project.getDescription());
            DefaultPluginToolsRequest request = new DefaultPluginToolsRequest(this.project, pluginDescriptor);
            request.setEncoding(this.encoding);
            request.setLocal(this.local);
            request.setRemoteRepos(this.remoteRepos);
            request.setSkipErrorNoDescriptorsFound(false);
            request.setDependencies(this.dependencies);
            try {
                this.mojoScanner.populatePluginDescriptor((PluginToolsRequest)request);
            }
            catch (InvalidPluginDescriptorException e) {
                this.getLog().warn((CharSequence)("Plugin without mojos. " + e.getMessage()));
            }
            this.generatePluginDocumentation(pluginDescriptor);
        }
        catch (ExtractionException e) {
            throw new MavenReportException("Error extracting plugin descriptor: '" + e.getLocalizedMessage() + "'", (Exception)((Object)e));
        }
    }

    public String getDescription(Locale locale) {
        return ConfluenceGeneratePluginDocMojo.getBundle(locale).getString("report.plugin.description");
    }

    public String getName(Locale locale) {
        return "confluence-plugin-report";
    }

    public String getOutputName() {
        return "confluence-plugin-report";
    }

    private void generatePluginDocumentation(PluginDescriptor pluginDescriptor) throws MavenReportException {
        try {
            Confluence.ProxyInfo proxyInfo = null;
            Proxy activeProxy = this.mavenSettings.getActiveProxy();
            if (activeProxy != null) {
                proxyInfo = new Confluence.ProxyInfo(activeProxy.getHost(), activeProxy.getPort(), activeProxy.getUsername(), activeProxy.getPassword());
            }
            Confluence confluence = ConfluenceFactory.createInstanceDetectingVersion((String)this.getEndPoint(), proxyInfo, (String)this.getUsername(), (String)this.getPassword());
            this.getLog().info((CharSequence)ConfluenceUtils.getVersion((Confluence)confluence));
            File outputDir = new File(this.getOutputDirectory());
            outputDir.mkdirs();
            this.getLog().info((CharSequence)("speceKey=" + this.getSpaceKey() + " parentPageTitle=" + this.getParentPageTitle()));
            Page p = confluence.getPage(this.getSpaceKey(), this.getParentPageTitle());
            PluginConfluenceDocGenerator generator = new PluginConfluenceDocGenerator(this, confluence, p, this.templateWiki);
            DefaultPluginToolsRequest request = new DefaultPluginToolsRequest(this.project, pluginDescriptor);
            generator.execute(outputDir, (PluginToolsRequest)request);
            String title = this.getTitle();
            this.generateChildren(confluence, this.getSpaceKey(), title, title);
            confluence.logout();
        }
        catch (Exception e) {
            throw new MavenReportException("Error writing plugin documentation", e);
        }
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("plugin-report", locale, ConfluenceGeneratePluginDocMojo.class.getClassLoader());
    }

    protected Renderer getSiteRenderer() {
        this.getLog().info((CharSequence)"getSiteRenderer");
        return null;
    }
}

