/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.reporting;

import biz.source_code.miniTemplator.MiniTemplator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.bsc.maven.plugin.confluence.ConfluenceUtils;
import org.bsc.maven.reporting.model.Child;
import org.bsc.maven.reporting.model.ProcessUriException;
import org.bsc.maven.reporting.model.Site;
import org.codehaus.swizzle.confluence.Attachment;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.Page;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public abstract class AbstractConfluenceReportMojo
extends AbstractMavenReport {
    @Parameter
    private Map properties;
    @Parameter(property="confluence.endPoint", defaultValue="http://localhost:8080/rpc/xmlrpc")
    private String endPoint;
    @Parameter(property="confluence.spaceKey", required=true)
    private String spaceKey;
    @Parameter(property="confluence.parentPage", defaultValue="Home")
    private String parentPageTitle;
    @Parameter(property="confluence.userName", required=false)
    private String username;
    @Parameter(property="confluence.password", required=false)
    private String password;
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${basedir}/src/site/confluence/template.wiki")
    protected File templateWiki;
    @Parameter
    private List children = Collections.emptyList();
    @Parameter(defaultValue="${basedir}/src/site/confluence/attachments")
    private File attachmentFolder;
    @Parameter(defaultValue="${basedir}/src/site/confluence/children")
    private File childrenFolder;
    @Parameter(property="confluence.removeSnapshots", required=false, defaultValue="false")
    protected boolean removeSnapshots = false;
    @Parameter
    List<String> labels;
    @Parameter(readonly=true, property="settings")
    protected Settings mavenSettings;
    @Parameter(property="project.build.finalName", required=false)
    private String title;
    @Parameter(property="wikiFilesExt", required=false, defaultValue=".wiki")
    private String wikiFilesExt;
    @Parameter(property="confluence.serverId")
    private String serverId;
    @Component(role=SecDispatcher.class, hint="default")
    private SecDispatcher securityDispatcher;

    protected List<Child> getChildren() {
        return this.children;
    }

    protected File getChildrenFolder() {
        return this.childrenFolder;
    }

    protected File getAttachmentFolder() {
        return this.attachmentFolder;
    }

    protected final String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFileExt() {
        return this.wikiFilesExt.charAt(0) == '.' ? this.wikiFilesExt : ".".concat(this.wikiFilesExt);
    }

    public final Map<String, String> getProperties() {
        if (null == this.properties) {
            this.properties = new HashMap(5);
        }
        return this.properties;
    }

    public final String getEndPoint() {
        return this.endPoint;
    }

    public final String getSpaceKey() {
        return this.spaceKey;
    }

    public final String getParentPageTitle() {
        return this.parentPageTitle;
    }

    public final String getUsername() {
        return this.username;
    }

    public final String getPassword() {
        return this.password;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public boolean isRemoveSnapshots() {
        return this.removeSnapshots;
    }

    public boolean isSnapshot() {
        String version = this.project.getVersion();
        return version != null && version.endsWith("-SNAPSHOT");
    }

    public List<String> getLabels() {
        if (this.labels == null) {
            return Collections.emptyList();
        }
        return this.labels;
    }

    protected void loadUserInfoFromSettings() throws MojoExecutionException {
        if ((this.getUsername() == null || this.getPassword() == null) && this.mavenSettings != null) {
            if (this.serverId == null) {
                throw new MojoExecutionException("SettingKey must be set! (username and/or password are not provided)");
            }
            Server server = this.mavenSettings.getServer(this.serverId);
            if (server == null) {
                throw new MojoExecutionException(String.format("server with id [%s] not found in settings!", this.serverId));
            }
            if (this.getUsername() == null && server.getUsername() != null) {
                this.username = server.getUsername();
            }
            if (this.getPassword() == null && server.getPassword() != null) {
                try {
                    if (this.securityDispatcher instanceof DefaultSecDispatcher) {
                        ((DefaultSecDispatcher)this.securityDispatcher).setConfigurationFile("~/.m2/settings-security.xml");
                    }
                    this.password = this.securityDispatcher.decrypt(server.getPassword());
                }
                catch (SecDispatcherException e) {
                    throw new MojoExecutionException(e.getMessage());
                }
            }
        }
    }

    protected void initTemplateProperties() {
        this.processProperties();
        this.getProperties().put("pageTitle", this.getTitle());
        this.getProperties().put("parentPageTitle", this.getParentPageTitle());
        this.getProperties().put("artifactId", this.project.getArtifactId());
        this.getProperties().put("version", this.project.getVersion());
        this.getProperties().put("groupId", this.project.getGroupId());
        this.getProperties().put("name", this.project.getName());
        this.getProperties().put("description", this.project.getDescription());
        Properties projectProps = this.project.getProperties();
        if (projectProps != null) {
            for (Map.Entry<Object, Object> e : projectProps.entrySet()) {
                this.getProperties().put(String.valueOf(e.getKey()), String.valueOf(e.getValue()));
            }
        }
    }

    public void addProperties(MiniTemplator t) {
        Map<String, String> props = this.getProperties();
        if (props == null || props.isEmpty()) {
            this.getLog().info((CharSequence)"no properties set!");
        } else {
            for (Map.Entry<String, String> e : props.entrySet()) {
                try {
                    t.setVariable(e.getKey(), e.getValue(), true);
                }
                catch (MiniTemplator.VariableNotDefinedException e1) {
                    this.getLog().warn((CharSequence)String.format("variable %s not defined in template", e.getKey()));
                }
            }
        }
    }

    protected <T extends Site.Page> Page generateChild(Confluence confluence, T child, String spaceKey, String parentPageTitle, String titlePrefix) {
        URI source = child.getUri(this.getProject(), this.getFileExt());
        this.getLog().info((CharSequence)String.format("generateChild spacekey=[%s] parentPageTtile=[%s]\n%s", spaceKey, parentPageTitle, child.toString()));
        try {
            String snapshot;
            boolean deleted;
            if (!this.isSnapshot() && this.isRemoveSnapshots() && (deleted = ConfluenceUtils.removePage((Confluence)confluence, (String)spaceKey, (String)parentPageTitle, (String)(snapshot = titlePrefix.concat("-SNAPSHOT"))))) {
                this.getLog().info((CharSequence)String.format("Page [%s] has been removed!", snapshot));
            }
            String pageName = String.format("%s - %s", titlePrefix, child.getName());
            Page p = ConfluenceUtils.getOrCreatePage((Confluence)confluence, (String)spaceKey, (String)parentPageTitle, (String)pageName);
            if (source != null) {
                MiniTemplator t = new MiniTemplator.Builder().setSkipUndefinedVars(true).build(Site.processUri(source));
                this.addProperties(t);
                p.setContent(t.generateOutput());
            }
            p = confluence.storePage(p);
            for (String label : child.getComputedLabels()) {
                confluence.addLabelByName(label, Long.parseLong(p.getId()));
            }
            child.setName(pageName);
            return p;
        }
        catch (Exception e) {
            String msg = "error loading template";
            this.getLog().error((CharSequence)"error loading template", (Throwable)e);
            return null;
        }
    }

    @Deprecated
    protected <T extends Site.Page> void generateChildrenFromChild(final Confluence confluence, File folder, final String spaceKey, final T parentChild) {
        this.getLog().info((CharSequence)String.format("generateChildrenFromChild [%s]", folder.getAbsolutePath()));
        if (folder.exists() && folder.isDirectory()) {
            folder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    AbstractConfluenceReportMojo.this.getLog().info((CharSequence)String.format("generateChildrenFromChild\n\t process file [%s]", file.getPath()));
                    if (file.isHidden() || file.getName().charAt(0) == '.') {
                        return false;
                    }
                    if (file.isDirectory()) {
                        Child child = new Child();
                        child.setName(file.getName());
                        child.setSource(new File(file, AbstractConfluenceReportMojo.this.templateWiki.getName()));
                        if (AbstractConfluenceReportMojo.this.generateChild(confluence, child, spaceKey, parentChild.getName(), parentChild.getName()) != null) {
                            AbstractConfluenceReportMojo.this.generateChildrenFromChild(confluence, file, spaceKey, child);
                        }
                        return true;
                    }
                    String fileName = file.getName();
                    if (!file.isFile() || !file.canRead() || !fileName.endsWith(AbstractConfluenceReportMojo.this.getFileExt()) || fileName.equals(AbstractConfluenceReportMojo.this.templateWiki.getName())) {
                        return false;
                    }
                    Child child = new Child();
                    int extensionLen = AbstractConfluenceReportMojo.this.getFileExt().length();
                    child.setName(fileName.substring(0, fileName.length() - extensionLen));
                    child.setSource(file);
                    AbstractConfluenceReportMojo.this.generateChild(confluence, child, spaceKey, parentChild.getName(), parentChild.getName());
                    return false;
                }
            });
        }
    }

    @Deprecated
    protected void generateChildren(final Confluence confluence, final String spaceKey, final String parentPageTitle, final String titlePrefix) {
        this.getLog().info((CharSequence)String.format("generateChildren # [%d]", this.children.size()));
        for (Child child : this.children) {
            this.generateChild(confluence, child, spaceKey, parentPageTitle, titlePrefix);
        }
        if (this.childrenFolder.exists() && this.childrenFolder.isDirectory()) {
            this.childrenFolder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    AbstractConfluenceReportMojo.this.getLog().info((CharSequence)String.format("generateChildren\n\t process file [%s]", file.getPath()));
                    if (file.isHidden() || file.getName().charAt(0) == '.') {
                        return false;
                    }
                    if (file.isDirectory()) {
                        Child parentChild = new Child();
                        parentChild.setName(file.getName());
                        parentChild.setSource(new File(file, AbstractConfluenceReportMojo.this.templateWiki.getName()));
                        if (AbstractConfluenceReportMojo.this.generateChild(confluence, parentChild, spaceKey, parentPageTitle, titlePrefix) != null) {
                            AbstractConfluenceReportMojo.this.generateChildrenFromChild(confluence, file, spaceKey, parentChild);
                        }
                        return false;
                    }
                    String fileName = file.getName();
                    if (!file.isFile() || !file.canRead() || !fileName.endsWith(AbstractConfluenceReportMojo.this.getFileExt()) || fileName.equals(AbstractConfluenceReportMojo.this.templateWiki.getName())) {
                        return false;
                    }
                    Child child = new Child();
                    int extensionLen = AbstractConfluenceReportMojo.this.getFileExt().length();
                    child.setName(fileName.substring(0, fileName.length() - extensionLen));
                    child.setSource(file);
                    AbstractConfluenceReportMojo.this.generateChild(confluence, child, spaceKey, parentPageTitle, titlePrefix);
                    return false;
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    protected void generateAttachments(Confluence confluence, Page page) {
        this.getLog().info((CharSequence)String.format("generateAttachments pageId [%s]", page.getId()));
        File[] files = this.attachmentFolder.listFiles();
        if (files == null || files.length == 0) {
            this.getLog().info((CharSequence)String.format("No attachments found in folder [%s] ", this.attachmentFolder.getPath()));
            return;
        }
        String version = "0";
        File[] arr$ = files;
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            block7: {
                Attachment a;
                File f;
                block10: {
                    block8: {
                        block11: {
                            Date date;
                            block9: {
                                if (i$ >= len$) {
                                    return;
                                }
                                f = arr$[i$];
                                if (f.isDirectory() || f.isHidden()) break block7;
                                a = null;
                                try {
                                    a = confluence.getAttachment(page.getId(), f.getName(), "0");
                                }
                                catch (Exception e) {
                                    this.getLog().warn((CharSequence)String.format("Error getting attachment [%s] from confluence: [%s]", f.getName(), e.getMessage()));
                                }
                                if (a == null) break block8;
                                date = a.getCreated();
                                if (date != null) break block9;
                                this.getLog().warn((CharSequence)String.format("creation date of attachments [%s] is undefined. It will be replaced! ", a.getFileName()));
                                break block10;
                            }
                            if (f.lastModified() <= date.getTime()) break block11;
                            this.getLog().info((CharSequence)String.format("attachment [%s] is more recent than the remote one. It will be replaced! ", a.getFileName()));
                            break block10;
                        }
                        this.getLog().info((CharSequence)String.format("attachment [%s] skipped! no updated detected", a.getFileName()));
                        break block7;
                    }
                    a = new Attachment();
                    a.setComment(String.format("%s - attached by maven-confluence-plugin", f.getName()));
                    a.setFileName(f.getName());
                    a.setContentType("application/octet-stream");
                }
                try {
                    ConfluenceUtils.addAttchment((Confluence)confluence, (Page)page, (Attachment)a, (File)f);
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)String.format("Error uploading attachment [%s] ", f.getName()), (Throwable)e);
                }
            }
            ++i$;
        }
    }

    private void processProperties() {
        for (Map.Entry<String, String> e : this.getProperties().entrySet()) {
            try {
                URI uri = new URI(e.getValue());
                if (uri.getScheme() == null) continue;
                this.getProperties().put(e.getKey(), this.processUri(uri));
            }
            catch (ProcessUriException ex) {
                this.getLog().warn((CharSequence)String.format("error processing value of property [%s]\n%s", e.getKey(), ex.getMessage()));
                if (ex.getCause() == null) continue;
                this.getLog().debug(ex.getCause());
            }
            catch (URISyntaxException ex) {
                this.getLog().debug((CharSequence)String.format("property [%s] is not a valid uri", e.getKey()));
            }
        }
    }

    private String processUri(URI uri) throws ProcessUriException {
        try {
            return this.toString(Site.processUri(uri));
        }
        catch (Exception ex) {
            throw new ProcessUriException("error reading content!", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toString(Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException("reader");
        }
        Reader r = null;
        try {
            int c;
            r = reader instanceof BufferedReader ? reader : new BufferedReader(reader);
            StringBuilder contents = new StringBuilder(4096);
            while ((c = r.read()) != -1) {
                contents.append((char)c);
            }
            String string = contents.toString();
            return string;
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }
}

