/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.reporting;

import biz.source_code.miniTemplator.MiniTemplator;
import java.io.File;
import java.io.StringWriter;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.settings.Proxy;
import org.bsc.maven.plugin.confluence.ConfluenceUtils;
import org.bsc.maven.reporting.AbstractConfluenceSiteReportMojo;
import org.bsc.maven.reporting.ReportingResolutionListener;
import org.bsc.maven.reporting.model.Site;
import org.bsc.maven.reporting.renderer.DependenciesRenderer;
import org.bsc.maven.reporting.renderer.ProjectSummaryRenderer;
import org.bsc.maven.reporting.renderer.ScmRenderer;
import org.bsc.maven.reporting.sink.ConfluenceSink;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.ConfluenceFactory;
import org.codehaus.swizzle.confluence.Page;

@Mojo(name="confluence-summary", defaultPhase=LifecyclePhase.SITE)
public class ConfluenceReportMojo
extends AbstractConfluenceSiteReportMojo {
    private static final String PROJECT_DEPENDENCIES_VAR = "project.dependencies";
    private static final String PROJECT_SCM_MANAGER_VAR = "project.scmManager";
    private static final String PROJECT_SUMMARY_VAR = "project.summary";
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    protected ArtifactRepository localRepository;
    @Component
    protected ArtifactMetadataSource artifactMetadataSource;
    @Component
    private ArtifactCollector collector;
    @Component(role=ArtifactFactory.class)
    protected ArtifactFactory factory;
    @Component
    private MavenProjectBuilder mavenProjectBuilder;
    @Component
    protected I18N i18n;
    @Parameter(property="project.reporting.outputDirectory")
    protected File outputDirectory;
    @Component(role=ScmManager.class)
    protected ScmManager scmManager;
    @Parameter(defaultValue="${project.artifactId}", required=true)
    private String checkoutDirectoryName;
    @Parameter(defaultValue="${project.scm.connection}")
    private String anonymousConnection;
    @Parameter(defaultValue="${project.scm.developerConnection}")
    private String developerConnection;
    @Parameter(defaultValue="${project.scm.url}")
    private String webAccessUrl;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"execute");
        try {
            super.execute();
        }
        catch (Throwable t) {
            this.getLog().error(t);
        }
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        this.getLog().info((CharSequence)String.format("executeReport isSnapshot = [%b] isRemoveSnapshots = [%b]", this.isSnapshot(), this.isRemoveSnapshots()));
        try {
            this.loadUserInfoFromSettings();
        }
        catch (MojoExecutionException ex) {
            throw new MavenReportException("error reading credential", (Exception)((Object)ex));
        }
        Site site = null;
        if (this.isSiteDescriptorValid()) {
            site = super.createFromModel();
        }
        if (site != null) {
            site.setBasedir(this.getSiteDescriptor());
            if (site.getHome().getName() != null) {
                this.setTitle(site.getHome().getName());
            } else {
                site.getHome().setName(this.getTitle());
            }
            List<String> _labels = this.getLabels();
            if (!_labels.isEmpty()) {
                site.getLabels().addAll(_labels);
            }
        } else {
            site = super.createFromFolder();
        }
        site.print(System.out);
        super.initTemplateProperties();
        String title = this.getTitle();
        MiniTemplator t = null;
        try {
            t = new MiniTemplator.Builder().setSkipUndefinedVars(true).build(Site.processUri(site.getHome().getUri()));
        }
        catch (Exception e) {
            String msg = "error loading template";
            this.getLog().error((CharSequence)"error loading template", (Throwable)e);
            throw new MavenReportException("error loading template", e);
        }
        super.addProperties(t);
        StringWriter w = new StringWriter(10240);
        ConfluenceSink sink = new ConfluenceSink(w, this.getSink());
        new ProjectSummaryRenderer((Sink)sink, this.project, this.i18n, locale).render();
        try {
            String project_summary_var = w.toString();
            this.getProperties().put(PROJECT_SUMMARY_VAR, project_summary_var);
            t.setVariable(PROJECT_SUMMARY_VAR, project_summary_var);
        }
        catch (MiniTemplator.VariableNotDefinedException e) {
            this.getLog().warn((CharSequence)String.format("variable %s not defined in template", PROJECT_SUMMARY_VAR));
        }
        w = new StringWriter(10240);
        sink = new ConfluenceSink(w, this.getSink());
        new ScmRenderer(this.scmManager, (Sink)sink, this.project.getModel(), this.i18n, locale, this.checkoutDirectoryName, this.webAccessUrl, this.anonymousConnection, this.developerConnection).render();
        try {
            String project_scm_var = w.toString();
            this.getProperties().put(PROJECT_SCM_MANAGER_VAR, project_scm_var);
            t.setVariable(PROJECT_SCM_MANAGER_VAR, project_scm_var);
        }
        catch (MiniTemplator.VariableNotDefinedException e) {
            this.getLog().warn((CharSequence)String.format("variable %s not defined in template", PROJECT_SCM_MANAGER_VAR));
        }
        w = new StringWriter(10240);
        sink = new ConfluenceSink(w, this.getSink());
        new DependenciesRenderer((Sink)sink, this.project, this.mavenProjectBuilder, this.localRepository, this.factory, this.i18n, locale, this.resolveProject(), this.getLog()).render();
        try {
            String project_dependencies_var = w.toString();
            this.getProperties().put(PROJECT_DEPENDENCIES_VAR, project_dependencies_var);
            t.setVariable(PROJECT_DEPENDENCIES_VAR, project_dependencies_var);
        }
        catch (MiniTemplator.VariableNotDefinedException e) {
            this.getLog().warn((CharSequence)String.format("variable %s not defined in template", PROJECT_DEPENDENCIES_VAR));
        }
        String wiki = t.generateOutput();
        Confluence confluence = null;
        try {
            Confluence.ProxyInfo proxyInfo = null;
            Proxy activeProxy = this.mavenSettings.getActiveProxy();
            if (activeProxy != null) {
                proxyInfo = new Confluence.ProxyInfo(activeProxy.getHost(), activeProxy.getPort(), activeProxy.getUsername(), activeProxy.getPassword());
            }
            confluence = ConfluenceFactory.createInstanceDetectingVersion((String)this.getEndPoint(), proxyInfo, (String)this.getUsername(), (String)this.getPassword());
            this.getLog().info((CharSequence)ConfluenceUtils.getVersion((Confluence)confluence));
            if (!this.isSnapshot() && this.isRemoveSnapshots()) {
                String snapshot = title.concat("-SNAPSHOT");
                this.getLog().info((CharSequence)String.format("removing page [%s]!", snapshot));
                boolean deleted = ConfluenceUtils.removePage((Confluence)confluence, (String)this.getSpaceKey(), (String)this.getParentPageTitle(), (String)snapshot);
                if (deleted) {
                    this.getLog().info((CharSequence)String.format("Page [%s] has been removed!", snapshot));
                }
            }
            Page confluencePage = ConfluenceUtils.getOrCreatePage((Confluence)confluence, (String)this.getSpaceKey(), (String)this.getParentPageTitle(), (String)title);
            confluencePage.setContent(wiki);
            confluencePage = confluence.storePage(confluencePage);
            for (String label : site.getHome().getComputedLabels()) {
                confluence.addLabelByName(label, Long.parseLong(confluencePage.getId()));
            }
            this.generateChildren(confluence, site.getHome(), confluencePage, this.getSpaceKey(), title, title);
        }
        catch (Exception e) {
            try {
                String msg = "has been imposssible connect to confluence due exception";
                this.getLog().warn((CharSequence)"has been imposssible connect to confluence due exception", (Throwable)e);
                throw new MavenReportException("has been imposssible connect to confluence due exception", e);
            }
            catch (Throwable throwable) {
                this.confluenceLogout(confluence);
                throw throwable;
            }
        }
        this.confluenceLogout(confluence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeReport3_2_x(Locale locale) throws MavenReportException {
        this.getLog().info((CharSequence)String.format("executeReport isSnapshot = [%b] isRemoveSnapshots = [%b]", this.isSnapshot(), this.isRemoveSnapshots()));
        try {
            this.loadUserInfoFromSettings();
        }
        catch (MojoExecutionException ex) {
            throw new MavenReportException("error reading credential", (Exception)((Object)ex));
        }
        String title = this.getTitle();
        super.initTemplateProperties();
        MiniTemplator t = null;
        if (this.templateWiki == null || !this.templateWiki.exists()) {
            this.getLog().warn((CharSequence)"template not set! default using ...");
            URL sourceUrl = this.getClass().getClassLoader().getResource("defaultTemplate.confluence");
            if (sourceUrl == null) {
                String msg = "default template cannot be found";
                this.getLog().error((CharSequence)"default template cannot be found");
                throw new MavenReportException("default template cannot be found");
            }
            try {
                t = new MiniTemplator.Builder().setSkipUndefinedVars(true).build(sourceUrl);
            }
            catch (Exception e) {
                String msg = "error loading template";
                this.getLog().error((CharSequence)"error loading template", (Throwable)e);
                throw new MavenReportException("error loading template", e);
            }
        }
        try {
            t = new MiniTemplator.Builder().setSkipUndefinedVars(true).build(Site.processUri(this.templateWiki.toURI()));
        }
        catch (Exception e) {
            String msg = "error loading template";
            this.getLog().error((CharSequence)"error loading template", (Throwable)e);
            throw new MavenReportException("error loading template", e);
        }
        super.addProperties(t);
        StringWriter w = new StringWriter(10240);
        ConfluenceSink sink = new ConfluenceSink(w, this.getSink());
        new ProjectSummaryRenderer((Sink)sink, this.project, this.i18n, locale).render();
        try {
            String project_summary_var = w.toString();
            this.getProperties().put(PROJECT_SUMMARY_VAR, project_summary_var);
            t.setVariable(PROJECT_SUMMARY_VAR, project_summary_var);
        }
        catch (MiniTemplator.VariableNotDefinedException e) {
            this.getLog().warn((CharSequence)String.format("variable %s not defined in template", PROJECT_SUMMARY_VAR));
        }
        w = new StringWriter(10240);
        sink = new ConfluenceSink(w, this.getSink());
        new ScmRenderer(this.scmManager, (Sink)sink, this.project.getModel(), this.i18n, locale, this.checkoutDirectoryName, this.webAccessUrl, this.anonymousConnection, this.developerConnection).render();
        try {
            String project_scm_var = w.toString();
            this.getProperties().put(PROJECT_SCM_MANAGER_VAR, project_scm_var);
            t.setVariable(PROJECT_SCM_MANAGER_VAR, project_scm_var);
        }
        catch (MiniTemplator.VariableNotDefinedException e) {
            this.getLog().warn((CharSequence)String.format("variable %s not defined in template", PROJECT_SCM_MANAGER_VAR));
        }
        w = new StringWriter(10240);
        sink = new ConfluenceSink(w, this.getSink());
        new DependenciesRenderer((Sink)sink, this.project, this.mavenProjectBuilder, this.localRepository, this.factory, this.i18n, locale, this.resolveProject(), this.getLog()).render();
        try {
            String project_dependencies_var = w.toString();
            this.getProperties().put(PROJECT_DEPENDENCIES_VAR, project_dependencies_var);
            t.setVariable(PROJECT_DEPENDENCIES_VAR, project_dependencies_var);
        }
        catch (MiniTemplator.VariableNotDefinedException e) {
            this.getLog().warn((CharSequence)String.format("variable %s not defined in template", PROJECT_DEPENDENCIES_VAR));
        }
        String wiki = t.generateOutput();
        Confluence confluence = null;
        try {
            Confluence.ProxyInfo proxyInfo = null;
            Proxy activeProxy = this.mavenSettings.getActiveProxy();
            if (activeProxy != null) {
                proxyInfo = new Confluence.ProxyInfo(activeProxy.getHost(), activeProxy.getPort(), activeProxy.getUsername(), activeProxy.getPassword());
            }
            confluence = ConfluenceFactory.createInstanceDetectingVersion((String)this.getEndPoint(), proxyInfo, (String)this.getUsername(), (String)this.getPassword());
            this.getLog().info((CharSequence)ConfluenceUtils.getVersion((Confluence)confluence));
            if (!this.isSnapshot() && this.isRemoveSnapshots()) {
                String snapshot = title.concat("-SNAPSHOT");
                this.getLog().info((CharSequence)String.format("removing page [%s]!", snapshot));
                boolean deleted = ConfluenceUtils.removePage((Confluence)confluence, (String)this.getSpaceKey(), (String)this.getParentPageTitle(), (String)snapshot);
                if (deleted) {
                    this.getLog().info((CharSequence)String.format("Page [%s] has been removed!", snapshot));
                }
            }
            Page p = ConfluenceUtils.getOrCreatePage((Confluence)confluence, (String)this.getSpaceKey(), (String)this.getParentPageTitle(), (String)title);
            p.setContent(wiki);
            p = confluence.storePage(p);
            for (String label : this.getLabels()) {
                confluence.addLabelByName(label, Long.parseLong(p.getId()));
            }
            this.generateChildren(confluence, this.getSpaceKey(), title, title);
            this.generateAttachments(confluence, p);
            this.confluenceLogout(confluence);
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"has been imposssible connect to confluence due exception", (Throwable)e);
        }
        finally {
            this.confluenceLogout(confluence);
        }
    }

    public void generate(Sink aSink, SinkFactory aSinkFactory, Locale aLocale) throws MavenReportException {
        this.getLog().info((CharSequence)("generate " + aSink));
        super.generate(aSink, aSinkFactory, aLocale);
    }

    private ReportingResolutionListener resolveProject() {
        Map managedVersions = null;
        try {
            managedVersions = this.createManagedVersionMap(this.project.getId(), this.project.getDependencyManagement());
        }
        catch (ProjectBuildingException e) {
            this.getLog().error((CharSequence)"An error occurred while resolving project dependencies.", (Throwable)e);
        }
        ReportingResolutionListener listener = new ReportingResolutionListener();
        try {
            this.collector.collect(this.project.getDependencyArtifacts(), this.project.getArtifact(), managedVersions, this.localRepository, this.project.getRemoteArtifactRepositories(), this.artifactMetadataSource, null, Collections.singletonList(listener));
        }
        catch (ArtifactResolutionException e) {
            this.getLog().error((CharSequence)"An error occurred while resolving project dependencies.", (Throwable)e);
        }
        return listener;
    }

    private Map createManagedVersionMap(String projectId, DependencyManagement dependencyManagement) throws ProjectBuildingException {
        HashMap<String, Artifact> map;
        if (dependencyManagement != null && dependencyManagement.getDependencies() != null) {
            map = new HashMap<String, Artifact>();
            for (Dependency d : dependencyManagement.getDependencies()) {
                try {
                    VersionRange versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
                    Artifact artifact = this.factory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope());
                    map.put(d.getManagementKey(), artifact);
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new ProjectBuildingException(projectId, "Unable to parse version '" + d.getVersion() + "' for dependency '" + d.getManagementKey() + "': " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            map = Collections.EMPTY_MAP;
        }
        return map;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.toString();
    }

    protected Renderer getSiteRenderer() {
        this.getLog().info((CharSequence)"getSiteRenderer");
        return null;
    }

    public String getDescription(Locale locale) {
        return "confluence";
    }

    public String getOutputName() {
        return "confluence";
    }

    public String getName(Locale locale) {
        return "confluence";
    }
}

