/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.rest.scrollversions;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import okhttp3.Credentials;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.rest.RESTConfluenceService;
import org.bsc.confluence.rest.scrollversions.model.ScrollVersions;
import org.bsc.ssl.SSLCertificateInfo;

public class ScrollVersionsConfluenceService
implements ConfluenceService {
    private static final Logger log = Logger.getLogger("confluence-maven-plugin");
    static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    static final String REQUEST_BODY_FORMAT = "[{\"queryArg\": \"%s\", \"value\": \"%s\"}]";
    final RESTConfluenceService delegate;
    final URL scrollVersionsUrl;
    final String versionName;
    final ObjectMapper objectMapper = new ObjectMapper();
    final boolean removeHard = true;
    private Optional<ScrollVersions.Model.Version> currentVersion = Optional.empty();
    private static Pattern vesrsionsTitlePattern = Pattern.compile("^[\\.](.+)\\sv(.+)$");

    public ScrollVersionsConfluenceService(String confluenceUrl, String versionName, ConfluenceService.Credentials credentials, SSLCertificateInfo sslCertificateInfo) {
        if (versionName == null) {
            throw new IllegalArgumentException("versionName is null!");
        }
        this.versionName = versionName;
        try {
            String regex = "/rest/api(/?)$";
            this.scrollVersionsUrl = new URL(confluenceUrl.replaceAll("/rest/api(/?)$", "/rest/scroll-versions/1.0"));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("invalid Scroll Versions url", e);
        }
        this.delegate = new RESTConfluenceService(confluenceUrl, credentials, sslCertificateInfo);
    }

    private HttpUrl.Builder urlBuilder() {
        int port = this.scrollVersionsUrl.getPort();
        port = port > -1 ? port : this.scrollVersionsUrl.getDefaultPort();
        return new HttpUrl.Builder().scheme(this.scrollVersionsUrl.getProtocol()).host(this.scrollVersionsUrl.getHost()).port(port).addPathSegments(this.scrollVersionsUrl.getPath().replaceAll("^/+", ""));
    }

    private Request.Builder requestBuilder() {
        ConfluenceService.Credentials credentials = this.getCredentials();
        return new Request.Builder().header("Authorization", Credentials.basic((String)credentials.username, (String)credentials.password)).header("X-Atlassian-Token", "nocheck");
    }

    CompletableFuture<ScrollVersions.Model.Version> getCurrentVersion(String spaceKey) {
        return this.currentVersion.map(v -> CompletableFuture.completedFuture(v)).orElseGet(() -> this.getScrollVersions(spaceKey).thenCompose(versions -> versions.stream().filter(v -> this.versionName.equals(v.getName())).findFirst().map(v -> {
            this.currentVersion = Optional.of(v);
            return CompletableFuture.completedFuture(v);
        }).orElseGet(() -> ScrollVersionsConfluenceService.completeExceptionally(new Exception(String.format("version [%s] doesn't exists!", this.versionName))))));
    }

    CompletableFuture<List<ScrollVersions.Model.Version>> getScrollVersions(String spaceKey) {
        HttpUrl httpUrl = this.urlBuilder().addPathSegment("versions").addPathSegment(spaceKey).build();
        Request request = this.requestBuilder().url(httpUrl).get().build();
        return this.delegate.fromRequestAsync(request).thenCompose(response -> {
            CompletableFuture futureResult = new CompletableFuture();
            return Optional.ofNullable(response.body()).map(b -> {
                try {
                    String responseBodyString = b.string();
                    ScrollVersions.Model.Version[] result = (ScrollVersions.Model.Version[])this.objectMapper.readValue(responseBodyString, ScrollVersions.Model.Version[].class);
                    futureResult.complete(Arrays.asList(result));
                }
                catch (IOException e) {
                    futureResult.completeExceptionally(e);
                }
                return futureResult;
            }).orElseGet(() -> {
                futureResult.completeExceptionally(new Exception("could not retrieve versions info!"));
                return futureResult;
            });
        });
    }

    CompletableFuture<List<ScrollVersions.Model.Page>> getVersionsPages(String spaceKey, String queryArg, String value) {
        HttpUrl httpUrl = this.urlBuilder().addPathSegment("page").addPathSegment(spaceKey).build();
        RequestBody body = RequestBody.create((String)String.format(REQUEST_BODY_FORMAT, queryArg, value), (MediaType)JSON_MEDIA_TYPE);
        Request request = this.requestBuilder().url(httpUrl).post(body).build();
        return this.delegate.fromRequestAsync(request).thenCompose(response -> {
            CompletableFuture futureResult = new CompletableFuture();
            return Optional.ofNullable(response.body()).map(b -> {
                try {
                    String responseBodyString = b.string();
                    ScrollVersions.Model.Page[] result = (ScrollVersions.Model.Page[])this.objectMapper.readValue(responseBodyString, ScrollVersions.Model.Page[].class);
                    futureResult.complete(Arrays.asList(result));
                }
                catch (IOException e) {
                    futureResult.completeExceptionally(e);
                }
                return futureResult;
            }).orElseGet(() -> {
                futureResult.completeExceptionally(new Exception("could not retrieve versions info!s"));
                return futureResult;
            });
        });
    }

    CompletableFuture<Optional<ScrollVersions.Model.PageResult>> getVersionPage(String spaceKey, String title) {
        HttpUrl httpUrl = this.urlBuilder().addPathSegment("page").addPathSegment(spaceKey).build();
        RequestBody body = RequestBody.create((String)String.format(REQUEST_BODY_FORMAT, "scrollPageTitle", title), (MediaType)JSON_MEDIA_TYPE);
        Request request = this.requestBuilder().url(httpUrl).post(body).build();
        return this.delegate.fromRequestAsync(request).thenCompose(response -> {
            CompletableFuture futureResult = new CompletableFuture();
            return Optional.ofNullable(response.body()).map(b -> {
                try {
                    String responseBodyString = b.string();
                    ScrollVersions.Model.Page[] result = (ScrollVersions.Model.Page[])this.objectMapper.readValue(responseBodyString, ScrollVersions.Model.Page[].class);
                    if (result == null || result.length == 0) {
                        futureResult.complete(Optional.empty());
                    } else if (result.length == 1) {
                        futureResult.complete(Optional.of(ScrollVersions.Model.PageResult.of(result[0], Collections.emptyList())));
                    } else {
                        Optional<ScrollVersions.Model.Page> masterPage = Arrays.stream(result).filter(p -> p.isMasterPage()).findFirst();
                        futureResult.complete(masterPage.map(mp -> {
                            List<ScrollVersions.Model.Page> versionPages = Arrays.stream(result).filter(p -> !p.isMasterPage()).collect(Collectors.toList());
                            return Optional.of(ScrollVersions.Model.PageResult.of(mp, versionPages));
                        }).orElse(Optional.empty()));
                    }
                }
                catch (IOException e) {
                    futureResult.completeExceptionally(e);
                }
                return futureResult;
            }).orElseGet(() -> {
                futureResult.completeExceptionally(new Exception("could not retrieve versions info!s"));
                return futureResult;
            });
        });
    }

    CompletableFuture<Optional<ScrollVersions.Model.PageResult>> getVersionPage(String spaceKey, String title, ScrollVersions.Model.Version byVersion) {
        return this.getVersionPage(spaceKey, title).thenApply(result -> result.map(r -> r.getVersionPages().stream().filter(p -> byVersion.getId().equals(p.getTargetVersion().getVersionId())).findFirst().map(pp -> Optional.of(ScrollVersions.Model.PageResult.of(r.getMasterPage(), Collections.singletonList(pp)))).orElse(Optional.empty())).orElse((Optional)result));
    }

    CompletableFuture<ScrollVersions.Model.NewPageResult> createVersionPage(String spaceKey, ConfluenceService.Model.ID masterPageId, String title, ScrollVersions.Model.Version version) {
        HttpUrl httpUrl = this.urlBuilder().addPathSegment("page").addPathSegment("new").addPathSegment(spaceKey).build();
        FormBody body = new FormBody.Builder().add("parentConfluenceId", masterPageId.toString()).add("versionId", version.getId()).add("pageTitle", title).build();
        Request request = this.requestBuilder().url(httpUrl).post((RequestBody)body).build();
        return this.delegate.fromRequestAsync(request).thenCompose(response -> {
            CompletableFuture futureResult = new CompletableFuture();
            return Optional.ofNullable(response.body()).map(b -> {
                try {
                    String responseBodyString = b.string();
                    ScrollVersions.Model.NewPageResult result = (ScrollVersions.Model.NewPageResult)this.objectMapper.readValue(responseBodyString, ScrollVersions.Model.NewPageResult.class);
                    futureResult.complete(result);
                }
                catch (IOException e) {
                    futureResult.completeExceptionally(e);
                }
                return futureResult;
            }).orElseGet(() -> {
                futureResult.completeExceptionally(new Exception(String.format("could not create new page [%s] in version [%s]!", title, version.getName())));
                return futureResult;
            });
        });
    }

    CompletableFuture<ScrollVersions.Model.NewPageResult> manageVersionPage(ConfluenceService.Model.ID masterPageId, String title, ScrollVersions.Model.Version version, ChangeType changeType) {
        HttpUrl httpUrl = this.urlBuilder().addPathSegment("page").addPathSegment("modify").build();
        FormBody body = new FormBody.Builder().add("masterPageId", masterPageId.toString()).add("pageTitle", title).add("versionId", version.getId()).add("changeType", changeType.typeName).build();
        Request request = this.requestBuilder().url(httpUrl).post((RequestBody)body).build();
        return this.delegate.fromRequestAsync(request).thenCompose(response -> {
            CompletableFuture futureResult = new CompletableFuture();
            return Optional.ofNullable(response.body()).map(b -> {
                try {
                    String responseBodyString = b.string();
                    ScrollVersions.Model.NewPageResult result = (ScrollVersions.Model.NewPageResult)this.objectMapper.readValue(responseBodyString, ScrollVersions.Model.NewPageResult.class);
                    futureResult.complete(result);
                }
                catch (IOException e) {
                    futureResult.completeExceptionally(e);
                }
                return futureResult;
            }).orElseGet(() -> {
                futureResult.completeExceptionally(new Exception(String.format("could not create new page [%s] in version [%s]!", title, version.getName())));
                return futureResult;
            });
        });
    }

    private void debug(String message, Object ... args) {
        if (!log.isLoggable(Level.FINE)) {
            return;
        }
        log.fine(String.format(message, args));
    }

    private void trace(String message, Object ... args) {
        if (!log.isLoggable(Level.FINER)) {
            return;
        }
        log.finer(String.format(message, args));
    }

    private CompletableFuture<ScrollVersions.Model.Result> toResult(ConfluenceService.Model.Page page) {
        if (page instanceof ScrollVersions.Model.Result) {
            return CompletableFuture.completedFuture((ScrollVersions.Model.Result)page);
        }
        throw new IllegalArgumentException(String.format("page [%s] is not a result type! %s", page.getTitle(), page, this.getClass().getName()));
    }

    static <U> CompletableFuture<U> completeExceptionally(Throwable ex) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(ex);
        return future;
    }

    private <S, T> CompletableFuture<T> cast(CompletableFuture<S> s) {
        return s;
    }

    private <S, T> Optional<T> cast(Optional<S> s) {
        return s;
    }

    private String decodeTitle(String title) {
        Matcher m = vesrsionsTitlePattern.matcher(title);
        String result = m.matches() ? m.group(1) : title;
        return result;
    }

    private String encodeTitle(String title, ScrollVersions.Model.Version version) {
        if (this.isVersion(title, version)) {
            return title;
        }
        return String.format(".%s v%s", title, version.getName());
    }

    private boolean isVersion(String title, ScrollVersions.Model.Version version) {
        Matcher m = vesrsionsTitlePattern.matcher(title);
        return m.matches() ? m.group(2).equals(version.getName()) : false;
    }

    public ConfluenceService.Credentials getCredentials() {
        return this.delegate.getCredentials();
    }

    public ConfluenceService.Model.Page newPage(ConfluenceService.Model.ID id, String title) {
        return this.delegate.newPage(id, title);
    }

    private CompletableFuture<ScrollVersions.Model.NewPageResult> storeVersionedPage(ScrollVersions.Model.NewPageResult newPage, ConfluenceService.Storage content, ScrollVersions.Model.Version version) {
        String title = newPage.getScrollPageTitle();
        newPage.setScrollPageTitle(this.encodeTitle(title, version));
        return this.delegate.storePage((ConfluenceService.Model.Page)newPage, content).thenApply(storedPage -> newPage);
    }

    public CompletableFuture<ConfluenceService.Model.Page> createPage(ConfluenceService.Model.Page parentPage, String title, ConfluenceService.Storage content) {
        return ((CompletableFuture)this.getCurrentVersion(parentPage.getSpace()).thenCombine((CompletionStage)this.delegate.getPage(parentPage.getSpace(), title), (version, page) -> page.map(p -> this.manageVersionPage(p.getId(), title, (ScrollVersions.Model.Version)version, ChangeType.ADD_VERSION)).orElseGet(() -> ((CompletableFuture)this.toResult(parentPage).thenCompose(p -> this.createVersionPage(parentPage.getSpace(), p.getMasterPageId(), title, (ScrollVersions.Model.Version)version))).thenCompose(p -> this.storeVersionedPage((ScrollVersions.Model.NewPageResult)p, content, (ScrollVersions.Model.Version)version))))).thenCompose(future -> this.cast((CompletableFuture)future));
    }

    public CompletableFuture<Optional<ConfluenceService.Model.Page>> getPage(String spaceKey, String pageTitle) {
        return ((CompletableFuture)this.getCurrentVersion(spaceKey).thenCompose(version -> this.getVersionPage(spaceKey, pageTitle, (ScrollVersions.Model.Version)version))).thenCompose(vpage -> !vpage.isPresent() || ((ScrollVersions.Model.PageResult)vpage.get()).getVersionPages().isEmpty() ? CompletableFuture.completedFuture(Optional.empty()) : CompletableFuture.completedFuture(this.cast((Optional)vpage)));
    }

    public CompletableFuture<ConfluenceService.Model.Page> storePage(ConfluenceService.Model.Page page, ConfluenceService.Storage content) {
        return this.delegate.getPage(page.getId()).thenCompose(confluencePage -> confluencePage.map(p -> this.delegate.storePage(p, content)).orElseGet(() -> ScrollVersionsConfluenceService.completeExceptionally(new Exception(String.format("page [%s] not found!", page.getTitle())))).thenApply(p -> page));
    }

    public CompletableFuture<ConfluenceService.Model.Page> storePage(ConfluenceService.Model.Page page) {
        return this.delegate.getPage(page.getId()).thenCompose(confluencePage -> confluencePage.map(arg_0 -> ((RESTConfluenceService)this.delegate).storePage(arg_0)).orElseGet(() -> ScrollVersionsConfluenceService.completeExceptionally(new Exception(String.format("page [%s] not found!", page.getTitle())))));
    }

    public CompletableFuture<List<ConfluenceService.Model.PageSummary>> getDescendents(ConfluenceService.Model.ID pageId) {
        return this.getPage(pageId).thenCompose(page -> this.cast(page.map(pp -> ((CompletableFuture)this.toResult((ConfluenceService.Model.Page)pp).thenCompose(result -> this.delegate.getDescendents(result.getMasterPageId()))).thenApply(result -> {
            List list = result.stream().filter(p -> this.isVersion(p.getTitle(), this.currentVersion.get())).filter(p -> pageId.compareTo(p.getId()) != 0).collect(Collectors.toList());
            return list;
        })).orElseGet(() -> CompletableFuture.completedFuture(Collections.emptyList()))));
    }

    public CompletableFuture<Optional<? extends ConfluenceService.Model.PageSummary>> getPageByTitle(ConfluenceService.Model.ID parentPageId, String title) {
        return this.delegate.getPage(parentPageId).thenCompose(parentPage -> this.cast(parentPage.map(pp -> this.getPage(pp.getSpace(), title)).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty()))));
    }

    public CompletableFuture<Boolean> removePage(ConfluenceService.Model.Page parentPage, String title) {
        CompletableFuture<Optional<ConfluenceService.Model.Page>> getPage = this.getPage(parentPage.getSpace(), title);
        return ((CompletableFuture)getPage.thenCompose(page -> this.cast(page.map(pp -> this.delegate.removePage(pp.getId())).orElseGet(() -> ScrollVersionsConfluenceService.completeExceptionally(new Exception(String.format("page [%s] not found!", title))))))).thenApply(result -> true);
    }

    public CompletableFuture<Boolean> removePage(ConfluenceService.Model.ID pageId) {
        CompletableFuture<Optional<ConfluenceService.Model.Page>> getPage = this.getPage(pageId);
        return ((CompletableFuture)getPage.thenCompose(page -> this.cast(page.map(pp -> this.delegate.removePage(pageId)).orElseGet(() -> ScrollVersionsConfluenceService.completeExceptionally(new Exception(String.format("page [%s] not found!", pageId))))))).thenApply(result -> true);
    }

    public CompletableFuture<Optional<ConfluenceService.Model.Page>> getPage(ConfluenceService.Model.ID pageId) {
        return this.delegate.getPage(pageId).thenCompose(page -> page.map(pp -> this.getCurrentVersion(pp.getSpace()).thenCompose(version -> this.isVersion(pp.getTitle(), (ScrollVersions.Model.Version)version) ? this.getPage(pp.getSpace(), this.decodeTitle(pp.getTitle())) : CompletableFuture.completedFuture(page))).orElse(CompletableFuture.completedFuture(Optional.empty())));
    }

    public CompletableFuture<Void> addLabelsByName(ConfluenceService.Model.ID id, String[] labels) {
        return this.delegate.addLabelsByName(id, labels);
    }

    public ConfluenceService.Model.Attachment newAttachment() {
        return this.delegate.newAttachment();
    }

    public CompletableFuture<Optional<ConfluenceService.Model.Attachment>> getAttachment(ConfluenceService.Model.ID pageId, String name, String version) {
        return this.delegate.getAttachment(pageId, name, version);
    }

    public CompletableFuture<ConfluenceService.Model.Attachment> addAttachment(ConfluenceService.Model.Page page, ConfluenceService.Model.Attachment attachment, InputStream source) {
        return this.delegate.addAttachment(page, attachment, source);
    }

    public ConfluenceService.Model.Blogpost createBlogpost(String space, String title, ConfluenceService.Storage content, int version) {
        return this.delegate.createBlogpost(space, title, content, version);
    }

    public CompletableFuture<ConfluenceService.Model.Blogpost> addBlogpost(ConfluenceService.Model.Blogpost blogpost) {
        return this.delegate.addBlogpost(blogpost);
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    private static /* synthetic */ Boolean lambda$removePage$72(Object result) {
        return true;
    }

    private /* synthetic */ CompletionStage lambda$removePage$71(ConfluenceService.Model.ID pageId, Optional page) {
        return this.cast(page.map(pp -> this.getCurrentVersion(pp.getSpace()).thenCompose(version -> this.toResult((ConfluenceService.Model.Page)pp).thenCompose(result -> this.manageVersionPage(result.getMasterPageId(), pp.getTitle(), (ScrollVersions.Model.Version)version, ChangeType.REMOVE_VERSION)))).orElseGet(() -> ScrollVersionsConfluenceService.completeExceptionally(new Exception(String.format("page [%s] not found!", pageId)))));
    }

    private static /* synthetic */ Boolean lambda$removePage$62(Object result) {
        return true;
    }

    private /* synthetic */ CompletionStage lambda$removePage$61(String title, Optional page) {
        return this.cast(page.map(pp -> this.getCurrentVersion(pp.getSpace()).thenCompose(version -> this.toResult((ConfluenceService.Model.Page)pp).thenCompose(result -> this.manageVersionPage(result.getMasterPageId(), pp.getTitle(), (ScrollVersions.Model.Version)version, ChangeType.REMOVE_VERSION)))).orElseGet(() -> ScrollVersionsConfluenceService.completeExceptionally(new Exception(String.format("page [%s] not found!", title)))));
    }

    static enum ChangeType {
        ADD_VERSION("Modify"),
        REMOVE_VERSION("Remove");

        String typeName;

        private ChangeType(String typeName) {
            this.typeName = typeName;
        }
    }
}

