package org.bsc.mvnver;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.project.MavenProject;

/**
 * Goal which touches a timestamp file.
 *
 * @goal ver
 * 
 * @phase validate
 */
public class MvnVerMojo extends AbstractMojo
{
    /**
     * @component
     */
    RuntimeInformation runtimeInfo;
    
    /**
     * @parameter expression="${project}"
     * @readonly
     * @required
     */
    MavenProject project;
    
    
    public void execute() throws MojoExecutionException
    {
        
        ArtifactVersion ver = runtimeInfo.getApplicationVersion();
        
        getLog().info(  ver.toString() );
        
        if( null!=project )   {
            
            java.util.Properties p = project.getProperties();
            
            p.setProperty("maven.version", ver.toString());         
            p.setProperty("maven.version.major", Integer.toString(ver.getMajorVersion()) );
            p.setProperty("maven.version.minor", Integer.toString(ver.getMinorVersion()) );
            p.setProperty("maven.version.build", Integer.toString(ver.getBuildNumber()) );
            //p.setProperty("maven.version.qualifier", ver.getQualifier() );
            p.setProperty("maven.version.incremental", Integer.toString(ver.getIncrementalVersion()) );
            
            project.getProperties().list(System.out);
            
        }
                
        
    }
}
