/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.plugin.processor.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.bsc.processor.BaseAbstractProcessor;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"*"})
public class TESTWikiProcessor
extends BaseAbstractProcessor {
    protected FileObject getResourceFormClassPath(Filer filer, String resource, String packageName) throws IOException {
        FileObject f = filer.getResource(StandardLocation.CLASS_PATH, packageName, resource);
        InputStream is = f.openInputStream();
        if (is == null) {
            this.warn(String.format("resource [%s] not found!", resource), new Object[0]);
            return null;
        }
        return f;
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        Map<String, String> optionMap = this.processingEnv.getOptions();
        System.out.println("====> PROCESSOR RUN");
        for (Map.Entry<String, String> entry : optionMap.entrySet()) {
            System.out.printf("\t[%s] = [%s]\n", entry.getKey(), entry.getValue());
        }
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                if (element.getKind() != ElementKind.METHOD) continue;
                this.info(String.format("[%s], Element [%s] is [%s] ", new Object[]{element.getEnclosingElement(), element.getKind(), element.getSimpleName()}), new Object[0]);
            }
        }
        return true;
    }
}

