/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.plugin.processor;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.jfrog.maven.annomojo.annotations.MojoParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationProcessorMojo
extends AbstractMojo {
    @MojoParameter(expression="${project}", readonly=true, required=true)
    protected MavenProject project;
    @MojoParameter(expression="${plugin.artifacts}", readonly=true)
    private List<Artifact> pluginArtifacts;
    @MojoParameter(required=false, description="Specify the directory where to place generated source files (same behaviour of -s option)")
    private File outputDirectory;
    @MojoParameter(required=false, description="Annotation Processor FQN (Full Qualified Name) - when processors are not specified, the default discovery mechanism will be used")
    private String[] processors;
    @MojoParameter(required=false, description="Additional compiler arguments")
    private String compilerArguments;
    @MojoParameter(required=false, description="Controls whether or not the output directory is added to compilation")
    private Boolean addOutputDirectoryToCompilationSources;
    @MojoParameter(required=true, defaultValue="true", expression="${annotation.failOnError}", description="Indicates whether the build will continue even if there are compilation errors; defaults to true.")
    private Boolean failOnError = true;
    @MojoParameter(required=true, defaultValue="true", expression="${annotation.outputDiagnostics}", description="Indicates whether the compiler output should be visible, defaults to true.")
    private boolean outputDiagnostics = true;
    @MojoParameter(required=false, description="System properties set before processor invocation.")
    private Map systemProperties;

    protected abstract File getSourceDirectory();

    protected abstract File getOutputClassDirectory();

    private String buildProcessor() {
        if (this.processors == null || this.processors.length == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        for (i = 0; i < this.processors.length - 1; ++i) {
            result.append(this.processors[i]).append(',');
        }
        result.append(this.processors[i]);
        return result.toString();
    }

    protected abstract List<String> getClasspathElements();

    private String buildCompileClasspath() {
        List<String> pathElements = this.getClasspathElements();
        StringBuilder result = new StringBuilder();
        int i = 0;
        for (i = 0; i < pathElements.size() - 1; ++i) {
            result.append(pathElements.get(i)).append(File.pathSeparator);
        }
        result.append(pathElements.get(i));
        if (this.pluginArtifacts != null) {
            for (Artifact a : this.pluginArtifacts) {
                File f;
                if (!"compile".equalsIgnoreCase(a.getScope()) || (f = a.getFile()) == null) continue;
                result.append(File.pathSeparator).append(a.getFile().getAbsolutePath());
            }
        }
        return result.toString();
    }

    public void execute() throws MojoExecutionException {
        block3: {
            if ("pom".equalsIgnoreCase(this.project.getPackaging())) {
                return;
            }
            try {
                this.executeWithExceptionsHandled();
            }
            catch (Exception e1) {
                super.getLog().error((CharSequence)"execute error", (Throwable)e1);
                if (!this.failOnError.booleanValue()) break block3;
                throw new MojoExecutionException(e1.getMessage());
            }
        }
    }

    private void executeWithExceptionsHandled() throws Exception {
        JavaCompiler.CompilationTask task;
        if (this.outputDirectory == null) {
            this.outputDirectory = this.getDefaultOutputDirectory();
        }
        this.ensureOutputDirectoryExists();
        this.addOutputToSourcesIfNeeded();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        List files = FileUtils.getFiles((File)this.getSourceDirectory(), (String)"**/*.java", null);
        Iterable<? extends JavaFileObject> compilationUnits1 = fileManager.getJavaFileObjectsFromFiles(files);
        String compileClassPath = this.buildCompileClasspath();
        String processor = this.buildProcessor();
        ArrayList<String> options = new ArrayList<String>(10);
        options.add("-cp");
        options.add(compileClassPath);
        options.add("-proc:only");
        this.addCompilerArguments(options);
        if (processor != null) {
            options.add("-processor");
            options.add(processor);
        } else {
            this.getLog().info((CharSequence)"No processors specified. Using default discovery mechanism.");
        }
        options.add("-d");
        options.add(this.getOutputClassDirectory().getPath());
        options.add("-s");
        options.add(this.outputDirectory.getPath());
        for (String option : options) {
            this.getLog().info((CharSequence)("javac option: " + option));
        }
        DiagnosticListener<JavaFileObject> dl = null;
        dl = this.outputDiagnostics ? new DiagnosticListener<JavaFileObject>(){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                AbstractAnnotationProcessorMojo.this.getLog().info((CharSequence)("diagnostic " + diagnostic));
            }
        } : new DiagnosticListener<JavaFileObject>(){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            }
        };
        if (this.systemProperties != null) {
            Set pSet = this.systemProperties.entrySet();
            for (Map.Entry e : pSet) {
                this.getLog().info((CharSequence)String.format("set system property : [%s] = [%s]", e.getKey(), e.getValue()));
                System.setProperty((String)e.getKey(), (String)e.getValue());
            }
        }
        if (!(task = compiler.getTask(new PrintWriter(System.out), fileManager, (DiagnosticListener<? super JavaFileObject>)dl, options, null, compilationUnits1)).call().booleanValue()) {
            throw new Exception("error during compilation");
        }
    }

    private void addCompilerArguments(List<String> options) {
        if (!StringUtils.isEmpty((String)this.compilerArguments)) {
            for (String arg : this.compilerArguments.split(" ")) {
                if (StringUtils.isEmpty((String)arg)) continue;
                arg = arg.trim();
                this.getLog().info((CharSequence)("Adding compiler arg: " + arg));
                options.add(arg);
            }
        }
    }

    private void addOutputToSourcesIfNeeded() {
        Boolean add = this.addOutputDirectoryToCompilationSources;
        if (add == null || add.booleanValue()) {
            this.getLog().info((CharSequence)("Source directory: " + this.outputDirectory + " added"));
            this.addCompileSourceRoot(this.project, this.outputDirectory.getAbsolutePath());
        }
    }

    protected abstract void addCompileSourceRoot(MavenProject var1, String var2);

    private void ensureOutputDirectoryExists() {
        File f = this.outputDirectory;
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!this.getOutputClassDirectory().exists()) {
            this.getOutputClassDirectory().mkdirs();
        }
    }

    public abstract File getDefaultOutputDirectory();
}

