/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.plugin.processor;

import java.io.File;
import java.util.Collection;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Debug {
    private final MavenProject project;

    public Debug(MavenProject project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 'project' cannot be null");
        }
        this.project = project;
    }

    public <T> void println(String name, Collection<T> e) {
        System.out.println(name);
        if (null == e) {
            return;
        }
        for (T a : e) {
            System.out.printf("\t[%s] %s\n", a.getClass().getName(), a.toString());
        }
    }

    public void printDeps(String name, Collection<Dependency> dependencies) {
        System.out.println(name);
        for (Dependency d : dependencies) {
            System.out.printf("dependency [%s]\n", d.toString());
            String versionlessKey = ArtifactUtils.versionlessKey((String)d.getGroupId(), (String)d.getArtifactId());
            Artifact artifact = (Artifact)this.project.getArtifactMap().get(versionlessKey);
            if (null == artifact) continue;
            File file = artifact.getFile();
            System.out.printf("artifact [%s]\n", file.getPath());
        }
    }

    public void printDebugInfo() throws DependencyResolutionRequiredException {
        this.println("project.getCompileClasspathElements", this.project.getCompileClasspathElements());
        this.println("project.getCompileArtifacts", this.project.getCompileArtifacts());
        this.println("project.getCompileDependencies", this.project.getCompileDependencies());
        this.println("project.getDependencyArtifacts", this.project.getDependencyArtifacts());
        this.println("project.getArtifactMap", this.project.getArtifactMap().keySet());
        this.println("project.getArtifacts", this.project.getArtifacts());
        this.printDeps("project.getRuntimeDependencies", this.project.getRuntimeDependencies());
        this.printDeps("project.getDependencies", this.project.getDependencies());
    }
}

