package org.bsc.maven.plugin.processor;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.File;
import java.util.List;

import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;

/**
 * 
 * @author bsorrentino
 *
 * @goal process-test
 * @requiresDependencyResolution test
 * @phase generate-test-sources
 */
//@MojoGoal("process-test")
//@MojoRequiresDependencyResolution(value = "test")
//@MojoPhase("generate-test-sources")
public class TestAnnotationProcessorMojo extends AbstractAnnotationProcessorMojo
{

    /** 
     * project classpath 
     * 
     * @parameter expression = "${project.testClasspathElements}"
     * @required
     * @readonly
     */
    @SuppressWarnings("rawtypes")
    //@MojoParameter(expression = "${project.testClasspathElements}", required = true, readonly = true)
    private List classpathElements;


    /**
     * 
     * @parameter expression = "${project.build.testSourceDirectory}"
     * @required
     */
    //@MojoParameter(expression = "${project.build.testSourceDirectory}", required = true)
    private File sourceDirectory;

    /**
     * @parameter expression = "${project.build.directory}/generated-sources/apt-test"
     * @required
     */
    //@MojoParameter(expression = "${project.build.directory}/generated-sources/apt-test", required = true)
    private File defaultOutputDirectory;

    /**
     * Set the destination directory for class files (same behaviour of -d option)
     * 
     * @parameter expression="${project.build.testOutputDirectory}" 
     */
    //@MojoParameter(required = false, expression="${project.build.testOutputDirectory}", description = "Set the destination directory for class files (same behaviour of -d option)")
    private File outputClassDirectory;

    @Override
    public File getSourceDirectory()
    {
        return sourceDirectory;
    }

    protected void addCompileSourceRoot(MavenProject project, String dir)
    {
        project.addTestCompileSourceRoot(dir);
    }

    @Override
    public File getDefaultOutputDirectory()
    {
        return defaultOutputDirectory;
    }

    @Override
    protected File getOutputClassDirectory()
    {
        return outputClassDirectory;
    }


    @SuppressWarnings("unchecked")
    @Override
    protected java.util.Set<String> getClasspathElements( java.util.Set<String> result )
    {
        List<Resource> resources = project.getTestResources();

        if( resources!=null ) {
            for( Resource r : resources ) {
                result.add(r.getDirectory());
            }
        }

        result.addAll( classpathElements );

        return result;
    }


}
