package org.bsc.maven.plugin.processor;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.File;
import java.util.List;

import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;

/**
 * 
 * @author bsorrentino
 *
 * @goal process
 * @requiresDependencyResolution compile
 * @phase generate-sources
 */
//@MojoGoal("process")
//@MojoRequiresDependencyResolution(value = "compile")
//@MojoPhase("generate-sources")
public class MainAnnotationProcessorMojo extends AbstractAnnotationProcessorMojo
{
    /** 
     * project classpath 
     * 
     * @parameter expression = "${project.compileClasspathElements}"
     * @required
     * @readonly
     */
    @SuppressWarnings("rawtypes")
    //@MojoParameter(expression = "${project.compileClasspathElements}", required = true, readonly = true)
    private List classpathElements;

    /** 
     * project sourceDirectory 
     * 
     * @parameter expression = "${project.build.sourceDirectory}"
     * @required
     */
    //@MojoParameter(expression = "${project.build.sourceDirectory}", required = true)
    private File sourceDirectory;

    /**
     * @parameter expression = "${project.build.directory}/generated-sources/apt"
     * @required
     */
    //@MojoParameter(expression = "${project.build.directory}/generated-sources/apt", required = true)
    private File defaultOutputDirectory;

    /**
     * Set the destination directory for class files (same behaviour of -d option)
     * 
     * @parameter expression="${project.build.outputDirectory}"
     */
    //@MojoParameter(required = false, expression="${project.build.outputDirectory}", description = "Set the destination directory for class files (same behaviour of -d option)")
    private File outputClassDirectory;

    @Override
    public File getSourceDirectory()
    {
        return sourceDirectory;
    }

    @Override
    protected File getOutputClassDirectory()
    {
        return outputClassDirectory;
    }

    protected void addCompileSourceRoot(MavenProject project, String dir)
    {
        project.addCompileSourceRoot(dir);
    }

    @Override
    public File getDefaultOutputDirectory()
    {
        return defaultOutputDirectory;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected java.util.Set<String> getClasspathElements( java.util.Set<String> result)
    {
        List<Resource> resources = project.getResources();

        if( resources!=null ) {
            for( Resource r : resources ) {
                result.add(r.getDirectory());
            }
        }

        result.addAll( classpathElements );
        
        return result;
     }


}
