/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.plugin.processor;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Resource;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.bsc.maven.plugin.processor.AbstractAnnotationProcessorMojo;

@Mojo(name="process", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class MainAnnotationProcessorMojo
extends AbstractAnnotationProcessorMojo {
    @Parameter(defaultValue="${project.compileClasspathElements}", required=true, readonly=true)
    private List classpathElements;
    @Parameter(defaultValue="${project.build.sourceDirectory}", required=true)
    private File sourceDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/apt", required=true)
    private File defaultOutputDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File outputClassDirectory;

    @Override
    protected File getOutputClassDirectory() {
        return this.outputClassDirectory;
    }

    @Override
    protected void addCompileSourceRoot(MavenProject project, String dir) {
        project.addCompileSourceRoot(dir);
    }

    @Override
    public File getDefaultOutputDirectory() {
        return this.defaultOutputDirectory;
    }

    @Override
    public Set<File> getSourceDirectories(Set<File> result) {
        result.add(this.sourceDirectory);
        return result;
    }

    @Override
    protected Set<String> getClasspathElements(Set<String> result) {
        List resources = this.project.getResources();
        if (resources != null) {
            for (Resource r : resources) {
                result.add(r.getDirectory());
            }
        }
        result.addAll(this.classpathElements);
        return result;
    }
}

