/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.plugin.processor;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.bsc.maven.plugin.processor.AnnotationProcessorCompiler;
import org.bsc.maven.plugin.processor.ZipFileObject;
import org.codehaus.plexus.compiler.manager.CompilerManager;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public abstract class AbstractAnnotationProcessorMojo
extends AbstractMojo {
    private static final String SOURCE_CLASSIFIER = "sources";
    @Parameter
    private String releaseVersion;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="plugin.artifacts", readonly=true)
    private List<Artifact> pluginArtifacts;
    @Parameter
    private File outputDirectory;
    @Parameter
    private String[] processors;
    @Parameter
    private String compilerArguments;
    @Parameter(alias="options")
    private Map<String, Object> optionMap;
    @Parameter
    private Boolean addOutputDirectoryToCompilationSources;
    @Parameter(defaultValue="true", required=true, property="annotation.failOnError")
    private Boolean failOnError = true;
    @Parameter(defaultValue="true", required=true, property="annotation.outputDiagnostics")
    private boolean outputDiagnostics = true;
    @Parameter
    private Map<String, String> systemProperties;
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter
    private List<File> additionalSourceDirectories;
    @Parameter(defaultValue="false")
    private boolean addCompileSourceRoots = false;
    @Parameter(defaultValue="false")
    private boolean appendSourceArtifacts = false;
    @Parameter(property="project.build.sourceEncoding")
    private String encoding;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter
    private List<String> processSourceArtifacts = Collections.emptyList();
    @Parameter(defaultValue="false", property="skipAnnotationProcessing")
    protected boolean skip;
    @Parameter(defaultValue="false", property="fork")
    protected boolean fork;
    @Parameter(defaultValue="false", property="skipSourcesUnchangedAnnotationProcessing")
    protected boolean skipSourcesUnchanged;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Component
    protected CompilerManager compilerManager;
    @Component
    private ToolchainManager toolchainManager;
    private static final Lock syncExecutionLock = new ReentrantLock();

    protected abstract Set<File> getSourceDirectories(Set<File> var1);

    protected abstract File getOutputClassDirectory();

    protected abstract void addCompileSourceRoot(MavenProject var1, String var2);

    public abstract File getDefaultOutputDirectory();

    private String buildProcessor() {
        int i;
        if (this.processors == null || this.processors.length == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (i = 0; i < this.processors.length - 1; ++i) {
            result.append(this.processors[i]).append(',');
        }
        result.append(this.processors[i]);
        return result.toString();
    }

    protected abstract Set<String> getResourcesElements(Set<String> var1);

    protected abstract Set<String> getClasspathElements(Set<String> var1);

    protected abstract List<String> getAllCompileSourceRoots();

    private String buildCompileSourcepath(Consumer<String> onSuccess) {
        List<String> roots = this.getAllCompileSourceRoots();
        if (roots == null || roots.isEmpty()) {
            return null;
        }
        String result = StringUtils.join(roots.iterator(), (String)File.pathSeparator);
        onSuccess.accept(result);
        return result;
    }

    private String buildCompileClasspath() {
        LinkedHashSet<String> pathElements = new LinkedHashSet<String>();
        this.getResourcesElements(pathElements);
        this.getClasspathElements(pathElements);
        if (this.pluginArtifacts != null) {
            for (Artifact a : this.pluginArtifacts) {
                File f;
                if (!"compile".equalsIgnoreCase(a.getScope()) && !"runtime".equalsIgnoreCase(a.getScope()) || (f = a.getFile()) == null) continue;
                pathElements.add(a.getFile().getAbsolutePath());
            }
        }
        StringBuilder result = new StringBuilder();
        for (String elem : pathElements) {
            result.append(elem).append(File.pathSeparator);
        }
        return result.toString();
    }

    private String buildModulePath() {
        return this.getClasspathElements(new LinkedHashSet<String>()).stream().collect(Collectors.joining(File.pathSeparator));
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipped");
            return;
        }
        if ("pom".equalsIgnoreCase(this.project.getPackaging())) {
            return;
        }
        syncExecutionLock.lock();
        try {
            this.executeWithExceptionsHandled();
        }
        catch (Exception e1) {
            super.getLog().error((CharSequence)"error on execute: use -X to have details ");
            super.getLog().debug((Throwable)e1);
            if (this.failOnError.booleanValue()) {
                throw new MojoExecutionException("Error executing", e1);
            }
        }
        finally {
            syncExecutionLock.unlock();
        }
    }

    private Toolchain getToolchain(Map<String, String> jdkToolchain) {
        Toolchain tc = null;
        if (jdkToolchain != null && !jdkToolchain.isEmpty()) {
            try {
                Method getToolchainsMethod = this.toolchainManager.getClass().getMethod("getToolchains", MavenSession.class, String.class, Map.class);
                List tcs = (List)getToolchainsMethod.invoke((Object)this.toolchainManager, this.session, "jdk", jdkToolchain);
                if (tcs != null && tcs.size() > 0) {
                    tc = (Toolchain)tcs.get(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tc == null) {
            tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return tc;
    }

    private List<String> prepareOptions(JavaCompiler compiler) {
        ArrayList<String> options = new ArrayList<String>(10);
        String compileClassPath = this.buildCompileClasspath();
        String processor = this.buildProcessor();
        options.add("-cp");
        options.add(compileClassPath);
        if (compiler.isSupportedOption("--module-path") == 1) {
            options.add("--module-path");
            options.add(this.buildModulePath());
        }
        this.buildCompileSourcepath(sourcepath -> {
            options.add("-sourcepath");
            options.add((String)sourcepath);
        });
        options.add("-proc:only");
        this.addCompilerArguments(options);
        if (processor != null) {
            options.add("-processor");
            options.add(processor);
        } else {
            this.getLog().warn((CharSequence)"No processors specified. Using default discovery mechanism.");
        }
        options.add("-d");
        options.add(this.getOutputClassDirectory().getPath());
        options.add("-s");
        options.add(this.outputDirectory.getPath());
        Optional.ofNullable(this.releaseVersion).ifPresent(release -> {
            options.add("--release");
            options.add(this.releaseVersion);
        });
        Optional.ofNullable(this.project.getProperties()).ifPresent(properties -> {
            Optional.ofNullable(properties.getProperty("maven.compiler.source")).ifPresent(source -> {
                options.add("-source");
                options.add((String)source);
            });
            Optional.ofNullable(properties.getProperty("maven.compiler.target")).ifPresent(target -> {
                options.add("-target");
                options.add((String)target);
            });
        });
        if (this.getLog().isDebugEnabled()) {
            for (String option : options) {
                this.getLog().debug((CharSequence)String.format("javac option: %s", option));
            }
        }
        return options;
    }

    private boolean isSourcesUnchanged(List<JavaFileObject> allSources) throws IOException {
        if (!this.areSourceFilesSameAsPreviousRun(allSources)) {
            return false;
        }
        long maxSourceDate = allSources.stream().map(FileObject::getLastModified).max(Long::compare).orElse(Long.MIN_VALUE);
        final AtomicLong maxOutputDate = new AtomicLong(Long.MIN_VALUE);
        Files.walkFileTree(this.outputDirectory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (Files.isRegularFile(file, new LinkOption[0])) {
                    maxOutputDate.updateAndGet(t -> Math.max(t, file.toFile().lastModified()));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("max source file date: " + maxSourceDate + ", max output date: " + maxOutputDate.get()));
        }
        return maxSourceDate <= maxOutputDate.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean areSourceFilesSameAsPreviousRun(List<JavaFileObject> allSources) throws IOException {
        Path sourceFileList = this.outputDirectory.toPath().resolve(".maven-processor-source-files.txt");
        try {
            if (!Files.exists(sourceFileList, new LinkOption[0])) {
                this.getLog().debug((CharSequence)("File with previous sources " + sourceFileList + " not found, treating as first run"));
                boolean bl = false;
                return bl;
            }
            HashSet<String> previousSourceFiles = new HashSet<String>(Files.readAllLines(sourceFileList));
            Set currentSourceFiles = allSources.stream().map(FileObject::getName).collect(Collectors.toSet());
            if (this.getLog().isDebugEnabled()) {
                String removedSourceFiles = previousSourceFiles.stream().filter(f -> !currentSourceFiles.contains(f)).collect(Collectors.joining("\n"));
                this.getLog().debug((CharSequence)String.format("removed source files:\n%s", removedSourceFiles));
                String newSourceFiles = currentSourceFiles.stream().filter(f -> !previousSourceFiles.contains(f)).collect(Collectors.joining("\n"));
                this.getLog().debug((CharSequence)String.format("new source files:\n%s", newSourceFiles));
            }
            boolean bl = previousSourceFiles.equals(currentSourceFiles);
            return bl;
        }
        finally {
            this.outputDirectory.mkdirs();
            Files.write(sourceFileList, (Iterable<? extends CharSequence>)allSources.stream().map(FileObject::getName).collect(Collectors.toSet()), new OpenOption[0]);
        }
    }

    private void executeWithExceptionsHandled() throws Exception {
        JavaCompiler compiler;
        List sourceRoots;
        if (this.outputDirectory == null) {
            this.outputDirectory = this.getDefaultOutputDirectory();
        }
        this.ensureOutputDirectoryExists();
        this.addOutputToSourcesIfNeeded();
        String includesString = this.includes == null || this.includes.length == 0 ? "**/*.java" : StringUtils.join((Object[])this.includes, (String)",");
        String excludesString = this.excludes == null || this.excludes.length == 0 ? null : StringUtils.join((Object[])this.excludes, (String)",");
        Set<File> sourceDirs = this.getSourceDirectories(new HashSet<File>(5));
        if (this.addCompileSourceRoots && (sourceRoots = this.project.getCompileSourceRoots()) != null) {
            for (String s : sourceRoots) {
                sourceDirs.add(new File(s));
            }
        }
        if (this.additionalSourceDirectories != null && !this.additionalSourceDirectories.isEmpty()) {
            sourceDirs.addAll(this.additionalSourceDirectories);
        }
        if (sourceDirs == null) {
            throw new IllegalStateException("getSourceDirectories is null!");
        }
        ArrayList files = new ArrayList();
        for (File sourceDir : sourceDirs) {
            if (sourceDir == null) {
                this.getLog().warn((CharSequence)"source directory is null! Processor task will be skipped!");
                continue;
            }
            this.getLog().debug((CharSequence)String.format("processing source directory [%s]", sourceDir.getPath()));
            if (!sourceDir.exists()) {
                this.getLog().warn((CharSequence)String.format("source directory [%s] doesn't exist! Processor task will be skipped!", sourceDir.getPath()));
                continue;
            }
            if (!sourceDir.isDirectory()) {
                this.getLog().warn((CharSequence)String.format("source directory [%s] is invalid! Processor task will be skipped!", sourceDir.getPath()));
                continue;
            }
            files.addAll(FileUtils.getFiles((File)sourceDir, (String)includesString, (String)excludesString));
        }
        DiagnosticListener dl = diagnostic -> {
            if (!this.outputDiagnostics) {
                return;
            }
            Diagnostic.Kind kind = diagnostic.getKind();
            if (null != kind) {
                switch (kind) {
                    case ERROR: {
                        this.getLog().error((CharSequence)String.format("diagnostic: %s", diagnostic));
                        break;
                    }
                    case MANDATORY_WARNING: 
                    case WARNING: {
                        this.getLog().warn((CharSequence)String.format("diagnostic: %s", diagnostic));
                        break;
                    }
                    case NOTE: {
                        this.getLog().info((CharSequence)String.format("diagnostic: %s", diagnostic));
                        break;
                    }
                    case OTHER: {
                        this.getLog().info((CharSequence)String.format("diagnostic: %s", diagnostic));
                        break;
                    }
                }
            }
        };
        if (this.systemProperties != null) {
            Set<Map.Entry<String, String>> pSet = this.systemProperties.entrySet();
            for (Map.Entry<String, String> e : pSet) {
                this.getLog().debug((CharSequence)String.format("set system property : [%s] = [%s]", e.getKey(), e.getValue()));
                System.setProperty(e.getKey(), e.getValue());
            }
        }
        ArrayList<JavaFileObject> allSources = new ArrayList<JavaFileObject>();
        this.processSourceArtifacts(artifact -> {
            try {
                File f = artifact.getFile();
                ZipFile zipFile = new ZipFile(f);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                int sourceCount = 0;
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().endsWith(".java")) continue;
                    ++sourceCount;
                    allSources.add(ZipFileObject.create(zipFile, entry));
                }
                this.getLog().debug((CharSequence)String.format("** Discovered %d java sources in %s", sourceCount, f.getAbsolutePath()));
            }
            catch (Exception ex) {
                this.getLog().warn((CharSequence)String.format("Problem reading source archive [%s]", artifact.getFile().getPath()));
                this.getLog().debug((Throwable)ex);
            }
        });
        Map<String, String> jdkToolchain = Collections.emptyMap();
        Toolchain tc = this.getToolchain(jdkToolchain);
        if (tc != null) {
            this.fork = true;
        }
        if (this.fork) {
            this.getLog().debug((CharSequence)"PROCESSOR COMPILER FORKED!");
        }
        JavaCompiler javaCompiler = compiler = this.fork ? AnnotationProcessorCompiler.createOutProcess(tc, this.compilerManager, this.project, this.session) : AnnotationProcessorCompiler.createInProcess();
        if (compiler == null) {
            this.getLog().error((CharSequence)"JVM is not suitable for processing annotation! ToolProvider.getSystemJavaCompiler() is null.");
            return;
        }
        Charset charset = null;
        if (this.encoding != null) {
            try {
                charset = Charset.forName(this.encoding);
            }
            catch (IllegalCharsetNameException ex1) {
                this.getLog().warn((CharSequence)String.format("the given charset name [%s] is illegal!. default is used", this.encoding));
                charset = null;
            }
            catch (UnsupportedCharsetException ex2) {
                this.getLog().warn((CharSequence)String.format("the given charset name [%s] is unsupported!. default is used", this.encoding));
                charset = null;
            }
        }
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, charset == null ? Charset.defaultCharset() : charset);
        if (files != null && !files.isEmpty()) {
            for (JavaFileObject javaFileObject : fileManager.getJavaFileObjectsFromFiles(files)) {
                allSources.add(javaFileObject);
            }
        }
        if (allSources.isEmpty()) {
            this.getLog().warn((CharSequence)"no source file(s) detected! Processor task will be skipped");
            return;
        }
        if (this.skipSourcesUnchanged && this.isSourcesUnchanged(allSources)) {
            this.getLog().info((CharSequence)"no source file(s) change(s) detected! Processor task will be skipped");
            return;
        }
        List<String> options = this.prepareOptions(compiler);
        JavaCompiler.CompilationTask compilationTask = compiler.getTask(new PrintWriter(System.out), fileManager, dl, options, null, allSources);
        if (!compilationTask.call().booleanValue()) {
            throw new Exception("error during compilation");
        }
    }

    private List<File> scanSourceDirectorySources(File sourceDir) throws IOException {
        if (sourceDir == null) {
            this.getLog().warn((CharSequence)"source directory cannot be read (null returned)! Processor task will be skipped");
            return null;
        }
        if (!sourceDir.exists()) {
            this.getLog().warn((CharSequence)"source directory doesn't exist! Processor task will be skipped");
            return null;
        }
        if (!sourceDir.isDirectory()) {
            this.getLog().warn((CharSequence)"source directory is invalid! Processor task will be skipped");
            return null;
        }
        String includesString = this.includes == null || this.includes.length == 0 ? "**/*.java" : StringUtils.join((Object[])this.includes, (String)",");
        String excludesString = this.excludes == null || this.excludes.length == 0 ? null : StringUtils.join((Object[])this.excludes, (String)",");
        List files = FileUtils.getFiles((File)sourceDir, (String)includesString, excludesString);
        return files;
    }

    private void addCompilerArguments(List<String> options) {
        if (!StringUtils.isEmpty((String)this.compilerArguments)) {
            for (String string : this.compilerArguments.split(" ")) {
                if (StringUtils.isEmpty((String)string)) continue;
                String string2 = string.trim();
                this.getLog().debug((CharSequence)String.format("Adding compiler arg: %s", string2));
                options.add(string2);
            }
        }
        if (this.optionMap != null && !this.optionMap.isEmpty()) {
            for (Map.Entry entry : this.optionMap.entrySet()) {
                if (StringUtils.isEmpty((String)((String)entry.getKey())) || entry.getValue() == null) continue;
                String opt = String.format("-A%s=%s", ((String)entry.getKey()).trim(), entry.getValue().toString().trim());
                options.add(opt);
                this.getLog().debug((CharSequence)String.format("Adding compiler arg: %s", opt));
            }
        }
    }

    private void addOutputToSourcesIfNeeded() {
        Boolean add = this.addOutputDirectoryToCompilationSources;
        if (add == null || add.booleanValue()) {
            this.getLog().debug((CharSequence)String.format("Source directory: %s added", this.outputDirectory));
            this.addCompileSourceRoot(this.project, this.outputDirectory.getAbsolutePath());
        }
    }

    private void ensureOutputDirectoryExists() {
        File f = this.outputDirectory;
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!this.getOutputClassDirectory().exists()) {
            this.getOutputClassDirectory().mkdirs();
        }
    }

    private boolean matchArtifact(Artifact dep) {
        if (this.processSourceArtifacts == null || this.processSourceArtifacts.isEmpty()) {
            return false;
        }
        for (String a : this.processSourceArtifacts) {
            if (a == null || a.isEmpty()) continue;
            String[] token = a.split(":");
            boolean matchGroupId = dep.getGroupId().equals(token[0]);
            if (!matchGroupId) continue;
            if (token.length == 1) {
                return true;
            }
            if (token[1].equals("*")) {
                return true;
            }
            return dep.getArtifactId().equals(token[1]);
        }
        return false;
    }

    private Artifact resolveSourceArtifact(Artifact dep) throws ArtifactResolutionException {
        if (!this.matchArtifact(dep)) {
            return null;
        }
        ArtifactTypeRegistry typeReg = this.repoSession.getArtifactTypeRegistry();
        DefaultArtifact artifact = new DefaultArtifact(dep.getGroupId(), dep.getArtifactId(), SOURCE_CLASSIFIER, null, dep.getVersion(), typeReg.get(dep.getType()));
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact((org.eclipse.aether.artifact.Artifact)artifact);
        request.setRepositories(this.remoteRepos);
        this.getLog().debug((CharSequence)String.format("Resolving artifact %s from %s", artifact, this.remoteRepos));
        ArtifactResult result = this.repoSystem.resolveArtifact(this.repoSession, request);
        return RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)result.getArtifact());
    }

    private void processSourceArtifacts(Consumer<Artifact> closure) {
        for (Artifact dep : this.project.getDependencyArtifacts()) {
            if (dep.hasClassifier() && SOURCE_CLASSIFIER.equals(dep.getClassifier())) {
                if (!this.appendSourceArtifacts) continue;
                closure.accept(dep);
                continue;
            }
            try {
                Artifact sourcesDep = this.resolveSourceArtifact(dep);
                if (sourcesDep == null) continue;
                closure.accept(sourcesDep);
            }
            catch (ArtifactResolutionException ex) {
                this.getLog().warn((CharSequence)String.format(" sources for artifact [%s] not found!", dep.toString()));
                this.getLog().debug((Throwable)ex);
            }
        }
    }
}

