/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.plugin.libutils;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.DefaultModelWriter;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.bsc.maven.plugin.libutils.AbstractDeployMojo;
import org.bsc.maven.plugin.libutils.Constants;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

@Mojo(name="deploy-folder", requiresProject=true)
public class DeployFolderMojo
extends AbstractDeployMojo
implements Constants {
    @Component
    protected MavenProject project;
    @Parameter(defaultValue="false")
    private boolean updatePom = false;
    @Parameter(defaultValue="false")
    private boolean preview = false;
    @Parameter
    private String[] includes = new String[0];
    @Parameter
    private String[] excludes = new String[0];
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="artifactId-prefix", defaultValue="")
    private String artifactIdPrefix = "";
    @Parameter(property="artifactId-postfix", defaultValue="")
    private String artifactIdPostfix = "";
    @Parameter(property="version")
    private String version;
    @Parameter(property="filePattern", required=false)
    private String filePattern = null;
    @Parameter(property="generatePom.description")
    private String description;
    @Parameter(property="project.build.directory", required=true)
    private File outputFolder;
    @Parameter(property="sourceFolder", required=true)
    private File sourceFolder;
    @Parameter(property="repositoryId", defaultValue="remote-repository")
    private String repositoryId;
    @Parameter(property="repositoryLayout", defaultValue="default", required=true)
    private String repositoryLayout;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;
    @Parameter(property="url", required=true)
    private String url;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactRepositoryFactory repositoryFactory;
    @Parameter(property="generatePom", defaultValue="true")
    private boolean generatePom;
    @Parameter(property="uniqueVersion", defaultValue="true")
    private boolean uniqueVersion;

    protected void initProperties(File pomFile) throws MojoExecutionException {
        if (pomFile != null) {
            this.generatePom = false;
            Model model = this.readModel(pomFile);
            this.processModel(model);
        }
    }

    private void updatePom() {
        if (!this.updatePom) {
            return;
        }
        try {
            File backupFile = new File(this.project.getBasedir(), "pom.bak");
            FileUtils.copyFile((File)this.project.getFile(), (File)backupFile);
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)"error creating pom backup", (Throwable)ex);
            return;
        }
        DefaultModelWriter w = new DefaultModelWriter();
        try {
            w.write(this.project.getFile(), null, this.project.getOriginalModel());
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)"error updating pom", (Throwable)ex);
        }
    }

    private void generateDependenciesFile(List<Artifact> artifactList) throws IOException {
        if (artifactList.isEmpty()) {
            return;
        }
        FileWriter deps = new FileWriter("dependencies.xml");
        deps.append("<dependencies>");
        for (final Artifact a : artifactList) {
            deps.append("\n\t").append("<dependency>").append("\n\t\t").append("<groupId>").append(a.getGroupId()).append("</groupId>").append("\n\t\t").append("<artifactId>").append(a.getArtifactId()).append("</artifactId>").append("\n\t\t").append("<version>").append(a.getVersion()).append("</version>").append("\n\t\t").append("<type>").append(a.getType()).append("</type>").append("\n\t").append("</dependency>");
            Set da = this.project.getDependencyArtifacts();
            if (da.contains(a)) continue;
            this.project.getOriginalModel().addDependency(new Dependency(){
                {
                    this.setArtifactId(a.getArtifactId());
                    this.setGroupId(a.getGroupId());
                    this.setVersion(a.getVersion());
                    this.setScope(a.getScope());
                }
            });
        }
        deps.append("\n").append("</dependencies>");
        deps.close();
        this.updatePom();
    }

    @Override
    public void execute() throws MojoExecutionException {
        if (!this.sourceFolder.exists()) {
            throw new MojoExecutionException(this.sourceFolder.getPath() + " not found.");
        }
        if (!this.sourceFolder.isDirectory()) {
            throw new MojoExecutionException(this.sourceFolder.getPath() + " is not folder.");
        }
        ArtifactRepositoryLayout layout = this.repositoryLayouts.get(this.repositoryLayout);
        ArtifactRepository deploymentRepository = this.repositoryFactory.createDeploymentArtifactRepository(this.repositoryId, this.url, layout, this.uniqueVersion);
        String protocol = deploymentRepository.getProtocol();
        if ("".equals(protocol) || protocol == null) {
            throw new MojoExecutionException("No transfer protocol found.");
        }
        this.getLog().info((CharSequence)("protocol " + protocol));
        try {
            File checkFile = new File(this.outputFolder, "deployed.properties");
            Properties deployedFiles = new Properties();
            if (checkFile.exists()) {
                deployedFiles.load(new FileReader(checkFile));
            } else {
                this.outputFolder.mkdirs();
            }
            List files = FileUtils.getFiles((File)this.sourceFolder, (String)this.join(this.includes, ','), (String)this.join(this.excludes, ','));
            ArrayList<Artifact> artifactList = new ArrayList<Artifact>(files.size());
            this.getLog().info((CharSequence)("process files " + files.size()));
            for (File f : files) {
                Artifact a;
                if (deployedFiles.containsKey(f.getName())) {
                    a = this.execute(f, null);
                } else {
                    a = this.execute(f, deploymentRepository);
                    deployedFiles.setProperty(f.getName(), f.getAbsolutePath());
                    deployedFiles.store(new FileWriter(checkFile), "artifact deployed");
                }
                artifactList.add(a);
            }
            this.generateDependenciesFile(artifactList);
        }
        catch (Exception e1) {
            this.getLog().error((Throwable)e1);
            throw new MojoExecutionException(e1.getMessage());
        }
    }

    private String join(String[] array, char delimiter) {
        if (array == null) {
            throw new IllegalArgumentException("param array is null!");
        }
        if (array.length == 0) {
            this.getLog().warn((CharSequence)"param 'array' is empty ");
            return "";
        }
        StringBuilder result = new StringBuilder(array[0]);
        for (int i = 1; i < array.length; ++i) {
            result.append(delimiter).append(array[i]);
        }
        return result.toString();
    }

    private Artifact execute(File file, ArtifactRepository deploymentRepository) throws Exception {
        ProjectArtifactMetadata metadata;
        this.getLog().info((CharSequence)("process file " + file.getName()));
        String name = file.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            throw new MojoExecutionException("file name without extension " + name);
        }
        String candidateArtifactId = name.substring(0, index);
        String candidateArtifactVersion = this.version;
        String packaging = name.substring(++index);
        if (null != this.filePattern) {
            try {
                Pattern p = Pattern.compile(this.filePattern);
                Matcher m = p.matcher(candidateArtifactId);
                if (m.matches()) {
                    if (m.groupCount() == 1) {
                        candidateArtifactId = m.group(0);
                        candidateArtifactVersion = m.group(1);
                    } else if (m.groupCount() == 2) {
                        candidateArtifactId = m.group(1);
                        candidateArtifactVersion = m.group(2);
                    }
                } else {
                    this.getLog().warn((CharSequence)String.format("[%s] doesn't match pattern %s", candidateArtifactId, this.filePattern));
                }
            }
            catch (Exception ex) {
                this.getLog().warn((CharSequence)"error during parse the file name", (Throwable)ex);
            }
        }
        String artifactId = this.artifactIdPrefix + candidateArtifactId + this.artifactIdPostfix;
        File pomFile = null;
        Artifact artifact = this.artifactFactory.createBuildArtifact(this.groupId, artifactId, candidateArtifactVersion, packaging);
        this.getLog().info((CharSequence)("resulting artifact " + artifact));
        if (this.preview || deploymentRepository == null) {
            return artifact;
        }
        if (this.generatePom) {
            metadata = new ProjectArtifactMetadata(artifact, this.generatePomFile(artifactId, packaging, candidateArtifactVersion));
            artifact.addMetadata((ArtifactMetadata)metadata);
        } else {
            metadata = new ProjectArtifactMetadata(artifact, pomFile);
            artifact.addMetadata((ArtifactMetadata)metadata);
        }
        try {
            this.getDeployer().deploy(file, artifact, deploymentRepository, this.getLocalRepository());
        }
        catch (ArtifactDeploymentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        return artifact;
    }

    private void processModel(Model model) {
    }

    protected Model readModel(File pomFile) throws MojoExecutionException {
        if (!pomFile.exists()) {
            throw new MojoExecutionException("Specified pomFile does not exist");
        }
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)pomFile);
            MavenXpp3Reader modelReader = new MavenXpp3Reader();
            Model model = modelReader.read((Reader)reader);
            return model;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading specified POM file: " + e.getMessage(), e);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    private File generatePomFile(String artifactId, String packaging, String candidateVersion) throws MojoExecutionException {
        File file;
        XmlStreamWriter fw = null;
        try {
            File tempFile = File.createTempFile("mvninstall", ".pom");
            tempFile.deleteOnExit();
            Model model = new Model();
            model.setModelVersion("4.0.0");
            model.setGroupId(this.groupId);
            model.setArtifactId(artifactId);
            model.setVersion(candidateVersion);
            model.setPackaging(packaging);
            model.setDescription(this.description);
            fw = WriterFactory.newXmlWriter((File)tempFile);
            new MavenXpp3Writer().write((Writer)fw, model);
            file = tempFile;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error writing temporary pom file: " + e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fw);
                throw throwable;
            }
        }
        IOUtil.close((Writer)fw);
        return file;
    }

    void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    void setVersion(String version) {
        this.version = version;
    }

    String getGroupId() {
        return this.groupId;
    }

    String getVersion() {
        return this.version;
    }
}

