/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.plugin.libutils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.MojoExecutionException;
import org.bsc.maven.plugin.libutils.ThrowingFunction;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MojoUtils {
    static final Pattern POM_ENTRY = Pattern.compile("META-INF/maven/.*/pom\\.xml");
    static final Pattern POM_PROPERTIES = Pattern.compile("META-INF/maven/.*/pom\\.properties");

    protected MojoUtils() {
    }

    public static Model readModel(InputStream pomFile) throws MojoExecutionException {
        Model model;
        block10: {
            XmlStreamReader reader = ReaderFactory.newXmlReader((InputStream)pomFile);
            try {
                model = new MavenXpp3Reader().read((Reader)reader);
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new MojoExecutionException("File not found " + pomFile, (Exception)e);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error reading POM " + pomFile, (Exception)e);
                }
                catch (XmlPullParserException e) {
                    throw new MojoExecutionException("Error parsing POM " + pomFile, (Exception)((Object)e));
                }
            }
            reader.close();
        }
        return model;
    }

    public static <T> Optional<T> getArtifactCoordinateFromPropsInJar(JarFile jarFile, Function<Properties, T> creator, Optional<String> groupId) throws IOException, MojoExecutionException {
        if (jarFile == null) {
            throw new IllegalArgumentException("jar parameter is null!");
        }
        if (creator == null) {
            throw new IllegalArgumentException("onSuccess parameter is null!");
        }
        if (groupId == null) {
            throw new IllegalArgumentException("groupId is null!");
        }
        List pomPropertyEntries = jarFile.stream().filter(_entry -> POM_PROPERTIES.matcher(_entry.getName()).matches()).collect(Collectors.toList());
        Optional<JarEntry> entry = pomPropertyEntries.size() == 1 ? Optional.of((JarEntry)pomPropertyEntries.get(0)) : pomPropertyEntries.stream().filter(_entry -> groupId.isPresent() ? _entry.getName().contains((CharSequence)groupId.get()) : false).findAny();
        return entry.map(ThrowingFunction.unchecked(_entry -> {
            try (InputStream pomInputStream = jarFile.getInputStream((ZipEntry)_entry);){
                Properties props = new Properties();
                props.load(pomInputStream);
                Optional optional = Optional.ofNullable(creator.apply(props));
                return optional;
            }
        })).orElse(Optional.empty());
    }

    public static <T> Optional<T> getArtifactCoordinateFromXmlInJar(JarFile jarFile, Function<Model, T> creator) throws IOException, MojoExecutionException {
        if (jarFile == null) {
            throw new IllegalArgumentException("jar parameter is null!");
        }
        if (creator == null) {
            throw new IllegalArgumentException("onSuccess parameter is null!");
        }
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        if (jarEntries != null) {
            while (jarEntries.hasMoreElements()) {
                JarEntry entry = jarEntries.nextElement();
                if (!POM_ENTRY.matcher(entry.getName()).matches()) continue;
                try (InputStream pomInputStream = jarFile.getInputStream(entry);){
                    Model model = MojoUtils.readModel(pomInputStream);
                    Optional<T> optional = Optional.ofNullable(creator.apply(model));
                    return optional;
                }
            }
        }
        return Optional.empty();
    }
}

