/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.plugin.libutils;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.DefaultModelWriter;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.bsc.maven.plugin.libutils.AbstractDeployMojo;
import org.bsc.maven.plugin.libutils.Constants;
import org.bsc.maven.plugin.libutils.MojoUtils;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

@Mojo(name="deploy-folder")
public class DeployFolderMojo
extends AbstractDeployMojo
implements Constants {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="false", property="deploy.updatePom")
    private boolean _updatePom;
    @Parameter(defaultValue="false")
    private boolean preview = false;
    @Parameter
    private String[] includes = new String[0];
    @Parameter
    private String[] excludes = new String[0];
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="artifactId-prefix")
    private String artifactIdPrefix = "";
    @Parameter(property="artifactId-postfix")
    private String artifactIdPostfix = "";
    @Parameter(property="version")
    private String version;
    @Parameter(property="filePattern")
    private String filePattern = null;
    @Parameter(property="generatePom.description")
    private String description;
    @Parameter(property="project.build.directory", required=true)
    private File outputFolder;
    @Parameter(property="sourceFolder", required=true)
    private File sourceFolder;
    @Parameter(property="repositoryId", defaultValue="remote-repository")
    private String repositoryId;
    @Parameter(property="repositoryLayout", defaultValue="default", required=true)
    private String repositoryLayout;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;
    @Parameter(property="url", required=true)
    private String url;
    @Component
    private ArtifactRepositoryFactory repositoryFactory;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Parameter(property="generatePom", defaultValue="true")
    private boolean generatePom;
    @Parameter(property="uniqueVersion", defaultValue="true")
    private boolean uniqueVersion;
    @Parameter(property="useSameGroupIdAsArtifactId", defaultValue="false")
    private boolean useSameGroupIdAsArtifactId;
    @Parameter(property="ignorePomProperties", defaultValue="false")
    private boolean ignorePomProperties;

    private void updatePom() {
        if (!this._updatePom) {
            this.getLog().info((CharSequence)"Pom update skipped!");
            return;
        }
        try {
            File backupFile = new File(this.project.getBasedir(), "pom.bak");
            FileUtils.copyFile((File)this.project.getFile(), (File)backupFile);
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)"error creating pom backup", (Throwable)ex);
            return;
        }
        DefaultModelWriter w = new DefaultModelWriter();
        try {
            w.write(this.project.getFile(), null, this.project.getOriginalModel());
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)"error updating pom", (Throwable)ex);
        }
    }

    private void generateDependenciesFile(List<Artifact> artifactList) throws IOException {
        if (artifactList.isEmpty()) {
            return;
        }
        FileWriter deps = new FileWriter("dependencies.xml");
        deps.append("<dependencies>");
        for (Artifact a : artifactList) {
            deps.append("\n\t").append("<dependency>").append("\n\t\t").append("<groupId>").append(a.getGroupId()).append("</groupId>").append("\n\t\t").append("<artifactId>").append(a.getArtifactId()).append("</artifactId>").append("\n\t\t").append("<version>").append(a.getVersion()).append("</version>").append("\n\t\t").append("<type>").append(a.getType()).append("</type>").append("\n\t").append("</dependency>");
            Set da = this.project.getArtifacts();
            if (da.contains(a)) continue;
            Dependency dep = new Dependency();
            dep.setArtifactId(a.getArtifactId());
            dep.setGroupId(a.getGroupId());
            dep.setVersion(a.getVersion());
            dep.setScope(a.getScope());
            this.project.getOriginalModel().addDependency(dep);
        }
        deps.append("\n").append("</dependencies>");
        deps.close();
        this.updatePom();
    }

    @Override
    public void execute() throws MojoExecutionException {
        if (!this.sourceFolder.exists()) {
            throw new MojoExecutionException(this.sourceFolder.getPath() + " not found.");
        }
        if (!this.sourceFolder.isDirectory()) {
            throw new MojoExecutionException(this.sourceFolder.getPath() + " is not folder.");
        }
        ArtifactRepositoryLayout layout = this.repositoryLayouts.get(this.repositoryLayout);
        ArtifactRepository deploymentRepository = this.repositoryFactory.createDeploymentArtifactRepository(this.repositoryId, this.url, layout, this.uniqueVersion);
        String protocol = deploymentRepository.getProtocol();
        if (protocol == null || "".equals(protocol)) {
            throw new MojoExecutionException("No transfer protocol found.");
        }
        this.getLog().info((CharSequence)String.format("protocol %s", protocol));
        try {
            File checkFile = new File(this.outputFolder, "deployed.properties");
            Properties deployedFiles = new Properties();
            if (checkFile.exists()) {
                try (FileReader checkFileReader = new FileReader(checkFile);){
                    deployedFiles.load(checkFileReader);
                }
            } else {
                this.outputFolder.mkdirs();
            }
            List files = FileUtils.getFiles((File)this.sourceFolder, (String)this.join(this.includes, ','), (String)this.join(this.excludes, ','));
            ArrayList<Artifact> artifactList = new ArrayList<Artifact>(files.size());
            this.getLog().info((CharSequence)String.format("process files %d", files.size()));
            for (File f : files) {
                Artifact a;
                if (deployedFiles.containsKey(f.getName())) {
                    a = this.execute(f, Optional.empty());
                } else {
                    a = this.execute(f, Optional.of(deploymentRepository));
                    if (!this.preview) {
                        deployedFiles.setProperty(f.getName(), f.getAbsolutePath());
                        try (FileWriter checkFileWriter = new FileWriter(checkFile);){
                            deployedFiles.store(checkFileWriter, "artifact deployed");
                        }
                    }
                }
                artifactList.add(a);
            }
            this.generateDependenciesFile(artifactList);
        }
        catch (Exception e1) {
            this.getLog().error((Throwable)e1);
            throw new MojoExecutionException(e1.getMessage());
        }
    }

    private String join(String[] array, char delimiter) {
        if (array == null) {
            throw new IllegalArgumentException("param array is null!");
        }
        if (array.length == 0) {
            this.getLog().warn((CharSequence)"param 'array' is empty ");
            return "";
        }
        StringBuilder result = new StringBuilder(array[0]);
        for (int i = 1; i < array.length; ++i) {
            result.append(delimiter).append(array[i]);
        }
        return result.toString();
    }

    private Artifact createBuildArtifact(String groupId, String artifactId, String version, String packaging) {
        boolean optional = false;
        String classifier = "";
        String scope = "compile";
        ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(packaging);
        VersionRange versionRange = version != null ? VersionRange.createFromVersion((String)version) : null;
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, versionRange, "compile", packaging, "", handler, false);
        return artifact;
    }

    private Artifact createBuildArtifact(Properties props) {
        String groupId = props.getProperty("groupId");
        String artifactId = props.getProperty("artifactId");
        String version = props.getProperty("version");
        String packaging = props.getProperty("packaging", "jar");
        return this.createBuildArtifact(groupId, artifactId, version, packaging);
    }

    private Artifact execute(File file, Optional<ArtifactRepository> deploymentRepository) throws Exception {
        this.getLog().info((CharSequence)String.format("process file %s", file.getName()));
        String name = file.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            throw new MojoExecutionException("file name without extension " + name);
        }
        String candidateArtifactId = name.substring(0, index);
        String packaging = name.substring(++index);
        Artifact result = null;
        if ("pom".compareToIgnoreCase(packaging) == 0) {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((Reader)new FileReader(file));
            result = this.createBuildArtifact(model.getGroupId(), model.getArtifactId(), model.getVersion(), model.getPackaging());
        } else {
            JarFile jarFile;
            Optional<Artifact> artifact;
            boolean isMavenArtifact = false;
            if (!this.ignorePomProperties && "jar".compareToIgnoreCase(packaging) == 0 && (artifact = MojoUtils.getArtifactCoordinateFromPropsInJar(jarFile = new JarFile(file), this::createBuildArtifact, Optional.ofNullable(this.groupId))).isPresent()) {
                result = artifact.get();
                this.getLog().info((CharSequence)String.format("artifact [%s] is already a maven artifact!", result));
                isMavenArtifact = true;
            }
            if (!isMavenArtifact) {
                result = this.createNotStandardArtifact(candidateArtifactId, packaging);
            }
            if (this.preview || !deploymentRepository.isPresent()) {
                return result;
            }
            if (!isMavenArtifact && this.generatePom) {
                ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(result, this.generatePomFile(result.getArtifactId(), packaging, result.getVersion()));
                result.addMetadata((ArtifactMetadata)metadata);
            }
        }
        try {
            this.getDeployer().deploy(file, result, deploymentRepository.get(), this.getLocalRepository());
        }
        catch (ArtifactDeploymentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        return result;
    }

    private Artifact createNotStandardArtifact(String candidateArtifactId, String packaging) {
        String candidateArtifactVersion;
        block9: {
            String[] parts;
            candidateArtifactVersion = this.version;
            if (StringUtils.isBlank((CharSequence)this.filePattern)) {
                try {
                    Pattern p = Pattern.compile(this.filePattern);
                    Matcher m = p.matcher(candidateArtifactId);
                    if (m.matches()) {
                        if (m.groupCount() == 1) {
                            candidateArtifactId = m.group(0);
                            candidateArtifactVersion = m.group(1);
                        } else if (m.groupCount() == 2) {
                            candidateArtifactId = m.group(1);
                            candidateArtifactVersion = m.group(2);
                        }
                        break block9;
                    }
                    this.getLog().warn((CharSequence)String.format("[%s] doesn't match pattern %s", candidateArtifactId, this.filePattern));
                }
                catch (Exception ex) {
                    this.getLog().warn((CharSequence)"error during parse the file name", (Throwable)ex);
                }
            } else if (StringUtils.isBlank((CharSequence)candidateArtifactVersion) && (parts = StringUtils.split((String)candidateArtifactId, (String)"-")) != null && parts.length > 1 && StringUtils.containsOnly((CharSequence)parts[parts.length - 1], (String)"0123456789.")) {
                candidateArtifactVersion = parts[parts.length - 1];
                candidateArtifactId = StringUtils.substringBeforeLast((String)candidateArtifactId, (String)"-");
            }
        }
        String artifactId = this.artifactIdPrefix + candidateArtifactId + this.artifactIdPostfix;
        Artifact result = this.createBuildArtifact((String)StringUtils.defaultIfBlank((CharSequence)this.groupId, (CharSequence)(this.useSameGroupIdAsArtifactId ? artifactId : this.groupId)), artifactId, candidateArtifactVersion, packaging);
        this.getLog().info((CharSequence)String.format("resulting artifact %s", result));
        return result;
    }

    private File generatePomFile(String artifactId, String packaging, String candidateVersion) throws MojoExecutionException {
        File file;
        XmlStreamWriter fw = null;
        try {
            File tempFile = File.createTempFile("mvninstall", ".pom");
            tempFile.deleteOnExit();
            Model model = new Model();
            model.setModelVersion("4.0.0");
            model.setGroupId(this.groupId);
            model.setArtifactId(artifactId);
            model.setVersion(candidateVersion);
            model.setPackaging(packaging);
            model.setDescription(this.description);
            fw = WriterFactory.newXmlWriter((File)tempFile);
            new MavenXpp3Writer().write((Writer)fw, model);
            file = tempFile;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error writing temporary pom file: " + e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fw);
                throw throwable;
            }
        }
        IOUtil.close((Writer)fw);
        return file;
    }

    void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    void setVersion(String version) {
        this.version = version;
    }

    String getGroupId() {
        return this.groupId;
    }

    String getVersion() {
        return this.version;
    }
}

