/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.plugin.libutils;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.bsc.maven.plugin.libutils.Constants;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="rollback", requiresProject=true)
public class RollbackPomUpdateMojo
extends AbstractMojo
implements Constants {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File backupFile = new File(this.project.getBasedir(), "pom.bak");
        try {
            FileUtils.copyFile((File)backupFile, (File)this.project.getFile());
        }
        catch (IOException ex) {
            String msg = "error restoring pom from backup";
            throw new MojoFailureException("error restoring pom from backup", (Throwable)ex);
        }
        boolean result = backupFile.delete();
        if (!result) {
            this.getLog().warn((CharSequence)"error removing pom backup");
        }
    }
}

