/*
 * Decompiled with CFR 0.152.
 */
package biz.source_code.miniTemplator;

import biz.source_code.miniTemplator.MiniTemplatorParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MiniTemplator {
    private MiniTemplatorParser parser;
    private Charset charset = Charset.defaultCharset();
    private String subtemplateBasePath;
    private String[] varValuesTab;
    private BlockDynTabRec[] blockDynTab;
    private BlockInstTabRec[] blockInstTab;
    private int blockInstTabCnt;
    private boolean skipUndefinedVars;

    public static Builder builder() {
        return new Builder();
    }

    protected MiniTemplator() {
    }

    protected String loadSubtemplate(String subtemplateName) throws IOException {
        String fileName = new File(this.subtemplateBasePath, subtemplateName).getPath();
        return this.readFileIntoString(fileName);
    }

    public void reset() {
        if (this.varValuesTab == null) {
            this.varValuesTab = new String[this.parser.varTabCnt];
        } else {
            for (int varNo = 0; varNo < this.parser.varTabCnt; ++varNo) {
                this.varValuesTab[varNo] = null;
            }
        }
        if (this.blockDynTab == null) {
            this.blockDynTab = new BlockDynTabRec[this.parser.blockTabCnt];
        }
        for (int blockNo = 0; blockNo < this.parser.blockTabCnt; ++blockNo) {
            BlockDynTabRec bdtr = this.blockDynTab[blockNo];
            if (bdtr == null) {
                this.blockDynTab[blockNo] = bdtr = new BlockDynTabRec();
            }
            bdtr.instances = 0;
            bdtr.firstBlockInstNo = -1;
            bdtr.lastBlockInstNo = -1;
        }
        this.blockInstTabCnt = 0;
    }

    public MiniTemplator cloneReset() {
        MiniTemplator m = new MiniTemplator();
        m.parser = this.parser;
        m.charset = this.charset;
        m.reset();
        return m;
    }

    public void setVariable(String variableName, String variableValue, boolean isOptional) throws VariableNotDefinedException {
        int varNo = this.parser.lookupVariableName(variableName);
        if (varNo == -1) {
            if (isOptional) {
                return;
            }
            throw new VariableNotDefinedException(variableName);
        }
        this.varValuesTab[varNo] = variableValue;
    }

    public void setVariable(String variableName, String variableValue) throws VariableNotDefinedException {
        this.setVariable(variableName, variableValue, false);
    }

    public void setVariable(String variableName, int variableValue) throws VariableNotDefinedException {
        this.setVariable(variableName, Integer.toString(variableValue));
    }

    public void setVariableOpt(String variableName, String variableValue) {
        this.setVariable(variableName, variableValue, true);
    }

    public void setVariableOpt(String variableName, int variableValue) {
        int varNo = this.parser.lookupVariableName(variableName);
        if (varNo == -1) {
            return;
        }
        this.varValuesTab[varNo] = Integer.toString(variableValue);
    }

    public void setVariableEsc(String variableName, String variableValue, boolean isOptional) throws VariableNotDefinedException {
        this.setVariable(variableName, MiniTemplator.escapeHtml(variableValue), isOptional);
    }

    public void setVariableEsc(String variableName, String variableValue) throws VariableNotDefinedException {
        this.setVariable(variableName, MiniTemplator.escapeHtml(variableValue), false);
    }

    public void setVariableOptEsc(String variableName, String variableValue) {
        this.setVariable(variableName, MiniTemplator.escapeHtml(variableValue), true);
    }

    public boolean variableExists(String variableName) {
        return this.parser.lookupVariableName(variableName) != -1;
    }

    public Map<String, String> getVariables() {
        HashMap<String, String> map = new HashMap<String, String>(this.parser.varTabCnt);
        for (int varNo = 0; varNo < this.parser.varTabCnt; ++varNo) {
            map.put(this.parser.varTab[varNo], this.varValuesTab[varNo]);
        }
        return map;
    }

    public void addBlock(String blockName, boolean isOptional) throws BlockNotDefinedException {
        int blockNo = this.parser.lookupBlockName(blockName);
        if (blockNo == -1) {
            if (isOptional) {
                return;
            }
            throw new BlockNotDefinedException(blockName);
        }
        while (blockNo != -1) {
            this.addBlockByNo(blockNo);
            blockNo = this.parser.blockTab[blockNo].nextWithSameName;
        }
    }

    public void addBlock(String blockName) throws BlockNotDefinedException {
        this.addBlock(blockName, false);
    }

    public void addBlockOpt(String blockName) {
        this.addBlock(blockName, true);
    }

    private void addBlockByNo(int blockNo) {
        MiniTemplatorParser.BlockTabRec btr = this.parser.blockTab[blockNo];
        BlockDynTabRec bdtr = this.blockDynTab[blockNo];
        int blockInstNo = this.registerBlockInstance();
        BlockInstTabRec bitr = this.blockInstTab[blockInstNo];
        if (bdtr.firstBlockInstNo == -1) {
            bdtr.firstBlockInstNo = blockInstNo;
        }
        if (bdtr.lastBlockInstNo != -1) {
            this.blockInstTab[bdtr.lastBlockInstNo].nextBlockInstNo = blockInstNo;
        }
        bdtr.lastBlockInstNo = blockInstNo;
        bitr.blockNo = blockNo;
        bitr.instanceLevel = bdtr.instances++;
        bitr.parentInstLevel = btr.parentBlockNo == -1 ? -1 : this.blockDynTab[btr.parentBlockNo].instances;
        bitr.nextBlockInstNo = -1;
        if (btr.blockVarCnt > 0) {
            bitr.blockVarTab = new String[btr.blockVarCnt];
        }
        for (int blockVarNo = 0; blockVarNo < btr.blockVarCnt; ++blockVarNo) {
            int varNo = btr.blockVarNoToVarNoMap[blockVarNo];
            bitr.blockVarTab[blockVarNo] = this.varValuesTab[varNo];
        }
    }

    private int registerBlockInstance() {
        int blockInstNo = this.blockInstTabCnt++;
        if (this.blockInstTab == null) {
            this.blockInstTab = new BlockInstTabRec[64];
        }
        if (this.blockInstTabCnt > this.blockInstTab.length) {
            this.blockInstTab = (BlockInstTabRec[])MiniTemplatorParser.resizeArray(this.blockInstTab, 2 * this.blockInstTabCnt);
        }
        this.blockInstTab[blockInstNo] = new BlockInstTabRec();
        return blockInstNo;
    }

    public boolean blockExists(String blockName) {
        return this.parser.lookupBlockName(blockName) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateOutput(String outputFileName) throws IOException {
        FileOutputStream stream = null;
        OutputStreamWriter writer = null;
        try {
            stream = new FileOutputStream(outputFileName);
            writer = new OutputStreamWriter((OutputStream)stream, this.charset);
            this.generateOutput(writer);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }

    public void generateOutput(Writer outputWriter) throws IOException {
        String s = this.generateOutput();
        outputWriter.write(s);
    }

    public String generateOutput() {
        if (this.blockDynTab[0].instances == 0) {
            this.addBlockByNo(0);
        }
        for (int blockNo = 0; blockNo < this.parser.blockTabCnt; ++blockNo) {
            BlockDynTabRec bdtr = this.blockDynTab[blockNo];
            bdtr.currBlockInstNo = bdtr.firstBlockInstNo;
        }
        StringBuilder out = new StringBuilder();
        this.writeBlockInstances(out, 0, -1);
        return out.toString();
    }

    private void writeBlockInstances(StringBuilder out, int blockNo, int parentInstLevel) {
        int blockInstNo;
        BlockDynTabRec bdtr = this.blockDynTab[blockNo];
        while ((blockInstNo = bdtr.currBlockInstNo) != -1) {
            BlockInstTabRec bitr = this.blockInstTab[blockInstNo];
            if (bitr.parentInstLevel < parentInstLevel) {
                throw new AssertionError();
            }
            if (bitr.parentInstLevel > parentInstLevel) break;
            this.writeBlockInstance(out, blockInstNo);
            bdtr.currBlockInstNo = bitr.nextBlockInstNo;
        }
    }

    private void writeBlockInstance(StringBuilder out, int blockInstNo) {
        BlockInstTabRec bitr = this.blockInstTab[blockInstNo];
        int blockNo = bitr.blockNo;
        MiniTemplatorParser.BlockTabRec btr = this.parser.blockTab[blockNo];
        int tPos = btr.tPosContentsBegin;
        int subBlockNo = blockNo + 1;
        int varRefNo = btr.firstVarRefNo;
        while (true) {
            MiniTemplatorParser.BlockTabRec subBtr;
            MiniTemplatorParser.VarRefTabRec vrtr;
            int tPos2 = btr.tPosContentsEnd;
            int kind = 0;
            if (varRefNo != -1 && varRefNo < this.parser.varRefTabCnt) {
                vrtr = this.parser.varRefTab[varRefNo];
                if (vrtr.tPosBegin < tPos) {
                    ++varRefNo;
                    continue;
                }
                if (vrtr.tPosBegin < tPos2) {
                    tPos2 = vrtr.tPosBegin;
                    kind = 1;
                }
            }
            if (subBlockNo < this.parser.blockTabCnt) {
                subBtr = this.parser.blockTab[subBlockNo];
                if (subBtr.tPosBegin < tPos) {
                    ++subBlockNo;
                    continue;
                }
                if (subBtr.tPosBegin < tPos2) {
                    tPos2 = subBtr.tPosBegin;
                    kind = 2;
                }
            }
            if (tPos2 > tPos) {
                String text = this.parser.templateText.substring(tPos, tPos2);
                out.append(text);
            }
            switch (kind) {
                case 0: {
                    return;
                }
                case 1: {
                    vrtr = this.parser.varRefTab[varRefNo];
                    if (vrtr.blockNo != blockNo) {
                        throw new AssertionError();
                    }
                    if (vrtr.escaped) {
                        int skipEscPos = vrtr.tPosBegin + 1;
                        String text = this.parser.templateText.substring(skipEscPos, vrtr.tPosEnd);
                        out.append(text);
                        tPos = vrtr.tPosEnd;
                    } else {
                        String variableValue = bitr.blockVarTab[vrtr.blockVarNo];
                        if (variableValue != null) {
                            out.append(variableValue);
                        }
                        tPos = variableValue == null && this.skipUndefinedVars ? vrtr.tPosBegin : vrtr.tPosEnd;
                    }
                    ++varRefNo;
                    break;
                }
                case 2: {
                    subBtr = this.parser.blockTab[subBlockNo];
                    if (subBtr.parentBlockNo != blockNo) {
                        throw new AssertionError();
                    }
                    this.writeBlockInstances(out, subBlockNo, bitr.instanceLevel);
                    tPos = subBtr.tPosEnd;
                    ++subBlockNo;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFileIntoString(String fileName) throws IOException {
        FileInputStream stream = null;
        InputStreamReader reader = null;
        try {
            stream = new FileInputStream(fileName);
            reader = new InputStreamReader((InputStream)stream, this.charset);
            String string = this.readStreamIntoString(reader);
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }

    private String readStreamIntoString(Reader reader) throws IOException {
        int l;
        StringBuilder s = new StringBuilder();
        char[] a = new char[65536];
        while ((l = reader.read(a)) != -1) {
            if (l <= 0) {
                throw new IOException();
            }
            s.append(a, 0, l);
        }
        return s.toString();
    }

    public static String escapeHtml(String s) {
        int p;
        if (s == null) {
            return null;
        }
        int sLength = s.length();
        boolean found = false;
        block10: for (p = 0; p < sLength; ++p) {
            switch (s.charAt(p)) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    found = true;
                    break block10;
                }
                default: {
                    continue block10;
                }
            }
        }
        if (!found) {
            return s;
        }
        StringBuilder sb = new StringBuilder(sLength + 16);
        sb.append(s.substring(0, p));
        while (p < sLength) {
            char c = s.charAt(p);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\'': {
                    sb.append("&#39;");
                    break;
                }
                case '\"': {
                    sb.append("&#34;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++p;
        }
        return sb.toString();
    }

    private static class BlockInstTabRec {
        int blockNo;
        int instanceLevel;
        int parentInstLevel;
        int nextBlockInstNo;
        String[] blockVarTab;

        private BlockInstTabRec() {
        }
    }

    private static class BlockDynTabRec {
        int instances;
        int firstBlockInstNo;
        int lastBlockInstNo;
        int currBlockInstNo;

        private BlockDynTabRec() {
        }
    }

    public static class Builder {
        private Set<String> conditionFlags = null;
        private boolean shortFormEnabled = false;
        private boolean skipUndefinedVars = false;
        private MiniTemplator result = new MiniTemplator();

        public Builder setConditionFlags(Set<String> conditionFlags) {
            this.conditionFlags = conditionFlags;
            return this;
        }

        public Builder setShortFormEnabled(boolean shortFormEnabled) {
            this.shortFormEnabled = shortFormEnabled;
            return this;
        }

        public Builder setSkipUndefinedVars(boolean skipUndefinedVars) {
            this.result.skipUndefinedVars = skipUndefinedVars;
            return this;
        }

        public Builder setSubtemplateBasePath(String subtemplateBasePath) {
            this.result.subtemplateBasePath = subtemplateBasePath;
            return this;
        }

        public Builder setCharset(Charset charset) {
            this.result.charset = charset;
            return this;
        }

        public final MiniTemplator build(InputStream content) throws IOException {
            if (content == null) {
                throw new IllegalArgumentException("content argument is null!");
            }
            if (this.result.charset == null) {
                throw new IllegalArgumentException("charset is not provided or is null!");
            }
            try (InputStreamReader r = new InputStreamReader(content, this.result.charset);){
                String templateText = this.result.readStreamIntoString(r);
                this.result.parser = new MiniTemplatorParser(templateText, this.conditionFlags, this.shortFormEnabled, this.result);
                this.result.reset();
            }
            return this.result;
        }

        public final MiniTemplator build(URL url) throws IOException {
            return this.build(url.openStream());
        }

        @Deprecated
        public final MiniTemplator build(InputStream content, Charset charset) throws IOException {
            return this.setCharset(charset).build(content);
        }

        @Deprecated
        public final MiniTemplator build(URL url, Charset charset) throws IOException {
            return this.build(url.openStream(), charset);
        }
    }

    public static class BlockNotDefinedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public BlockNotDefinedException(String blockName) {
            super(String.format("Block '%s' not defined in template.", blockName));
        }
    }

    public static class VariableNotDefinedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public VariableNotDefinedException(String variableName) {
            super(String.format("Variable '%s' not defined in template.", variableName));
        }
    }

    public static class TemplateSyntaxException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public TemplateSyntaxException(String msg) {
            super(String.format("Syntax error in template: %s", msg));
        }
    }
}

