/*
 * Decompiled with CFR 0.152.
 */
package org.bspfsystems.yamlconfiguration.configuration;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bspfsystems.yamlconfiguration.configuration.Configuration;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.bspfsystems.yamlconfiguration.serialization.ConfigurationSerializable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemorySection
implements ConfigurationSection {
    protected final Map<String, Object> map;
    private final Configuration root;
    private final ConfigurationSection parent;
    private final String path;
    private final String fullPath;

    protected MemorySection() {
        if (!(this instanceof Configuration)) {
            throw new IllegalStateException("Cannot construct a root MemorySection when this is not a Configuration.");
        }
        this.map = new LinkedHashMap<String, Object>();
        this.root = (Configuration)((Object)this);
        this.parent = null;
        this.path = "";
        this.fullPath = "";
    }

    protected MemorySection(@NotNull ConfigurationSection parent, @NotNull String path) {
        if (parent.getRoot() == null) {
            throw new IllegalArgumentException("Path cannot be orphaned.");
        }
        this.map = new LinkedHashMap<String, Object>();
        this.root = parent.getRoot();
        this.parent = parent;
        this.path = path;
        this.fullPath = MemorySection.createPath(parent, path);
    }

    @Override
    @NotNull
    public Set<String> getKeys(boolean deep) {
        ConfigurationSection defs;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Configuration root = this.getRoot();
        if (root != null && root.options().copyDefaults() && (defs = this.getDefaultSection()) != null) {
            result.addAll(defs.getKeys(deep));
        }
        this.mapChildrenKeys(result, this, deep);
        return result;
    }

    @Override
    @NotNull
    public Map<String, Object> getValues(boolean deep) {
        ConfigurationSection defs;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Configuration root = this.getRoot();
        if (root != null && root.options().copyDefaults() && (defs = this.getDefaultSection()) != null) {
            result.putAll(defs.getValues(deep));
        }
        this.mapChildrenValues(result, this, deep);
        return result;
    }

    @Override
    @NotNull
    public String getCurrentPath() {
        return this.fullPath;
    }

    @Override
    @NotNull
    public String getName() {
        return this.path;
    }

    @Override
    @Nullable
    public Configuration getRoot() {
        return this.root;
    }

    @Override
    @Nullable
    public ConfigurationSection getParent() {
        return this.parent;
    }

    @Override
    @Nullable
    public ConfigurationSection getDefaultSection() {
        Configuration defs;
        Configuration root = this.getRoot();
        Configuration configuration = defs = root == null ? null : root.getDefaults();
        if (defs != null && defs.isConfigurationSection(this.getCurrentPath())) {
            return defs.getConfigurationSection(this.getCurrentPath());
        }
        return null;
    }

    @Override
    public void addDefault(@NotNull String path, @Nullable Object value) {
        Configuration root = this.getRoot();
        if (root == null) {
            throw new IllegalStateException("Cannot add defaults without a root.");
        }
        if (root == this) {
            throw new UnsupportedOperationException("Unsupported addDefault(String, Object) implementation.");
        }
        root.addDefault(MemorySection.createPath(this, path), value);
    }

    @Override
    @NotNull
    public ConfigurationSection createSection(@NotNull String path) {
        int tail;
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Cannot set to an empty path.");
        }
        Configuration root = this.getRoot();
        if (root == null) {
            throw new IllegalStateException("Cannot create section without a root.");
        }
        char separator = root.options().pathSeparator();
        int lead = -1;
        ConfigurationSection section = this;
        while ((lead = path.indexOf(separator, tail = lead + 1)) != -1) {
            String node = path.substring(tail, lead);
            ConfigurationSection subSection = section.getConfigurationSection(node);
            if (subSection == null) {
                section = section.createSection(node);
                continue;
            }
            section = subSection;
        }
        String key = path.substring(tail);
        if (section == this) {
            MemorySection result = new MemorySection(this, key);
            this.map.put(key, result);
            return result;
        }
        return section.createSection(key);
    }

    @Override
    @NotNull
    public ConfigurationSection createSection(@NotNull String path, @NotNull Map<?, ?> map) {
        ConfigurationSection section = this.createSection(path);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                section.createSection(entry.getKey().toString(), (Map)entry.getValue());
                continue;
            }
            section.set(entry.getKey().toString(), entry.getValue());
        }
        return section;
    }

    @Override
    public boolean isSet(@NotNull String path) {
        Configuration root = this.getRoot();
        if (root == null) {
            return false;
        }
        if (root.options().copyDefaults()) {
            return this.contains(path);
        }
        return this.get(path, null) != null;
    }

    @Override
    public void set(@NotNull String path, @Nullable Object value) {
        int trail;
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Cannot set to an empty path.");
        }
        Configuration root = this.getRoot();
        if (root == null) {
            throw new IllegalStateException("Cannot use section without a root.");
        }
        char separator = root.options().pathSeparator();
        int lead = -1;
        ConfigurationSection section = this;
        while ((lead = path.indexOf(separator, trail = lead + 1)) != -1) {
            String node = path.substring(trail, lead);
            ConfigurationSection subSection = section.getConfigurationSection(node);
            if (subSection == null) {
                if (value == null) {
                    return;
                }
                section = section.createSection(node);
                continue;
            }
            section = subSection;
        }
        String key = path.substring(trail);
        if (section == this) {
            if (value == null) {
                this.map.remove(key);
            } else {
                this.map.put(key, value);
            }
        } else {
            section.set(key, value);
        }
    }

    @Override
    public boolean contains(@NotNull String path) {
        return this.contains(path, false);
    }

    @Override
    public boolean contains(@NotNull String path, boolean ignoreDefault) {
        return (ignoreDefault ? this.get(path, null) : this.get(path)) != null;
    }

    @Override
    @Nullable
    public Object get(@NotNull String path) {
        return this.get(path, this.getDefault(path));
    }

    @Override
    @Contract(value="_, !null -> !null")
    @Nullable
    public Object get(@NotNull String path, @Nullable Object def) {
        int tail;
        if (path.length() == 0) {
            return this;
        }
        Configuration root = this.getRoot();
        if (root == null) {
            throw new IllegalStateException("Cannot access section without a root.");
        }
        char separator = root.options().pathSeparator();
        int lead = -1;
        ConfigurationSection section = this;
        while ((lead = path.indexOf(separator, tail = lead + 1)) != -1) {
            if ((section = section.getConfigurationSection(path.substring(tail, lead))) != null) continue;
            return def;
        }
        String key = path.substring(tail);
        if (section == this) {
            Object result = this.map.get(key);
            return result == null ? def : result;
        }
        return section.get(key, def);
    }

    @Override
    public boolean isBoolean(@NotNull String path) {
        return this.get(path) instanceof Boolean;
    }

    @Override
    public boolean getBoolean(@NotNull String path) {
        Object def = this.getDefault(path);
        return this.getBoolean(path, def instanceof Boolean && (Boolean)def != false);
    }

    @Override
    public boolean getBoolean(@NotNull String path, boolean def) {
        Object val = this.get(path, def);
        return val instanceof Boolean ? (Boolean)val : def;
    }

    @Override
    public boolean isByte(@NotNull String path) {
        return this.get(path) instanceof Byte;
    }

    @Override
    public byte getByte(@NotNull String path) {
        Object def = this.getDefault(path);
        return this.getByte(path, def instanceof Number ? ((Number)def).byteValue() : (byte)0);
    }

    @Override
    public byte getByte(@NotNull String path, byte def) {
        Object val = this.get(path, def);
        return val instanceof Number ? ((Number)val).byteValue() : def;
    }

    @Override
    public boolean isShort(@NotNull String path) {
        return this.get(path) instanceof Short;
    }

    @Override
    public short getShort(@NotNull String path) {
        Object def = this.getDefault(path);
        return this.getShort(path, def instanceof Number ? ((Number)def).shortValue() : (short)0);
    }

    @Override
    public short getShort(@NotNull String path, short def) {
        Object val = this.get(path, def);
        return val instanceof Number ? ((Number)val).shortValue() : def;
    }

    @Override
    public boolean isInt(@NotNull String path) {
        return this.get(path) instanceof Integer;
    }

    @Override
    public int getInt(@NotNull String path) {
        Object def = this.getDefault(path);
        return this.getInt(path, def instanceof Number ? ((Number)def).intValue() : 0);
    }

    @Override
    public int getInt(@NotNull String path, int def) {
        Object val = this.get(path, def);
        return val instanceof Number ? ((Number)val).intValue() : def;
    }

    @Override
    public boolean isLong(@NotNull String path) {
        return this.get(path) instanceof Long;
    }

    @Override
    public long getLong(@NotNull String path) {
        Object def = this.getDefault(path);
        return this.getLong(path, def instanceof Number ? (Long)def : 0L);
    }

    @Override
    public long getLong(@NotNull String path, long def) {
        Object val = this.get(path, def);
        return val instanceof Number ? (Long)val : def;
    }

    @Override
    public boolean isFloat(@NotNull String path) {
        return this.get(path) instanceof Float;
    }

    @Override
    public float getFloat(@NotNull String path) {
        Object def = this.getDefault(path);
        return this.getFloat(path, def instanceof Number ? ((Number)def).floatValue() : 0.0f);
    }

    @Override
    public float getFloat(@NotNull String path, float def) {
        Object val = this.get(path, Float.valueOf(def));
        return val instanceof Number ? ((Number)val).floatValue() : def;
    }

    @Override
    public boolean isDouble(@NotNull String path) {
        return this.get(path) instanceof Double;
    }

    @Override
    public double getDouble(@NotNull String path) {
        Object def = this.getDefault(path);
        return this.getDouble(path, def instanceof Number ? ((Number)def).doubleValue() : 0.0);
    }

    @Override
    public double getDouble(@NotNull String path, double def) {
        Object val = this.get(path, def);
        return val instanceof Number ? ((Number)val).doubleValue() : def;
    }

    @Override
    public boolean isChar(@NotNull String path) {
        return this.get(path) instanceof Boolean;
    }

    @Override
    public char getChar(@NotNull String path) {
        Object def = this.getDefault(path);
        return this.getChar(path, def instanceof Character ? ((Character)def).charValue() : (char)'\u0000');
    }

    @Override
    public char getChar(@NotNull String path, char def) {
        Object val = this.get(path, Character.valueOf(def));
        return val instanceof Character ? ((Character)val).charValue() : def;
    }

    @Override
    public boolean isString(@NotNull String path) {
        return this.get(path) instanceof String;
    }

    @Override
    @Nullable
    public String getString(@NotNull String path) {
        Object def = this.getDefault(path);
        return this.getString(path, def != null ? def.toString() : null);
    }

    @Override
    @Contract(value="_, !null -> !null")
    @Nullable
    public String getString(@NotNull String path, @Nullable String def) {
        Object val = this.get(path, def);
        return val != null ? val.toString() : def;
    }

    @Override
    public boolean isList(@NotNull String path) {
        return this.get(path) instanceof List;
    }

    @Override
    @Nullable
    public List<?> getList(@NotNull String path) {
        Object def = this.getDefault(path);
        return this.getList(path, def instanceof List ? (List)def : null);
    }

    @Override
    @Contract(value="_, !null -> !null")
    @Nullable
    public List<?> getList(@NotNull String path, @Nullable List<?> def) {
        Object val = this.get(path, def);
        return val instanceof List ? (List)val : def;
    }

    @Override
    public boolean isConfigurationSection(@NotNull String path) {
        return this.get(path) instanceof ConfigurationSection;
    }

    @Override
    @Nullable
    public ConfigurationSection getConfigurationSection(@NotNull String path) {
        Object val = this.get(path, null);
        if (val != null) {
            return val instanceof ConfigurationSection ? (ConfigurationSection)val : null;
        }
        val = this.get(path, this.getDefault(path));
        return val instanceof ConfigurationSection ? this.createSection(path) : null;
    }

    @Override
    @Nullable
    public <T> T getObject(@NotNull String path, @NotNull Class<T> clazz) {
        Object def = this.getDefault(path);
        return this.getObject(path, clazz, clazz.isInstance(def) ? (T)clazz.cast(def) : null);
    }

    @Override
    @Contract(value="_, _, !null -> !null")
    @Nullable
    public <T> T getObject(@NotNull String path, @NotNull Class<T> clazz, @Nullable T def) {
        Object val = this.get(path, def);
        return clazz.isInstance(val) ? clazz.cast(val) : def;
    }

    @Override
    @Nullable
    public <T extends ConfigurationSerializable> T getSerializable(@NotNull String path, @NotNull Class<T> clazz) {
        return (T)((ConfigurationSerializable)this.getObject(path, clazz));
    }

    @Override
    @Contract(value="_, _, !null -> !null")
    @Nullable
    public <T extends ConfigurationSerializable> T getSerializable(@NotNull String path, @NotNull Class<T> clazz, @Nullable T def) {
        return (T)((ConfigurationSerializable)this.getObject(path, clazz, def));
    }

    @Override
    @NotNull
    public List<Boolean> getBooleanList(@NotNull String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Boolean>(0);
        }
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (Object object : list) {
            if (object instanceof Boolean) {
                result.add((Boolean)object);
                continue;
            }
            if (!(object instanceof String)) continue;
            result.add(Boolean.valueOf((String)object));
        }
        return result;
    }

    @Override
    @NotNull
    public List<Byte> getByteList(@NotNull String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Byte>(0);
        }
        ArrayList<Byte> result = new ArrayList<Byte>();
        for (Object object : list) {
            if (object instanceof Byte) {
                result.add((Byte)object);
                continue;
            }
            if (object instanceof String) {
                try {
                    result.add(Byte.valueOf((String)object));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (object instanceof Character) {
                try {
                    result.add((byte)((Character)object).charValue());
                }
                catch (ClassCastException classCastException) {}
                continue;
            }
            if (!(object instanceof Number)) continue;
            result.add(((Number)object).byteValue());
        }
        return result;
    }

    @Override
    @NotNull
    public List<Short> getShortList(@NotNull String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Short>(0);
        }
        ArrayList<Short> result = new ArrayList<Short>();
        for (Object object : list) {
            if (object instanceof Short) {
                result.add((Short)object);
                continue;
            }
            if (object instanceof String) {
                try {
                    result.add(Short.valueOf((String)object));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (object instanceof Character) {
                try {
                    result.add((short)((Character)object).charValue());
                }
                catch (ClassCastException classCastException) {}
                continue;
            }
            if (!(object instanceof Number)) continue;
            result.add(((Number)object).shortValue());
        }
        return result;
    }

    @Override
    @NotNull
    public List<Integer> getIntList(@NotNull String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Integer>(0);
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Object object : list) {
            if (object instanceof Integer) {
                result.add((Integer)object);
                continue;
            }
            if (object instanceof String) {
                try {
                    result.add(Integer.valueOf((String)object));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (object instanceof Character) {
                try {
                    result.add(Integer.valueOf(((Character)object).charValue()));
                }
                catch (ClassCastException classCastException) {}
                continue;
            }
            if (!(object instanceof Number)) continue;
            result.add(((Number)object).intValue());
        }
        return result;
    }

    @Override
    @NotNull
    public List<Long> getLongList(@NotNull String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> result = new ArrayList<Long>();
        for (Object object : list) {
            if (object instanceof Long) {
                result.add((Long)object);
                continue;
            }
            if (object instanceof String) {
                try {
                    result.add(Long.valueOf((String)object));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (object instanceof Character) {
                try {
                    result.add(Long.valueOf(((Character)object).charValue()));
                }
                catch (ClassCastException classCastException) {}
                continue;
            }
            if (!(object instanceof Number)) continue;
            result.add(((Number)object).longValue());
        }
        return result;
    }

    @Override
    @NotNull
    public List<Float> getFloatList(@NotNull String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Float>(0);
        }
        ArrayList<Float> result = new ArrayList<Float>();
        for (Object object : list) {
            if (object instanceof Float) {
                result.add((Float)object);
                continue;
            }
            if (object instanceof String) {
                try {
                    result.add(Float.valueOf((String)object));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (object instanceof Character) {
                try {
                    result.add(Float.valueOf(((Character)object).charValue()));
                }
                catch (ClassCastException classCastException) {}
                continue;
            }
            if (!(object instanceof Number)) continue;
            result.add(Float.valueOf(((Number)object).floatValue()));
        }
        return result;
    }

    @Override
    @NotNull
    public List<Double> getDoubleList(@NotNull String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Double>(0);
        }
        ArrayList<Double> result = new ArrayList<Double>();
        for (Object object : list) {
            if (object instanceof Double) {
                result.add((Double)object);
                continue;
            }
            if (object instanceof String) {
                try {
                    result.add(Double.valueOf((String)object));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (object instanceof Character) {
                try {
                    result.add(Double.valueOf(((Character)object).charValue()));
                }
                catch (ClassCastException classCastException) {}
                continue;
            }
            if (!(object instanceof Number)) continue;
            result.add(((Number)object).doubleValue());
        }
        return result;
    }

    @Override
    @NotNull
    public List<Character> getCharList(@NotNull String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Character>(0);
        }
        ArrayList<Character> result = new ArrayList<Character>();
        for (Object object : list) {
            if (object instanceof Character) {
                result.add((Character)object);
                continue;
            }
            if (!(object instanceof String) || ((String)object).length() != 1) continue;
            result.add(Character.valueOf(((String)object).charAt(0)));
        }
        return result;
    }

    @Override
    @NotNull
    public List<String> getStringList(@NotNull String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Object object : list) {
            if (object == null) continue;
            result.add(object.toString());
        }
        return result;
    }

    @Override
    @NotNull
    public List<Map<?, ?>> getMapList(@NotNull String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList(0);
        }
        ArrayList result = new ArrayList();
        for (Object object : list) {
            if (!(object instanceof Map)) continue;
            result.add((Map)object);
        }
        return result;
    }

    @Nullable
    protected Object getDefault(@NotNull String path) {
        Configuration root = this.getRoot();
        Configuration defs = root == null ? null : root.getDefaults();
        return defs == null ? null : defs.get(MemorySection.createPath(this, path));
    }

    protected void mapChildrenKeys(@NotNull Set<String> output, @NotNull ConfigurationSection section, boolean deep) {
        if (section instanceof MemorySection) {
            MemorySection memorySection = (MemorySection)section;
            for (Map.Entry<String, Object> entry : memorySection.map.entrySet()) {
                output.add(MemorySection.createPath(section, entry.getKey(), this));
                if (!deep || !(entry.getValue() instanceof ConfigurationSection)) continue;
                this.mapChildrenKeys(output, (ConfigurationSection)entry.getValue(), deep);
            }
        } else {
            Set<String> keys = section.getKeys(deep);
            for (String key : keys) {
                output.add(MemorySection.createPath(section, key, this));
            }
        }
    }

    protected void mapChildrenValues(@NotNull Map<String, Object> output, @NotNull ConfigurationSection section, boolean deep) {
        if (section instanceof MemorySection) {
            MemorySection memorySection = (MemorySection)section;
            for (Map.Entry<String, Object> entry : memorySection.map.entrySet()) {
                String path = MemorySection.createPath(section, entry.getKey(), this);
                output.remove(path);
                output.put(path, entry.getValue());
                if (!deep || !(entry.getValue() instanceof ConfigurationSection)) continue;
                this.mapChildrenValues(output, (ConfigurationSection)entry.getValue(), deep);
            }
        } else {
            Map<String, Object> values = section.getValues(deep);
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                output.put(MemorySection.createPath(section, entry.getKey(), this), entry.getValue());
            }
        }
    }

    public String toString() {
        Configuration root = this.getRoot();
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("[path='");
        builder.append(this.getCurrentPath());
        builder.append("', root='");
        builder.append(root == null ? null : root.getClass().getSimpleName());
        builder.append("']");
        return builder.toString();
    }

    @NotNull
    public static String createPath(@NotNull ConfigurationSection section, @Nullable String key) {
        return MemorySection.createPath(section, key, section.getRoot());
    }

    @NotNull
    public static String createPath(@NotNull ConfigurationSection section, @Nullable String key, @Nullable ConfigurationSection relative) {
        Configuration root = section.getRoot();
        if (root == null) {
            throw new IllegalStateException("Cannot create path without a root.");
        }
        char separator = root.options().pathSeparator();
        StringBuilder builder = new StringBuilder();
        for (ConfigurationSection parent = section; parent != null && parent != relative; parent = parent.getParent()) {
            if (builder.length() > 0) {
                builder.insert(0, separator);
            }
            builder.insert(0, parent.getName());
        }
        if (key != null && key.length() > 0) {
            if (builder.length() > 0) {
                builder.append(separator);
            }
            builder.append(key);
        }
        return builder.toString();
    }
}

