/*
 * Decompiled with CFR 0.152.
 */
package org.bspfsystems.yamlconfiguration.serialization;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bspfsystems.yamlconfiguration.serialization.ConfigurationSerializable;
import org.bspfsystems.yamlconfiguration.serialization.DelegateDeserialization;
import org.bspfsystems.yamlconfiguration.serialization.SerializableAs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigurationSerialization {
    public static final String SERIALIZED_TYPE_KEY = "==";
    private static final Map<String, Class<? extends ConfigurationSerializable>> ALIASES = new HashMap<String, Class<? extends ConfigurationSerializable>>();
    private final Class<? extends ConfigurationSerializable> clazz;

    protected ConfigurationSerialization(@NotNull Class<? extends ConfigurationSerializable> clazz) {
        this.clazz = clazz;
    }

    @Nullable
    public ConfigurationSerializable deserialize(@NotNull Map<String, ?> args) {
        Constructor<? extends ConfigurationSerializable> constructor;
        ConfigurationSerializable result = null;
        Method method = this.getMethod("deserialize", true);
        if (method != null) {
            result = this.deserializeViaMethod(method, args);
        }
        if (result == null && (method = this.getMethod("valueOf", true)) != null) {
            result = this.deserializeViaMethod(method, args);
        }
        if (result == null && (constructor = this.getConstructor()) != null) {
            result = this.deserializeViaConstructor(constructor, args);
        }
        return result;
    }

    @Nullable
    protected Constructor<? extends ConfigurationSerializable> getConstructor() {
        try {
            return this.clazz.getConstructor(Map.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    @Nullable
    protected Method getMethod(@NotNull String name, boolean isStatic) {
        try {
            Method method = this.clazz.getDeclaredMethod(name, Map.class);
            if (!ConfigurationSerializable.class.isAssignableFrom(method.getReturnType())) {
                return null;
            }
            if (Modifier.isStatic(method.getModifiers()) != isStatic) {
                return null;
            }
            return method;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    @Nullable
    protected ConfigurationSerializable deserializeViaConstructor(@NotNull Constructor<? extends ConfigurationSerializable> constructor, @NotNull Map<String, ?> args) {
        try {
            return constructor.newInstance(args);
        }
        catch (Throwable t) {
            Logger.getLogger(ConfigurationSerialization.class.getName()).log(Level.SEVERE, "Could not call constructor '" + constructor.toString() + "' of " + this.clazz + "for deserialization.", t instanceof InvocationTargetException ? t.getCause() : t);
            return null;
        }
    }

    @Nullable
    protected ConfigurationSerializable deserializeViaMethod(@NotNull Method method, @NotNull Map<String, ?> args) {
        try {
            ConfigurationSerializable result = (ConfigurationSerializable)method.invoke(null, args);
            if (result != null) {
                return result;
            }
            Logger.getLogger(ConfigurationSerialization.class.getName()).log(Level.SEVERE, "Could not call method '" + method.toString() + "' of " + this.clazz + " for deserialization: method returned null.");
        }
        catch (Throwable t) {
            Logger.getLogger(ConfigurationSerialization.class.getName()).log(Level.SEVERE, "Could not call method '" + method.toString() + "' of " + this.clazz + " for deserialization.", t instanceof InvocationTargetException ? t.getCause() : t);
        }
        return null;
    }

    @Nullable
    public static ConfigurationSerializable deserializeObject(@NotNull Map<String, ?> args, @NotNull Class<? extends ConfigurationSerializable> clazz) {
        return new ConfigurationSerialization(clazz).deserialize(args);
    }

    @Nullable
    public static ConfigurationSerializable deserializeObject(@NotNull Map<String, ?> args) {
        Class<? extends ConfigurationSerializable> clazz;
        block5: {
            clazz = null;
            if (args.containsKey(SERIALIZED_TYPE_KEY)) {
                try {
                    String alias = (String)args.get(SERIALIZED_TYPE_KEY);
                    if (alias == null) {
                        throw new IllegalArgumentException("Cannot have null alias.");
                    }
                    clazz = ConfigurationSerialization.getClassByAlias(alias);
                    if (clazz == null) {
                        throw new IllegalArgumentException("Specified class does not exist ('" + alias + "').");
                    }
                    break block5;
                }
                catch (ClassCastException e) {
                    e.fillInStackTrace();
                    throw e;
                }
            }
            throw new IllegalArgumentException("Args doesn't contain type key ('==').");
        }
        return new ConfigurationSerialization(clazz).deserialize(args);
    }

    public static void registerClass(@NotNull Class<? extends ConfigurationSerializable> clazz) {
        DelegateDeserialization delegate = clazz.getAnnotation(DelegateDeserialization.class);
        if (delegate == null) {
            ConfigurationSerialization.registerClass(clazz, ConfigurationSerialization.getAlias(clazz));
            ConfigurationSerialization.registerClass(clazz, clazz.getName());
        }
    }

    public static void registerClass(@NotNull Class<? extends ConfigurationSerializable> clazz, @NotNull String alias) {
        ALIASES.put(alias, clazz);
    }

    public static void unregisterClass(@NotNull String alias) {
        ALIASES.remove(alias);
    }

    public static void unregisterClass(@NotNull Class<? extends ConfigurationSerializable> clazz) {
        while (ALIASES.values().remove(clazz)) {
        }
    }

    @Nullable
    public static Class<? extends ConfigurationSerializable> getClassByAlias(@NotNull String alias) {
        return ALIASES.get(alias);
    }

    @NotNull
    public static String getAlias(@NotNull Class<? extends ConfigurationSerializable> clazz) {
        SerializableAs alias;
        DelegateDeserialization delegate = clazz.getAnnotation(DelegateDeserialization.class);
        if (delegate != null) {
            if (delegate.value() == clazz) {
                delegate = null;
            } else {
                return ConfigurationSerialization.getAlias(delegate.value());
            }
        }
        if ((alias = clazz.getAnnotation(SerializableAs.class)) != null) {
            return alias.value();
        }
        return clazz.getName();
    }
}

