/*
 * Decompiled with CFR 0.152.
 */
package org.bspfsystems.yamlconfiguration.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.bspfsystems.yamlconfiguration.configuration.Configuration;
import org.bspfsystems.yamlconfiguration.configuration.InvalidConfigurationException;
import org.bspfsystems.yamlconfiguration.configuration.MemoryConfiguration;
import org.bspfsystems.yamlconfiguration.file.FileConfigurationOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileConfiguration
extends MemoryConfiguration {
    public FileConfiguration() {
    }

    public FileConfiguration(@Nullable Configuration defs) {
        super(defs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null.");
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        String data = this.saveToString();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8.name());){
            writer.write(data);
        }
    }

    public void save(@NotNull String fileName) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("File name cannot be null.");
        }
        this.save(new File(fileName));
    }

    @NotNull
    public abstract String saveToString();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(@NotNull Reader reader) throws IOException, InvalidConfigurationException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                builder.append(line);
                builder.append('\n');
            }
        }
        this.loadFromString(builder.toString());
    }

    public void load(@NotNull File file) throws FileNotFoundException, IOException, InvalidConfigurationException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null.");
        }
        this.load(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8.name()));
    }

    public void load(@NotNull String fileName) throws FileNotFoundException, IOException, InvalidConfigurationException {
        if (fileName == null) {
            throw new IllegalArgumentException("File name cannot be null.");
        }
        this.load(new File(fileName));
    }

    public abstract void loadFromString(@NotNull String var1) throws InvalidConfigurationException;

    @NotNull
    protected abstract String buildHeader();

    @Override
    @NotNull
    public FileConfigurationOptions options() {
        if (this.options == null) {
            this.options = new FileConfigurationOptions(this);
        }
        return (FileConfigurationOptions)this.options;
    }
}

