/*
 * Decompiled with CFR 0.152.
 */
package org.bspfsystems.yamlconfiguration.file;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bspfsystems.yamlconfiguration.configuration.Configuration;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.bspfsystems.yamlconfiguration.configuration.InvalidConfigurationException;
import org.bspfsystems.yamlconfiguration.file.FileConfiguration;
import org.bspfsystems.yamlconfiguration.file.YamlConfigurationOptions;
import org.bspfsystems.yamlconfiguration.file.YamlConstructor;
import org.bspfsystems.yamlconfiguration.file.YamlRepresenter;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.representer.Representer;

public final class YamlConfiguration
extends FileConfiguration {
    protected static final String COMMENT_PREFIX = "# ";
    protected static final String BLANK_CONFIG = "{}\n";
    private final DumperOptions yamlOptions = new DumperOptions();
    private final Representer yamlRepresenter = new YamlRepresenter();
    private final Yaml yaml = new Yaml(new YamlConstructor(), this.yamlRepresenter, this.yamlOptions);

    @Override
    @NotNull
    public String saveToString() {
        this.yamlOptions.setIndent(this.options().indent());
        this.yamlOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yamlRepresenter.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        String header = this.buildHeader();
        String dump = this.yaml.dump(this.getValues(false));
        if (dump.equals(BLANK_CONFIG)) {
            dump = "";
        }
        return header + dump;
    }

    @Override
    public void loadFromString(@NotNull String data) throws InvalidConfigurationException {
        Map map;
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        try {
            map = (Map)this.yaml.load(data);
        }
        catch (YAMLException e) {
            throw new InvalidConfigurationException(e);
        }
        catch (ClassCastException e) {
            throw new InvalidConfigurationException("Top level is not a Map.", e);
        }
        String header = this.parseHeader(data);
        if (header.length() > 0) {
            this.options().header(header);
        }
        if (map != null) {
            this.convertMapsToSections(map, this);
        }
    }

    protected void convertMapsToSections(@NotNull Map<?, ?> map, @NotNull ConfigurationSection section) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value instanceof Map) {
                this.convertMapsToSections((Map)value, section.createSection(key));
                continue;
            }
            section.set(key, value);
        }
    }

    @NotNull
    protected String parseHeader(@NotNull String data) {
        String[] lines = data.split("\r?\n", -1);
        StringBuilder builder = new StringBuilder();
        boolean readingHeader = true;
        boolean foundHeader = false;
        for (int index = 0; index < lines.length && readingHeader; ++index) {
            String line = lines[index];
            if (line.startsWith(COMMENT_PREFIX)) {
                if (index > 0) {
                    builder.append("\n");
                }
                if (line.length() > COMMENT_PREFIX.length()) {
                    builder.append(line.substring(COMMENT_PREFIX.length()));
                }
                foundHeader = true;
                continue;
            }
            if (foundHeader && line.length() == 0) {
                builder.append("\n");
                continue;
            }
            if (!foundHeader) continue;
            readingHeader = false;
        }
        return builder.toString();
    }

    @Override
    @NotNull
    protected String buildHeader() {
        FileConfiguration fileDef;
        String defHeader;
        Configuration def;
        String header = this.options().header();
        if (this.options().copyHeader() && (def = this.getDefaults()) != null && def instanceof FileConfiguration && (defHeader = (fileDef = (FileConfiguration)def).buildHeader()) != null && defHeader.length() > 0) {
            return defHeader;
        }
        if (header == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String[] lines = header.split("\r?\n", -1);
        boolean startedHeader = false;
        for (int index = lines.length; index >= 0; --index) {
            builder.insert(0, "\n");
            if (!startedHeader && lines[index].length() == 0) continue;
            builder.insert(0, lines[index]);
            builder.insert(0, COMMENT_PREFIX);
            startedHeader = true;
        }
        return builder.toString();
    }

    @Override
    @NotNull
    public YamlConfigurationOptions options() {
        if (this.options == null) {
            this.options = new YamlConfigurationOptions(this);
        }
        return (YamlConfigurationOptions)this.options;
    }

    @NotNull
    public static YamlConfiguration loadConfiguration(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null.");
        }
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(file);
        }
        catch (IOException | InvalidConfigurationException e) {
            Logger.getLogger(YamlConfiguration.class.getName()).log(Level.SEVERE, "Cannot load config from file: " + file, e);
        }
        return config;
    }

    @NotNull
    public static YamlConfiguration loadConfiguration(@NotNull Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("Reader cannot be null.");
        }
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(reader);
        }
        catch (IOException | InvalidConfigurationException e) {
            Logger.getLogger(YamlConfiguration.class.getName()).log(Level.SEVERE, "Cannot load config from reader.", e);
        }
        return config;
    }
}

