/*
 * This file is part of YamlConfiguration.
 *
 * Implementation of SnakeYAML to be easy to use with files.
 *
 * Copyright (C) 2014-2021 SpigotMC Pty. Ltd. (https://www.spigotmc.org/)
 * Copyright (C) 2020-2021 BSPF Systems, LLC (https://bspfsystems.org/)
 *
 * Many of the files in this project are sourced from the Bukkit API as
 * part of the SpigotMC project (https://hub.spigotmc.org/stash/).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.bspfsystems.yamlconfiguration.configuration;

import org.jetbrains.annotations.NotNull;

/**
 * Various settings for controlling the input and output of a {@link
 * MemoryConfiguration}
 */
public class MemoryConfigurationOptions extends ConfigurationOptions {
	
	/**
	 * Constructs a new set of {@link MemoryConfigurationOptions}.
	 * 
	 * @param configuration The {@link MemoryConfiguration} to create the
	 *                      {@link MemoryConfigurationOptions} for.
	 * @see ConfigurationOptions#ConfigurationOptions(Configuration)
	 */
	protected MemoryConfigurationOptions(@NotNull final MemoryConfiguration configuration) {
		super(configuration);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	@NotNull
	public MemoryConfiguration configuration() {
		return (MemoryConfiguration) super.configuration();
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	@NotNull
	public MemoryConfigurationOptions pathSeparator(final char pathSeparator) {
		super.pathSeparator(pathSeparator);
		return this;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	@NotNull
	public MemoryConfigurationOptions copyDefaults(final boolean copyDefaults) {
		super.copyDefaults(copyDefaults);
		return this;
	}
}
