/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.extension.iterable;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.burningwave.core.Component;

public class ObjectAssociations<A, B, C>
implements Component,
Serializable {
    private static final long serialVersionUID = -8746196679726732982L;
    private Map<A, Map<B, C>> associations = new LinkedHashMap<A, Map<B, C>>();

    public ObjectAssociations<A, B, C> clear() {
        this.associations.clear();
        return this;
    }

    public C getRightAssociationFor(A a, B b) {
        Map<B, C> rightAssociations = this.getRightAssociationsFor(a);
        return rightAssociations.get(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<B, C> getRightAssociationsFor(A a) {
        Map<B, C> rightAssociations = this.associations.get(a);
        if (rightAssociations == null) {
            ObjectAssociations objectAssociations = this;
            synchronized (objectAssociations) {
                rightAssociations = this.associations.get(a);
                if (rightAssociations == null) {
                    rightAssociations = new LinkedHashMap<B, C>();
                    this.associations.put(a, rightAssociations);
                }
            }
        }
        return rightAssociations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRightAssociation(A a, B b, C c) {
        Map<B, C> rightAssociations = this.getRightAssociationsFor(a);
        C associatedObj = rightAssociations.get(b);
        if (associatedObj == null) {
            ObjectAssociations objectAssociations = this;
            synchronized (objectAssociations) {
                associatedObj = rightAssociations.get(b);
                if (associatedObj == null) {
                    rightAssociations.put(b, c);
                }
            }
        }
    }
}

