/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.extension;

import org.burningwave.core.Component;

public abstract class CommandWrapper<T, C, I, O>
implements Component {
    C command;
    T target;

    public T getTarget() {
        return this.target;
    }

    public abstract O executeOn(I var1);

    public static <T, F, I, O, W extends CommandWrapper<T, F, I, O>> W create(F functionInterface, T instance) throws Throwable {
        if (functionInterface instanceof java.lang.Runnable) {
            return (W)new Runnable(instance, (java.lang.Runnable)functionInterface);
        }
        if (functionInterface instanceof java.util.function.Predicate) {
            return (W)new Predicate(instance, (java.util.function.Predicate)functionInterface);
        }
        if (functionInterface instanceof java.util.function.BiPredicate) {
            return (W)new BiPredicate(instance, (java.util.function.BiPredicate)functionInterface);
        }
        if (functionInterface instanceof java.util.function.Consumer) {
            return (W)new Consumer(instance, (java.util.function.Consumer)functionInterface);
        }
        if (functionInterface instanceof java.util.function.BiConsumer) {
            return (W)new BiConsumer(instance, (java.util.function.BiConsumer)functionInterface);
        }
        if (functionInterface instanceof java.util.function.Supplier) {
            return (W)new Supplier(instance, (java.util.function.Supplier)functionInterface);
        }
        if (functionInterface instanceof java.util.function.Function) {
            return (W)new Function(instance, (java.util.function.Function)functionInterface);
        }
        if (functionInterface instanceof java.util.function.BiFunction) {
            return (W)new BiFunction(instance, (java.util.function.BiFunction)functionInterface);
        }
        return null;
    }

    CommandWrapper(T target, C t) {
        this.target = target;
        this.command = t;
    }

    public void close() {
        this.command = null;
        this.target = null;
    }

    static class Runnable<T, I, O>
    extends CommandWrapper<T, java.lang.Runnable, I, O> {
        Runnable(T target, java.lang.Runnable t) {
            super(target, t);
        }

        @Override
        public O executeOn(I data) {
            ((java.lang.Runnable)this.command).run();
            return (O)data;
        }
    }

    static class Predicate<T, I, O>
    extends CommandWrapper<T, java.util.function.Predicate<I>, I, O> {
        Predicate(T target, java.util.function.Predicate<I> t) {
            super(target, t);
        }

        @Override
        public O executeOn(I data) {
            ((java.util.function.Predicate)this.command).test(data);
            return (O)data;
        }
    }

    static class BiPredicate<T, I, O>
    extends CommandWrapper<T, java.util.function.BiPredicate<T, I>, I, O> {
        BiPredicate(T target, java.util.function.BiPredicate<T, I> t) {
            super(target, t);
        }

        @Override
        public O executeOn(I data) {
            ((java.util.function.BiPredicate)this.command).test(this.target, data);
            return (O)data;
        }
    }

    static class Consumer<T, I, O>
    extends CommandWrapper<T, java.util.function.Consumer<I>, I, O> {
        Consumer(T target, java.util.function.Consumer<I> t) {
            super(target, t);
        }

        @Override
        public O executeOn(I data) {
            ((java.util.function.Consumer)this.command).accept(data);
            return (O)data;
        }
    }

    static class BiConsumer<T, I, O>
    extends CommandWrapper<T, java.util.function.BiConsumer<T, I>, I, O> {
        BiConsumer(T target, java.util.function.BiConsumer<T, I> t) {
            super(target, t);
        }

        @Override
        public O executeOn(I data) {
            ((java.util.function.BiConsumer)this.command).accept(this.target, data);
            return (O)data;
        }
    }

    static class Supplier<T, I, O>
    extends CommandWrapper<T, java.util.function.Supplier<O>, I, O> {
        Supplier(T target, java.util.function.Supplier<O> t) {
            super(target, t);
        }

        @Override
        public O executeOn(I data) {
            return (O)((java.util.function.Supplier)this.command).get();
        }
    }

    static class Function<T, I, O>
    extends CommandWrapper<T, java.util.function.Function<I, O>, I, O> {
        Function(T target, java.util.function.Function<I, O> t) {
            super(target, t);
        }

        @Override
        public O executeOn(I data) {
            return (O)((java.util.function.Function)this.command).apply(data);
        }
    }

    static class BiFunction<T, I, O>
    extends CommandWrapper<T, java.util.function.BiFunction<T, I, O>, I, O> {
        BiFunction(T target, java.util.function.BiFunction<T, I, O> t) {
            super(target, t);
        }

        @Override
        public O executeOn(I data) {
            return (O)((java.util.function.BiFunction)this.command).apply(this.target, data);
        }
    }
}

