/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.extension.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.burningwave.core.Component;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.extension.concurrent.CollectionWrapper;
import org.burningwave.core.extension.concurrent.ConcurrentHelper;
import org.burningwave.core.extension.concurrent.Cycler;

public class CollectionManager<T>
implements Component {
    private ConcurrentHelper concurrentHelper;
    private Map<Collection<T>, CollectionWrapper<T>> collectionWrapper;
    private List<Cycler.Thread> threadList;
    private String threadsGroupName;
    private int threadNumber;
    private int threadPriority;
    private long waitInterval;

    private CollectionManager(ConcurrentHelper concurrentHelper, String threadsGroupName, int threadsNumber, int threadPriority, long waitInterval) {
        this.concurrentHelper = concurrentHelper;
        this.threadsGroupName = threadsGroupName;
        this.threadNumber = threadsNumber;
        this.threadPriority = threadPriority;
        this.waitInterval = waitInterval;
    }

    public static <T> CollectionManager<T> create(ConcurrentHelper concurrentHelper, String threadsGroupName, int threadsNumber, int threadPriority, long waitInterval) {
        return new CollectionManager<T>(concurrentHelper, threadsGroupName, threadsNumber, threadPriority, waitInterval);
    }

    public void start() {
        this.collectionWrapper = new ConcurrentHashMap<Collection<T>, CollectionWrapper<T>>();
        this.threadList = new CopyOnWriteArrayList<Cycler.Thread>();
        for (int i = 0; i < this.threadNumber; ++i) {
            Cycler.Thread thrWrp = new Cycler.Thread(this.threadList, new Cycler.Runnable(){

                @Override
                public void run() {
                    if (!CollectionManager.this.collectionWrapper.isEmpty()) {
                        CollectionManager.this.collectionWrapper.forEach((cL, cLW) -> {
                            if (cLW.isUseless()) {
                                cL.clear();
                                CollectionManager.this.collectionWrapper.remove(cL);
                                StaticComponentContainer.ManagedLoggersRepository.logDebug(this.getClass()::getName, "cleaned");
                            } else if (!CollectionManager.this.concurrentHelper.removeAllTerminated(cLW.getCollection())) {
                                CollectionManager.this.concurrentHelper.waitFor(CollectionManager.this.waitInterval);
                            }
                        });
                    } else {
                        CollectionManager.this.concurrentHelper.waitFor(CollectionManager.this.waitInterval);
                    }
                }
            }, this.getThreadNewName(i), this.threadPriority);
            thrWrp.start();
        }
    }

    private String getThreadNewName() {
        return this.getThreadNewName(this.threadList.size() + 1);
    }

    private String getThreadNewName(int idx) {
        return this.threadsGroupName + "[" + idx + "]";
    }

    public void add(Collection<T> coll) {
        Optional.ofNullable(this.collectionWrapper).ifPresent(collectionWrapper -> {
            if (!collectionWrapper.containsKey(coll)) {
                CollectionManager collectionManager = this;
                synchronized (collectionManager) {
                    if (!collectionWrapper.containsKey(coll)) {
                        collectionWrapper.put(coll, new CollectionWrapper(coll));
                    }
                }
            }
        });
    }

    public CollectionWrapper<T> get(Collection<CompletableFuture<?>> coll) {
        return this.collectionWrapper.get(coll);
    }

    public void markAsUseless(final Collection<CompletableFuture<?>> coll) {
        Optional.ofNullable(this.threadList).ifPresent(threadList -> {
            Cycler.Thread thread = new Cycler.Thread((Collection<Cycler.Thread>)threadList, new Cycler.Runnable(){

                @Override
                public void run() {
                    CollectionWrapper wRP = CollectionManager.this.get(coll);
                    if (wRP != null) {
                        wRP.setUseless(true);
                        this.thread.terminate();
                    } else if (CollectionManager.this.collectionWrapper.isEmpty()) {
                        this.thread.terminate();
                    } else {
                        CollectionManager.this.concurrentHelper.waitFor(CollectionManager.this.waitInterval);
                    }
                }
            }, this.getThreadNewName(), this.threadPriority);
            thread.start();
        });
    }

    public void stop() {
        try {
            this.finalize();
        }
        catch (Throwable exc) {
            StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, "Exception occurred", exc);
        }
    }

    protected void finalize() throws Throwable {
        Optional.ofNullable(this.collectionWrapper).ifPresent(collectionWrapper -> collectionWrapper.clear());
        Optional.ofNullable(this.threadList).ifPresent(threadList -> {
            threadList.forEach(thr -> {
                try {
                    thr.terminate();
                    thr.join();
                }
                catch (InterruptedException exc) {
                    StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, "Exception occurred", (Throwable)exc);
                }
            });
            threadList.clear();
        });
    }

    public static class Cycler {

        public static class Thread
        extends Cycler.Thread {
            private Collection<Thread> threadCollection;

            public Thread(Collection<Thread> threadCollection, Cycler.Runnable function, String name, int priority) {
                super(function, name, priority);
                this.threadCollection = threadCollection;
            }

            @Override
            public void run() {
                this.threadCollection.add(this);
                super.run();
                this.threadCollection.remove(this);
            }
        }
    }
}

