/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.graph;

import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.burningwave.core.Component;
import org.burningwave.core.Virtual;
import org.burningwave.core.assembler.ComponentSupplier;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ClassFactory;
import org.burningwave.core.classes.ClassSourceGenerator;
import org.burningwave.core.classes.FunctionSourceGenerator;
import org.burningwave.core.classes.LoadOrBuildAndDefineConfig;
import org.burningwave.core.classes.LoadOrBuildAndDefineConfigAbst;
import org.burningwave.core.classes.MemberCriteria;
import org.burningwave.core.classes.MethodCriteria;
import org.burningwave.core.classes.PojoSourceGenerator;
import org.burningwave.core.classes.TypeDeclarationSourceGenerator;
import org.burningwave.core.classes.UnitSourceGenerator;
import org.burningwave.core.extension.CommandWrapper;
import org.burningwave.graph.Config;
import org.burningwave.graph.Context;
import org.burningwave.graph.ControllableContext;
import org.burningwave.graph.Functions;

public class Factory
implements Component {
    ComponentSupplier componentSupplier;
    List<Functions> functionList;
    List<Context> contextList;

    private Factory(ComponentSupplier componentSupplier) {
        this.componentSupplier = componentSupplier;
        this.functionList = new CopyOnWriteArrayList<Functions>();
        this.contextList = new CopyOnWriteArrayList<Context>();
    }

    public static Factory create(ComponentSupplier componentSupplier) {
        return new Factory(componentSupplier);
    }

    public static Factory getOrCreateFrom(ComponentSupplier componentSupplier) {
        return (Factory)componentSupplier.getOrCreate(Factory.class, () -> new Factory(componentSupplier));
    }

    public static Factory getInstance() {
        return Factory.getOrCreateFrom(ComponentSupplier.getInstance());
    }

    List<ControllableContext.Directive> getAllDirectives() {
        ArrayList<ControllableContext.Directive> directives = new ArrayList<ControllableContext.Directive>();
        directives.addAll(Stream.of(ControllableContext.Directive.Functions.values()).collect(Collectors.toList()));
        directives.addAll(Stream.of(ControllableContext.Directive.Functions.ForCollection.values()).collect(Collectors.toList()));
        return directives;
    }

    Map<String, ControllableContext.Directive> getDirectives(Config.OnException[] onException) {
        LinkedHashMap<String, ControllableContext.Directive> directives = new LinkedHashMap<String, ControllableContext.Directive>();
        if (onException != null) {
            for (Config.OnException temp : onException) {
                for (ControllableContext.Directive directive : this.getAllDirectives()) {
                    if (!directive.getName().equals(temp.getDirective())) continue;
                    for (String target : temp.getTargets()) {
                        directives.put(target, directive);
                    }
                }
            }
        }
        return directives;
    }

    Object retrieveBean(Object beanContainer, String beanClassNameOrContextName) throws ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object instance = null;
        if (beanContainer instanceof Map) {
            beanClassNameOrContextName = beanClassNameOrContextName.split("#")[1];
            instance = ((Map)beanContainer).get(beanClassNameOrContextName);
        } else if (Class.forName("org.springframework.context.ApplicationContext").isInstance(beanContainer)) {
            Class<?> targetClass = beanContainer != null ? (beanContainer instanceof Class ? (Class<?>)beanContainer : beanContainer.getClass()) : null;
            instance = ((Method)StaticComponentContainer.Members.findOne((MemberCriteria)((MethodCriteria)((MethodCriteria)((MethodCriteria)((MethodCriteria)((MethodCriteria)MethodCriteria.forEntireClassHierarchy().name(methodName -> methodName.matches("getBean"))).and()).returnType(returnType -> returnType == Object.class).and()).parameterTypes(parameterTypes -> ((Class[])parameterTypes).length == 1)).and()).parameterType((parameterTypes, idx) -> idx == 0 && parameterTypes[idx] == String.class), targetClass)).invoke(beanContainer, beanClassNameOrContextName.split("#")[1]);
        }
        return instance;
    }

    Function<Config, Functions> createAsyncFunctionsForCollection() {
        return config -> Functions.ForCollection.Async.create(StaticComponentContainer.ByFieldOrByMethodPropertyAccessor, StaticComponentContainer.ByMethodOrByFieldPropertyAccessor, StaticComponentContainer.IterableObjectHelper, config.getIterableObject(), config.getLoopResult(), config.getThreadsNumberAsInteger());
    }

    Function<Config, Functions> createAsyncFunctionsForCollectionWithSystemManagedThreads() {
        return config -> Functions.ForCollection.Async.create(StaticComponentContainer.ByFieldOrByMethodPropertyAccessor, StaticComponentContainer.ByMethodOrByFieldPropertyAccessor, StaticComponentContainer.IterableObjectHelper, config.getIterableObject(), config.getLoopResult());
    }

    Function<Config, Functions> createFunctionsForCollection() {
        return config -> Functions.ForCollection.create(StaticComponentContainer.ByFieldOrByMethodPropertyAccessor, StaticComponentContainer.ByMethodOrByFieldPropertyAccessor, StaticComponentContainer.IterableObjectHelper, config.getIterableObject(), config.getLoopResult());
    }

    Function<Config, Functions> createAsyncFunctions() {
        return config -> Functions.Async.create(StaticComponentContainer.ByFieldOrByMethodPropertyAccessor, StaticComponentContainer.ByMethodOrByFieldPropertyAccessor, StaticComponentContainer.IterableObjectHelper, config.getThreadsNumberAsInteger());
    }

    Supplier<Functions> createAsyncFunctionsWithSystemManagedThreads() {
        return () -> Functions.Async.create(StaticComponentContainer.ByFieldOrByMethodPropertyAccessor, StaticComponentContainer.ByMethodOrByFieldPropertyAccessor, StaticComponentContainer.IterableObjectHelper);
    }

    Supplier<Functions> createFunctions() {
        return () -> Functions.create(StaticComponentContainer.ByFieldOrByMethodPropertyAccessor, StaticComponentContainer.ByMethodOrByFieldPropertyAccessor, StaticComponentContainer.IterableObjectHelper);
    }

    public Context createContext() {
        Context context = Context.Simple.create();
        this.contextList.add(context);
        return context;
    }

    public <T> T createContext(Class<?> ... interfaces) {
        ClassFactory classFactory = this.componentSupplier.getClassFactory();
        String className = Factory.class.getPackage().getName() + "." + Virtual.class.getSimpleName().toLowerCase() + "." + String.join((CharSequence)"", (CharSequence[])Stream.of(interfaces).map(interf -> interf.getSimpleName()).toArray(String[]::new)) + "Impl";
        ArrayList classes = new ArrayList(Arrays.asList(interfaces));
        classes.add(Context.Simple.class);
        Class cls = classFactory.loadOrBuildAndDefine((LoadOrBuildAndDefineConfigAbst)((LoadOrBuildAndDefineConfig)LoadOrBuildAndDefineConfig.forUnitSourceGenerator((UnitSourceGenerator[])new UnitSourceGenerator[]{UnitSourceGenerator.create((String)StaticComponentContainer.Classes.retrievePackageName(className)).addClass(new ClassSourceGenerator[]{PojoSourceGenerator.create().setSetterMethodsBodyBuilder((pSG, clSG, methodSG, method, options) -> {
            String paramName = StaticComponentContainer.Strings.lowerCaseFirstCharacter(method.getName().replaceFirst("set", ""));
            methodSG.addBodyCodeLine(new String[]{"put(\"" + paramName + "\", " + paramName + ");"});
        }).setGetterMethodsBodyBuilder((pSG, clSG, methodSG, method, options) -> {
            String prefix = method.getName().startsWith("get") ? "get" : "is";
            String paramName = StaticComponentContainer.Strings.lowerCaseFirstCharacter(method.getName().replaceFirst(prefix, ""));
            methodSG.addBodyCodeLine(new String[]{"return (" + (pSG.isUseFullyQualifiedClassNamesEnabled(options.intValue()) ? method.getReturnType().getName() : method.getReturnType().getSimpleName()) + ")get(\"" + paramName + "\");"});
        }).setExtraElementsBuilder((pSG, clSG, superClass, interfs, options) -> {
            FunctionSourceGenerator createSimmetricCloneMethod = FunctionSourceGenerator.create((String)"createSymmetricClone").addModifier(Integer.valueOf(1)).setReturnType(TypeDeclarationSourceGenerator.create((String)Context.class.getName())).addBodyCodeLine(new String[]{StaticComponentContainer.Classes.retrieveSimpleName(className)}).addBodyCode(new String[]{"data = new"}).addBodyCode(new String[]{StaticComponentContainer.Classes.retrieveSimpleName(className)}).addBodyCode(new String[]{"(container, executionDirectiveForGroupName, mutexManager);"}).addBodyCodeLine(new String[]{"data.parent = this;"}).addBodyCodeLine(new String[]{"return data;"}).addOuterCodeLine(new String[]{"@Override"});
            clSG.addMethod(new FunctionSourceGenerator[]{createSimmetricCloneMethod});
        }).setFieldsBuilder(null).generate(className, PojoSourceGenerator.BUILDING_METHODS_CREATION_ENABLED | PojoSourceGenerator.USE_OF_FULLY_QUALIFIED_CLASS_NAMES_ENABLED, classes.toArray(new Class[classes.size()]))})}).useClassLoader(this.getClass().getClassLoader()))).get(className);
        try {
            return (T)((Method)StaticComponentContainer.Members.findOne((MemberCriteria)((MethodCriteria)((MethodCriteria)MethodCriteria.withoutConsideringParentClasses().name("create"::equals)).and()).parameterTypes(paramsType -> ((Class[])paramsType).length == 0), cls)).invoke(null, new Object[0]);
        }
        catch (Exception exc) {
            return (T)StaticComponentContainer.Driver.throwException((Object)exc, new Object[0]);
        }
    }

    public Functions build(Config config, Object ... beanContainers) throws Throwable {
        Functions functions = this.buildFunctions(config, beanContainers);
        this.functionList.add(functions);
        return functions;
    }

    private Functions buildFunctions(Config config, Object ... beanContainers) throws Throwable {
        Functions functions = this.createMainFunctions(config);
        this.createChildren(config, functions, beanContainers);
        return functions;
    }

    private void createChildren(Config config, Functions functions, Object ... beanContainers) throws Throwable {
        if (config.getFunctions() != null && config.getFunctions().length > 0) {
            for (Config innerConfig : config.getFunctions()) {
                Object instance = null;
                AtomicReference<Class<Object>> superClassWrapper = new AtomicReference<Class<Object>>(Object.class);
                AtomicReference<String> methodNameWrapper = new AtomicReference<String>();
                if (StaticComponentContainer.Strings.isNotEmpty(innerConfig.getMethod())) {
                    String beanClassNameOrContextName = innerConfig.getMethod().split("::")[0];
                    methodNameWrapper.set(innerConfig.getMethod().split("::")[1]);
                    if ("new".equalsIgnoreCase(beanClassNameOrContextName.split("\\s+")[0])) {
                        beanClassNameOrContextName = beanClassNameOrContextName.split("\\s+")[1];
                        instance = Class.forName(beanClassNameOrContextName).getConstructor(new Class[0]).newInstance(new Object[0]);
                    } else if (beanClassNameOrContextName.startsWith("#")) {
                        Object beanContainer;
                        Object[] objectArray = beanContainers;
                        int n = objectArray.length;
                        for (int i = 0; i < n && (instance = this.retrieveBean(beanContainer = objectArray[i], beanClassNameOrContextName)) == null; ++i) {
                        }
                    } else {
                        instance = Class.forName(beanClassNameOrContextName);
                    }
                } else if (StaticComponentContainer.Strings.isEmpty(innerConfig.getMethod())) {
                    instance = this.buildFunctions(innerConfig, beanContainers);
                    superClassWrapper.set(instance.getClass());
                    methodNameWrapper.set(StaticComponentContainer.Strings.isNotEmpty(innerConfig.getMethod()) ? innerConfig.getMethod() : "executeOn");
                }
                Objects.requireNonNull(instance, "Object " + innerConfig.getMethod() + " not found");
                String methodName = (String)methodNameWrapper.get();
                Class<?> targetClass = instance != null ? (instance instanceof Class ? (Class<?>)instance : instance.getClass()) : null;
                Method mth = Optional.ofNullable((Method)StaticComponentContainer.Members.findOne((MemberCriteria)((MethodCriteria)((MethodCriteria)((MethodCriteria)MethodCriteria.byScanUpTo(c -> c.getName().equals(((Class)superClassWrapper.get()).getName())).and()).name(methodName::equals)).and()).parameterTypes(parameterTypes -> ((Class[])parameterTypes).length == 1), targetClass)).orElse((Method)StaticComponentContainer.Members.findOne((MemberCriteria)((MethodCriteria)((MethodCriteria)((MethodCriteria)MethodCriteria.byScanUpTo(c -> c.getName().equals(((Class)superClassWrapper.get()).getName())).and()).name(methodName::equals)).and()).parameterTypes(parameterTypes -> ((Class[])parameterTypes).length == 0), targetClass));
                Object functionalInterface = this.componentSupplier.getFunctionalInterfaceFactory().getOrCreate((Executable)Objects.requireNonNull(mth, "Could not bind function " + instance.getClass().getName() + "::" + mth.getName() + " to any Wrapper"));
                functions.add(CommandWrapper.create(functionalInterface, instance));
            }
        }
    }

    private Functions createMainFunctions(Config config) {
        Functions functions = null;
        functions = config.isAsync() && StaticComponentContainer.Strings.isNotEmpty(config.getIterableObject()) ? Optional.ofNullable(config.getThreadsNumberAsInteger()).map(threadsNumber -> this.createAsyncFunctionsForCollection().apply(config)).orElseGet(() -> this.createAsyncFunctionsForCollectionWithSystemManagedThreads().apply(config)) : (StaticComponentContainer.Strings.isNotEmpty(config.getIterableObject()) ? this.createFunctionsForCollection().apply(config) : (config.isAsync() ? Optional.ofNullable(config.getThreadsNumberAsInteger()).map(threadsNumber -> this.createAsyncFunctions().apply(config)).orElseGet(() -> this.createAsyncFunctionsWithSystemManagedThreads().get()) : this.createFunctions().get()));
        functions.setName(config.getName());
        functions.setOnException(this.getDirectives(config.getOnException()));
        return functions;
    }

    public void close(Functions ... functions) {
        for (Functions function : functions) {
            function.close();
            this.functionList.remove(function);
        }
    }

    public void close(Object ... contextes) {
        for (Object context : contextes) {
            ((Context)context).close();
            this.contextList.remove(context);
        }
    }

    public void close() {
        if (this.functionList != null) {
            for (Functions function : this.functionList) {
                this.close(function);
            }
            this.functionList.clear();
            this.functionList = null;
        }
        if (this.contextList != null) {
            for (Context context : this.contextList) {
                this.close(context);
            }
            this.contextList.clear();
            this.contextList = null;
        }
    }
}

