/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.extension;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.function.Predicate;
import org.burningwave.core.extension.Item;

public class Group<T>
extends Item {
    protected Collection<T> elements = new LinkedHashSet<T>();

    public Group<T> add(T element) {
        this.elements.add(element);
        if (element instanceof Item) {
            ((Item)element).setParent(this);
        }
        return this;
    }

    public <I extends Item> I get(String name) {
        return (I)this.get((I item) -> item instanceof Item && item.getName().matches(name));
    }

    public <I> I get(Predicate<I> predicate) {
        return this.elements.stream().filter(item -> predicate.test(item)).findFirst().orElse(null);
    }

    @Override
    public void close() {
        if (this.elements != null) {
            this.elements.clear();
            this.elements = null;
        }
        super.close();
    }
}

