/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.extension.concurrent;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import org.burningwave.core.Component;
import org.burningwave.core.assembler.StaticComponentContainer;

public class ConcurrentHelper
implements Component {
    private ConcurrentHelper() {
    }

    public static ConcurrentHelper create() {
        return new ConcurrentHelper();
    }

    protected void joinAll(CompletableFuture<?> ... completableFutures) {
        for (CompletableFuture<?> completableFuture : completableFutures) {
            if (completableFuture == null) continue;
            completableFuture.join();
        }
    }

    public boolean removeAllTerminated(Collection<CompletableFuture<?>> completableFutureList) {
        Iterator<CompletableFuture<?>> itr = completableFutureList.iterator();
        boolean removed = false;
        while (itr.hasNext()) {
            CompletableFuture<?> cF = itr.next();
            if (!cF.isDone() && !cF.isCancelled() && !cF.isCompletedExceptionally()) continue;
            completableFutureList.remove(cF);
            removed = true;
        }
        return removed;
    }

    public void waitFor(long interval) {
        try {
            Thread.sleep(interval);
        }
        catch (InterruptedException exc) {
            StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, "Exception occurred", (Throwable)exc);
        }
    }
}

