/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.extension.concurrent;

import java.util.concurrent.atomic.AtomicBoolean;
import org.burningwave.core.Component;

public class Cycler
implements Component {

    public static class Thread
    extends java.lang.Thread {
        protected final AtomicBoolean continueLoop = new AtomicBoolean();
        protected Runnable function;

        public Thread(Runnable function, String name, int priority) {
            this.function = function;
            function.setThread(this);
            this.setName(name);
            this.setPriority(priority);
        }

        public void terminate() {
            this.continueLoop.set(false);
        }

        @Override
        public synchronized void start() {
            this.continueLoop.set(true);
            super.start();
        }

        @Override
        public void run() {
            while (this.continueLoop.get()) {
                this.function.run();
            }
        }
    }

    public static abstract class Runnable
    implements java.lang.Runnable,
    Component {
        Thread thread;

        void setThread(Thread thread) {
            this.thread = thread;
        }

        public Thread getThread() {
            return this.thread;
        }
    }
}

