/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.extension.concurrent;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.burningwave.core.Component;

public class Mutex<K, V>
implements Component {
    private K key;
    private Predicate<V> predicate;

    private Mutex(K key, Predicate<V> predicate) {
        this.key = key;
        this.predicate = predicate;
    }

    static <K, V> Mutex<K, V> create(K key, Predicate<V> predicate) {
        return new Mutex<K, V>(key, predicate);
    }

    public K getKey() {
        return this.key;
    }

    public Predicate<V> getPredicate() {
        return this.predicate;
    }

    public void close() {
        this.key = null;
        this.predicate = null;
    }

    public static abstract class Manager
    implements Component {

        public static class ForMap<O, K, V>
        extends Manager {
            private Map<O, Set<Mutex<K, V>>> mutexes = new LinkedHashMap<O, Set<Mutex<K, V>>>();
            private Function<K, V> valueRetriever;

            private ForMap(Function<K, V> valueRetriever) {
                this.valueRetriever = valueRetriever;
            }

            public static <O, K, V> ForMap<O, K, V> create(Function<K, V> valueRetriever) {
                return new ForMap<O, K, V>(valueRetriever);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public V waitFor(O operation, K key, Predicate<V> predicate, int ... timeout) throws InterruptedException {
                Mutex<K, V> mutex;
                V toRet = this.valueRetriever.apply(key);
                if (predicate.test(toRet)) {
                    return toRet;
                }
                Mutex<K, V> mutex2 = mutex = this.addMutexFor(operation, key, predicate);
                synchronized (mutex2) {
                    toRet = this.valueRetriever.apply(key);
                    if (predicate.test(toRet)) {
                        return toRet;
                    }
                    if (timeout != null && timeout.length > 0) {
                        mutex.wait(timeout[0]);
                    } else {
                        mutex.wait();
                    }
                    return this.valueRetriever.apply(key);
                }
            }

            public Mutex<K, V> addMutexFor(O operation, K key, Predicate<V> predicate) {
                Set mutexes = this.getMutexes(operation);
                return mutexes.stream().filter(mutex -> mutex.getKey().equals(key) && mutex.getPredicate() == predicate).findFirst().orElseGet(() -> {
                    Mutex mutex = Mutex.create(key, predicate);
                    mutexes.add(mutex);
                    return mutex;
                });
            }

            public Set<Mutex<K, V>> getMutexes(O operation) {
                return Optional.ofNullable(this.mutexes.get(operation)).orElseGet(() -> {
                    ConcurrentHashMap.KeySetView mutexes = ConcurrentHashMap.newKeySet();
                    this.mutexes.put(operation, mutexes);
                    return mutexes;
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void unlockMutexes(O operation, K key, V value) {
                Set<Mutex<K, V>> mutexesForPut = this.getMutexes(operation);
                if (!mutexesForPut.isEmpty()) {
                    for (Mutex<K, V> mutex : mutexesForPut) {
                        if (!mutex.getKey().equals(key) || !mutex.getPredicate().test(value)) continue;
                        Mutex<K, V> mutex2 = mutex;
                        synchronized (mutex2) {
                            mutex.notifyAll();
                            break;
                        }
                    }
                }
            }

            void removeMutexFor(O operation, Mutex<K, V> mutex) throws Exception {
                this.removeMutex(this.getMutexes(operation), mutex);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void removeMutex(Set<Mutex<K, V>> mutexSet, Mutex<K, V> mutex) {
                Mutex<K, V> mutex2 = mutex;
                synchronized (mutex2) {
                    mutex.notifyAll();
                    mutexSet.remove(mutex);
                    mutex.close();
                }
            }

            public void clearMutexes() {
                for (O key : this.mutexes.keySet()) {
                    Set<Mutex<K, V>> mutexSet = this.mutexes.get(key);
                    for (Mutex<K, V> mutex : mutexSet) {
                        this.removeMutex(mutexSet, mutex);
                    }
                }
            }

            public void close() {
                if (this.mutexes != null) {
                    this.clearMutexes();
                    this.mutexes = null;
                }
                this.valueRetriever = null;
            }
        }
    }
}

