/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.extension.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.burningwave.core.Component;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.function.ThrowingRunnable;

public class ParallelTasksManager
implements Component {
    protected Collection<CompletableFuture<Void>> tasks = new CopyOnWriteArrayList<CompletableFuture<Void>>();
    protected ExecutorService executorService;
    private int maxParallelTasks;

    private ParallelTasksManager(int maxParallelTasks) {
        this.maxParallelTasks = maxParallelTasks;
    }

    public static ParallelTasksManager create(int maxParallelTasks) {
        return new ParallelTasksManager(maxParallelTasks);
    }

    public static ParallelTasksManager create() {
        return new ParallelTasksManager(Runtime.getRuntime().availableProcessors());
    }

    public void execute(ThrowingRunnable<Throwable> task) {
        if (this.executorService == null) {
            this.executorService = Executors.newFixedThreadPool(this.maxParallelTasks);
        }
        this.tasks.add(CompletableFuture.runAsync(() -> {
            try {
                task.run();
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, "Exception occurred", exc);
            }
        }, this.executorService));
    }

    public void waitForTasksEnding() {
        Iterator<CompletableFuture<Void>> iterator = this.tasks.iterator();
        ArrayList<CompletableFuture<Void>> tasks = new ArrayList<CompletableFuture<Void>>();
        while (iterator.hasNext()) {
            CompletableFuture<Void> task = iterator.next();
            task.join();
            tasks.add(task);
        }
        tasks.removeAll(tasks);
    }

    public void close() {
        this.waitForTasksEnding();
        this.tasks.clear();
        this.tasks = null;
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
    }
}

