/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.extension.function;

import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.function.Executor;
import org.burningwave.core.function.ThrowingConsumer;
import org.burningwave.core.function.ThrowingRunnable;
import org.burningwave.core.function.ThrowingSupplier;

public interface TimeCountExecutor {
    public static <E extends Throwable> void runAndLogExceptions(ThrowingRunnable<? extends Throwable> runnable) {
        long initialTime = System.currentTimeMillis();
        Executor.runAndLogExceptions(runnable);
        StaticComponentContainer.ManagedLoggerRepository.logInfo(TimeCountExecutor.class::getName, "{} - Elapsed time: {}", new Object[]{runnable, TimeCountExecutor.getFormattedDifferenceOfMillis(System.currentTimeMillis(), initialTime)});
    }

    public static <E extends Throwable> void runAndIgnoreExceptions(ThrowingRunnable<? extends Throwable> runnable) {
        long initialTime = System.currentTimeMillis();
        Executor.runAndIgnoreExceptions(runnable);
        StaticComponentContainer.ManagedLoggerRepository.logInfo(TimeCountExecutor.class::getName, "{} - Elapsed time: {}", new Object[]{runnable, TimeCountExecutor.getFormattedDifferenceOfMillis(System.currentTimeMillis(), initialTime)});
    }

    public static <E extends Throwable> void run(ThrowingRunnable<E> runnable) {
        long initialTime = System.currentTimeMillis();
        try {
            Executor.run(runnable);
        }
        catch (Throwable throwable) {
            StaticComponentContainer.ManagedLoggerRepository.logInfo(TimeCountExecutor.class::getName, "{} - Elapsed time: {}", new Object[]{runnable, TimeCountExecutor.getFormattedDifferenceOfMillis(System.currentTimeMillis(), initialTime)});
            throw throwable;
        }
        StaticComponentContainer.ManagedLoggerRepository.logInfo(TimeCountExecutor.class::getName, "{} - Elapsed time: {}", new Object[]{runnable, TimeCountExecutor.getFormattedDifferenceOfMillis(System.currentTimeMillis(), initialTime)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Throwable> void run(ThrowingRunnable<E> runnable, int attemptsNumber) {
        long initialTime = System.currentTimeMillis();
        try {
            Executor.run(runnable, (int)attemptsNumber);
        }
        catch (Throwable throwable) {
            StaticComponentContainer.ManagedLoggerRepository.logInfo(TimeCountExecutor.class::getName, "{} - Elapsed time: {}", new Object[]{runnable, TimeCountExecutor.getFormattedDifferenceOfMillis(System.currentTimeMillis(), initialTime)});
            throw throwable;
        }
        StaticComponentContainer.ManagedLoggerRepository.logInfo(TimeCountExecutor.class::getName, "{} - Elapsed time: {}", new Object[]{runnable, TimeCountExecutor.getFormattedDifferenceOfMillis(System.currentTimeMillis(), initialTime)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I, E extends Throwable> void accept(ThrowingConsumer<I, E> consumer, I input) {
        long initialTime = System.currentTimeMillis();
        try {
            Executor.accept(consumer, input);
        }
        catch (Throwable throwable) {
            StaticComponentContainer.ManagedLoggerRepository.logInfo(TimeCountExecutor.class::getName, "{} - Elapsed time: {}", new Object[]{consumer, TimeCountExecutor.getFormattedDifferenceOfMillis(System.currentTimeMillis(), initialTime)});
            throw throwable;
        }
        StaticComponentContainer.ManagedLoggerRepository.logInfo(TimeCountExecutor.class::getName, "{} - Elapsed time: {}", new Object[]{consumer, TimeCountExecutor.getFormattedDifferenceOfMillis(System.currentTimeMillis(), initialTime)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T get(ThrowingSupplier<T, ? extends E> supplier) {
        Object object;
        long initialTime = System.currentTimeMillis();
        try {
            object = Executor.get(supplier);
        }
        catch (Throwable throwable) {
            StaticComponentContainer.ManagedLoggerRepository.logInfo(TimeCountExecutor.class::getName, "{} - Elapsed time: {}", new Object[]{supplier, TimeCountExecutor.getFormattedDifferenceOfMillis(System.currentTimeMillis(), initialTime)});
            throw throwable;
        }
        StaticComponentContainer.ManagedLoggerRepository.logInfo(TimeCountExecutor.class::getName, "{} - Elapsed time: {}", new Object[]{supplier, TimeCountExecutor.getFormattedDifferenceOfMillis(System.currentTimeMillis(), initialTime)});
        return (T)object;
    }

    public static <T, E extends Throwable> T get(ThrowingSupplier<T, ? extends E> supplier, int attemptsNumber) {
        while (true) {
            try {
                return (T)supplier.get();
            }
            catch (Throwable exc) {
                if (attemptsNumber > 1) {
                    StaticComponentContainer.Driver.throwException(exc);
                }
                --attemptsNumber;
                continue;
            }
            break;
        }
    }

    public static String getFormattedDifferenceOfMillis(long value1, long value2) {
        String valueFormatted = String.format("%04d", value1 - value2);
        return valueFormatted.substring(0, valueFormatted.length() - 3) + "," + valueFormatted.substring(valueFormatted.length() - 3);
    }
}

