/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.graph;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.burningwave.core.Component;
import org.burningwave.core.concurrent.Mutex;
import org.burningwave.graph.Clearable;
import org.burningwave.graph.ControllableContext;
import org.burningwave.graph.IterableObjectSupport;
import org.burningwave.graph.ListenableContext;

public interface Context
extends Component,
IterableObjectSupport,
ControllableContext,
ListenableContext,
Clearable,
Serializable {
    public <T> T get(Object var1);

    public Context removeAll(Object ... var1);

    public <K, V> Context put(K var1, V var2);

    public Context putAll(Map<?, ?> var1);

    public Context putAll(Context var1);

    public void close();

    public Context createSymmetricClone();

    public static class Simple
    extends Abst {
        private static final long serialVersionUID = -7459443347382714306L;
        protected Context parent;

        protected Simple(Map<Object, Object> container, Map<String, ControllableContext.Directive> executionDirectiveForGroupName, Mutex.Manager.ForMap<Operation, Object, Object> mutexManager) {
            super(container, executionDirectiveForGroupName, mutexManager);
        }

        protected Simple() {
        }

        public static Context create() {
            return new Simple();
        }

        @Override
        public <K, V> Context put(K key, V value) {
            this.container.put(key, value);
            return this;
        }

        @Override
        public Context removeAll(Object ... keys) {
            if (keys != null && keys.length > 0) {
                for (Object key : keys) {
                    this.container.remove(key);
                }
            } else {
                this.clearContainer();
            }
            return this;
        }

        @Override
        public Context putAll(Map<?, ?> inputContainer) {
            if (this.container != inputContainer) {
                inputContainer.forEach((key, value) -> this.put(key, value));
            }
            return this;
        }

        @Override
        public Context putDirective(String groupName, ControllableContext.Directive directive) {
            this.executionDirectiveForGroupName.put(groupName, directive);
            return this;
        }

        @Override
        public Context removeDirective(String groupName, ControllableContext.Directive directive) {
            this.executionDirectiveForGroupName.remove(groupName, directive);
            return this;
        }

        @Override
        public Context putAll(Context input) {
            this.putAll(this.cast((Context)input).container);
            this.putAllDirectives(this.cast((Context)input).executionDirectiveForGroupName);
            return this;
        }

        @Override
        public Context createSymmetricClone() {
            Simple context = new Simple(this.container, this.executionDirectiveForGroupName, (Mutex.Manager.ForMap<Operation, Object, Object>)this.mutexManager);
            context.parent = this;
            return context;
        }

        @Override
        Context putAllDirectives(Map<String, ControllableContext.Directive> directives) {
            if (this.executionDirectiveForGroupName != directives) {
                this.executionDirectiveForGroupName.putAll(directives);
            }
            return this;
        }

        @Override
        public void close() {
            if (this.parent == null) {
                super.close();
            }
        }

        @Override
        public <V> V waitForPut(Object key, Predicate<V> predicate, int ... timeout) throws InterruptedException {
            return (V)this.mutexManager.waitFor((Object)Operation.PUT, key, predicate, new int[0]);
        }

        @Override
        public <V> V waitForRemove(Object key, Predicate<V> predicate, int ... timeout) throws InterruptedException {
            return (V)this.mutexManager.waitFor((Object)Operation.REMOVE, key, predicate, new int[0]);
        }
    }

    public static abstract class Abst
    implements Context {
        private static final long serialVersionUID = 8260204603417876527L;
        protected Map<Object, Object> container;
        protected Map<String, ControllableContext.Directive> executionDirectiveForGroupName;
        protected IterationContext<Object> iterationContext;
        protected Mutex.Manager.ForMap<Operation, Object, Object> mutexManager;

        Abst() {
            this.container = new ConcurrentHashMap<Object, Object>(){
                private static final long serialVersionUID = -4473137080512706444L;

                @Override
                public Object put(Object key, Object value) {
                    Object val = null;
                    val = value != null ? super.put(key, value) : Boolean.valueOf(super.remove(key, value));
                    mutexManager.unlockMutexes((Object)Operation.PUT, key, value);
                    return val;
                }

                @Override
                public Object remove(Object key) {
                    Object value = super.remove(key);
                    mutexManager.unlockMutexes((Object)Operation.REMOVE, key, value);
                    return value;
                }
            };
            this.executionDirectiveForGroupName = new ConcurrentHashMap<String, ControllableContext.Directive>();
            this.mutexManager = Mutex.Manager.ForMap.create(this::get);
        }

        public Abst(Map<Object, Object> container, Map<String, ControllableContext.Directive> executionDirectiveForGroupName, Mutex.Manager.ForMap<Operation, Object, Object> mutexManager) {
            this.container = container;
            this.executionDirectiveForGroupName = executionDirectiveForGroupName;
            this.mutexManager = mutexManager;
        }

        abstract Context putAllDirectives(Map<String, ControllableContext.Directive> var1);

        @Override
        public <T> T get(Object key) {
            try {
                return (T)this.container.get(key);
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
        }

        <T> IterationContext<T> removeIterationContext() {
            IterationContext<Object> itrCnt = this.iterationContext;
            this.setCurrentIterationContext(null);
            return itrCnt;
        }

        void setCurrentIterationContext(IterationContext<?> itrCnt) {
            this.iterationContext = itrCnt;
        }

        <T> IterationContext<T> getCurrentIteratedContainer() {
            return this.iterationContext;
        }

        @Override
        public boolean containsOneOf(String name, ControllableContext.Directive ... directives) {
            return Stream.of(directives).filter(directive -> this.executionDirectiveForGroupName.get(name) == directive).findFirst().isPresent();
        }

        void setCurrentIterationObjects(Object iterableObject, Object[] loopResult, Object currentIterationObject, Integer index, Object key) {
            Optional.of(Optional.ofNullable(this.iterationContext).orElseGet(() -> {
                this.iterationContext = IterationContext.create(iterableObject, loopResult, currentIterationObject, index, key);
                return this.iterationContext;
            })).ifPresent(itrCnt -> {
                itrCnt.setIterableObject(iterableObject);
                itrCnt.setLoopResult(loopResult);
                itrCnt.setCurrentIteratedObject(currentIterationObject);
                itrCnt.setIndex(index);
                itrCnt.setKey(key);
            });
        }

        @Override
        public Integer getCurrentIterationIndex() {
            return Optional.ofNullable(this.iterationContext).map(iterationContext -> iterationContext.getIndex()).orElse(null);
        }

        @Override
        public <T> T getCurrentIteratedObject() {
            return Optional.ofNullable(this.iterationContext).map(iterationContext -> iterationContext.getCurrentIteratedObject()).orElse(null);
        }

        @Override
        public void setCurrentIterationResult(Object obj) {
            Objects.requireNonNull(Objects.requireNonNull(this.iterationContext, "setCurrentIterationResult calling failed cause " + this.getClass() + " not contains currentIterationContext"), "setCurrentIterationResult calling failed cause " + this.getClass() + " not contains currentIterationContext.loopResult").setCurrentIterationResult(obj);
        }

        @Override
        public <T> T getCurrentIterationResult() {
            return Optional.ofNullable(this.iterationContext).map(iterationContext -> iterationContext.getCurrentIterationResult()).orElse(null);
        }

        Abst cast(Context context) {
            return (Abst)context;
        }

        @Override
        public void clear() {
            this.clearContainer();
            this.mutexManager.clearMutexes();
            this.executionDirectiveForGroupName.clear();
            this.iterationContext = null;
        }

        <K, V> void clearContainer() {
            this.container.forEach((key, value) -> this.mutexManager.unlockMutexes((Object)Operation.REMOVE, key, this.container.remove(key)));
        }

        @Override
        public void close() {
            this.clear();
            this.container = null;
            this.executionDirectiveForGroupName = null;
            this.mutexManager.close();
            this.mutexManager = null;
        }
    }

    public static class IterationContext<T>
    implements Serializable {
        private static final long serialVersionUID = 9013466754089134552L;
        private T iterableObject;
        private Object[] loopResult;
        private Object currentIteratedObject;
        private Integer index;
        private Object currentIteratedObjectKey;

        private IterationContext(T iterableObject, Object[] loopResult, Object input, Integer index, Object key) {
            this.iterableObject = iterableObject;
            this.currentIteratedObject = input;
            this.index = index;
            this.loopResult = loopResult;
            this.currentIteratedObjectKey = key;
        }

        static <T> IterationContext<T> create(T iterableObject, Object[] loopResult, Object input, Integer index, Object key) {
            return new IterationContext<T>(iterableObject, loopResult, input, index, key);
        }

        Object getCurrentIteratedObject() {
            return this.currentIteratedObject;
        }

        void setCurrentIteratedObject(Object input) {
            this.currentIteratedObject = input;
        }

        Object getCurrentIterationResult() {
            return this.loopResult[this.index];
        }

        void setCurrentIterationResult(Object output) {
            this.loopResult[this.index.intValue()] = output;
        }

        T getIterableObject() {
            return this.iterableObject;
        }

        void setIterableObject(T iterableObject) {
            this.iterableObject = iterableObject;
        }

        Object[] getLoopResult() {
            return this.loopResult;
        }

        void setLoopResult(Object[] loopResult) {
            this.loopResult = loopResult;
        }

        void setIndex(Integer index) {
            this.index = index;
        }

        Integer getIndex() {
            return this.index;
        }

        <K> K getKey() {
            return (K)this.currentIteratedObjectKey;
        }

        void setKey(Object key) {
            this.currentIteratedObjectKey = key;
        }
    }

    public static enum Operation {
        PUT,
        REMOVE;

    }
}

