/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.graph;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.burningwave.Throwables;
import org.burningwave.core.CommandWrapper;
import org.burningwave.core.Component;
import org.burningwave.core.Virtual;
import org.burningwave.core.assembler.ComponentSupplier;
import org.burningwave.core.classes.ClassFactory;
import org.burningwave.core.classes.MemberCriteria;
import org.burningwave.core.classes.MethodCriteria;
import org.burningwave.core.common.Strings;
import org.burningwave.graph.CodeGeneratorForContext;
import org.burningwave.graph.Config;
import org.burningwave.graph.Context;
import org.burningwave.graph.ControllableContext;
import org.burningwave.graph.Functions;

public class Factory
implements Component {
    ComponentSupplier componentSupplier;
    CodeGeneratorForContext codeGeneratorForContext;
    List<Functions> functionList;
    List<Context> contextList;

    private Factory(ComponentSupplier componentSupplier) {
        this.componentSupplier = componentSupplier;
        this.codeGeneratorForContext = (CodeGeneratorForContext)componentSupplier.getOrCreate(CodeGeneratorForContext.class, () -> CodeGeneratorForContext.create(componentSupplier.getMemberFinder(), componentSupplier.getStreamHelper()));
        this.functionList = new CopyOnWriteArrayList<Functions>();
        this.contextList = new CopyOnWriteArrayList<Context>();
    }

    public static Factory create(ComponentSupplier componentSupplier) {
        return new Factory(componentSupplier);
    }

    public static Factory getOrCreateFrom(ComponentSupplier componentSupplier) {
        return (Factory)componentSupplier.getOrCreate(Factory.class, () -> new Factory(componentSupplier));
    }

    public static Factory getInstance() {
        return Factory.getOrCreateFrom(ComponentSupplier.getInstance());
    }

    List<ControllableContext.Directive> getAllDirectives() {
        ArrayList<ControllableContext.Directive> directives = new ArrayList<ControllableContext.Directive>();
        directives.addAll(Stream.of(ControllableContext.Directive.Functions.values()).collect(Collectors.toList()));
        directives.addAll(Stream.of(ControllableContext.Directive.Functions.ForCollection.values()).collect(Collectors.toList()));
        return directives;
    }

    Map<String, ControllableContext.Directive> getDirectives(Config.OnException[] onException) {
        LinkedHashMap<String, ControllableContext.Directive> directives = new LinkedHashMap<String, ControllableContext.Directive>();
        if (onException != null) {
            for (Config.OnException temp : onException) {
                for (ControllableContext.Directive directive : this.getAllDirectives()) {
                    if (!directive.getName().equals(temp.getDirective())) continue;
                    for (String target : temp.getTargets()) {
                        directives.put(target, directive);
                    }
                }
            }
        }
        return directives;
    }

    Object retrieveBean(Object beanContainer, String beanClassNameOrContextName) throws ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object instance = null;
        if (beanContainer instanceof Map) {
            beanClassNameOrContextName = beanClassNameOrContextName.split("#")[1];
            instance = ((Map)beanContainer).get(beanClassNameOrContextName);
        } else if (Class.forName("org.springframework.context.ApplicationContext").isInstance(beanContainer)) {
            instance = ((Method)this.componentSupplier.getMemberFinder().findOne((MemberCriteria)((MethodCriteria)((MethodCriteria)((MethodCriteria)((MethodCriteria)MethodCriteria.forName(methodName -> methodName.matches("getBean")).and()).returnType(returnType -> returnType == Object.class).and()).parameterTypes(parameterTypes -> ((Class[])parameterTypes).length == 1)).and()).parameterType((parameterTypes, idx) -> idx == 0 && parameterTypes[idx] == String.class), beanContainer)).invoke(beanContainer, beanClassNameOrContextName.split("#")[1]);
        }
        return instance;
    }

    Function<Config, Functions> createAsyncFunctionsForCollection() {
        return config -> Functions.ForCollection.Async.create(this.componentSupplier.getByFieldOrByMethodPropertyAccessor(), this.componentSupplier.getByMethodOrByFieldPropertyAccessor(), this.componentSupplier.getIterableObjectHelper(), config.getIterableObject(), config.getLoopResult(), config.getThreadsNumberAsInteger());
    }

    Function<Config, Functions> createAsyncFunctionsForCollectionWithSystemManagedThreads() {
        return config -> Functions.ForCollection.Async.create(this.componentSupplier.getByFieldOrByMethodPropertyAccessor(), this.componentSupplier.getByMethodOrByFieldPropertyAccessor(), this.componentSupplier.getIterableObjectHelper(), config.getIterableObject(), config.getLoopResult());
    }

    Function<Config, Functions> createFunctionsForCollection() {
        return config -> Functions.ForCollection.create(this.componentSupplier.getByFieldOrByMethodPropertyAccessor(), this.componentSupplier.getByMethodOrByFieldPropertyAccessor(), this.componentSupplier.getIterableObjectHelper(), config.getIterableObject(), config.getLoopResult());
    }

    Function<Config, Functions> createAsyncFunctions() {
        return config -> Functions.Async.create(this.componentSupplier.getByFieldOrByMethodPropertyAccessor(), this.componentSupplier.getByMethodOrByFieldPropertyAccessor(), this.componentSupplier.getIterableObjectHelper(), config.getThreadsNumberAsInteger());
    }

    Supplier<Functions> createAsyncFunctionsWithSystemManagedThreads() {
        return () -> Functions.Async.create(this.componentSupplier.getByFieldOrByMethodPropertyAccessor(), this.componentSupplier.getByMethodOrByFieldPropertyAccessor(), this.componentSupplier.getIterableObjectHelper());
    }

    Supplier<Functions> createFunctions() {
        return () -> Functions.create(this.componentSupplier.getByFieldOrByMethodPropertyAccessor(), this.componentSupplier.getByMethodOrByFieldPropertyAccessor(), this.componentSupplier.getIterableObjectHelper());
    }

    public Context createContext() {
        Context context = Context.Simple.create();
        this.contextList.add(context);
        return context;
    }

    public <T> T createContext(Class<?> ... interfaces) {
        ClassFactory classFactory = this.componentSupplier.getClassFactory();
        String className = Factory.class.getPackage().getName() + "." + Virtual.class.getSimpleName().toLowerCase() + "." + String.join((CharSequence)"", (CharSequence[])Stream.of(interfaces).map(interf -> interf.getSimpleName()).toArray(String[]::new)) + "Impl";
        Class cls = classFactory.getOrBuild(this.codeGeneratorForContext.generate(new Object[]{className, Context.Simple.class, interfaces}));
        try {
            return (T)((Method)this.componentSupplier.getMemberFinder().findOne((MemberCriteria)((MethodCriteria)((MethodCriteria)MethodCriteria.on((Object)cls).name("create"::equals)).and()).parameterTypes(paramsType -> ((Class[])paramsType).length == 0), cls)).invoke(null, new Object[0]);
        }
        catch (Exception exc) {
            throw Throwables.toRuntimeException((Object)exc);
        }
    }

    public Functions build(Config config, Object ... beanContainers) throws Throwable {
        Functions functions = this.buildFunctions(config, beanContainers);
        this.functionList.add(functions);
        return functions;
    }

    private Functions buildFunctions(Config config, Object ... beanContainers) throws Throwable {
        Functions functions = this.createMainFunctions(config);
        this.createChildren(config, functions, beanContainers);
        return functions;
    }

    private void createChildren(Config config, Functions functions, Object ... beanContainers) throws Throwable {
        if (config.getFunctions() != null && config.getFunctions().length > 0) {
            for (Config innerConfig : config.getFunctions()) {
                Object instance = null;
                AtomicReference<Class<Object>> superClassWrapper = new AtomicReference<Class<Object>>(Object.class);
                AtomicReference<String> methodNameWrapper = new AtomicReference<String>();
                if (Strings.isNotEmpty((String)innerConfig.getMethod())) {
                    String beanClassNameOrContextName = innerConfig.getMethod().split("::")[0];
                    methodNameWrapper.set(innerConfig.getMethod().split("::")[1]);
                    if ("new".equalsIgnoreCase(beanClassNameOrContextName.split("\\s+")[0])) {
                        beanClassNameOrContextName = beanClassNameOrContextName.split("\\s+")[1];
                        instance = Class.forName(beanClassNameOrContextName).getConstructor(new Class[0]).newInstance(new Object[0]);
                    } else if (beanClassNameOrContextName.startsWith("#")) {
                        Object beanContainer;
                        Object[] objectArray = beanContainers;
                        int n = objectArray.length;
                        for (int i = 0; i < n && (instance = this.retrieveBean(beanContainer = objectArray[i], beanClassNameOrContextName)) == null; ++i) {
                        }
                    } else {
                        instance = Class.forName(beanClassNameOrContextName);
                    }
                } else if (Strings.isEmpty((String)innerConfig.getMethod())) {
                    instance = this.buildFunctions(innerConfig, beanContainers);
                    superClassWrapper.set(instance.getClass());
                    methodNameWrapper.set(Strings.isNotEmpty((String)innerConfig.getMethod()) ? innerConfig.getMethod() : "executeOn");
                }
                Objects.requireNonNull(instance, "Object " + innerConfig.getMethod() + " not found");
                String methodName = (String)methodNameWrapper.get();
                Method mth = (Method)Optional.ofNullable(this.componentSupplier.getMemberFinder().findOne((MemberCriteria)((MethodCriteria)((MethodCriteria)((MethodCriteria)MethodCriteria.byScanUpTo(c -> c.getName().equals(((Class)superClassWrapper.get()).getName())).and()).name(methodName::equals)).and()).parameterTypes(parameterTypes -> ((Class[])parameterTypes).length == 1), instance)).orElse(this.componentSupplier.getMemberFinder().findOne((MemberCriteria)((MethodCriteria)((MethodCriteria)((MethodCriteria)MethodCriteria.byScanUpTo(c -> c.getName().equals(((Class)superClassWrapper.get()).getName())).and()).name(methodName::equals)).and()).parameterTypes(parameterTypes -> ((Class[])parameterTypes).length == 0), instance));
                Object functionalInterface = this.componentSupplier.getFunctionalInterfaceFactory().create(instance, Objects.requireNonNull(mth, "Could not bind function " + instance.getClass().getName() + "::" + mth.getName() + " to any Wrapper"));
                functions.add(CommandWrapper.create((Object)functionalInterface, (Object)instance));
            }
        }
    }

    private Functions createMainFunctions(Config config) {
        Functions functions = null;
        functions = config.isAsync() && Strings.isNotEmpty((String)config.getIterableObject()) ? Optional.ofNullable(config.getThreadsNumberAsInteger()).map(threadsNumber -> this.createAsyncFunctionsForCollection().apply(config)).orElseGet(() -> this.createAsyncFunctionsForCollectionWithSystemManagedThreads().apply(config)) : (Strings.isNotEmpty((String)config.getIterableObject()) ? this.createFunctionsForCollection().apply(config) : (config.isAsync() ? Optional.ofNullable(config.getThreadsNumberAsInteger()).map(threadsNumber -> this.createAsyncFunctions().apply(config)).orElseGet(() -> this.createAsyncFunctionsWithSystemManagedThreads().get()) : this.createFunctions().get()));
        functions.setName(config.getName());
        functions.setOnException(this.getDirectives(config.getOnException()));
        return functions;
    }

    public void close(Functions ... functions) {
        for (Functions function : functions) {
            function.close();
            this.functionList.remove((Object)function);
        }
    }

    public void close(Object ... contextes) {
        for (Object context : contextes) {
            ((Context)context).close();
            this.contextList.remove(context);
        }
    }

    public void close() {
        if (this.functionList != null) {
            for (Functions function : this.functionList) {
                this.close(function);
            }
            this.functionList.clear();
            this.functionList = null;
        }
        if (this.contextList != null) {
            for (Context context : this.contextList) {
                this.close(context);
            }
            this.contextList.clear();
            this.contextList = null;
        }
    }
}

