/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.graph;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.burningwave.Throwables;
import org.burningwave.core.CommandWrapper;
import org.burningwave.core.Component;
import org.burningwave.core.Group;
import org.burningwave.core.iterable.IterableObjectHelper;
import org.burningwave.core.reflection.PropertyAccessor;
import org.burningwave.graph.Context;
import org.burningwave.graph.ControllableContext;

public class Functions
extends Group<CommandWrapper<?, Context, Context>> {
    protected Map<String, ControllableContext.Directive> onException = new LinkedHashMap<String, ControllableContext.Directive>();

    Functions() {
    }

    void setOnException(Map<String, ControllableContext.Directive> onException) {
        this.onException = onException;
    }

    static Functions create(PropertyAccessor.ByFieldOrByMethod byFieldOrByMethodPropertyAccessor, PropertyAccessor.ByMethodOrByField byMethodOrByFieldPropertyAccessor, IterableObjectHelper iterableObjectHelper) {
        return new Functions();
    }

    static Context.Abst castContext(Context context) {
        return (Context.Abst)context;
    }

    public void executeOn(Object object) {
        Context context = (Context)object;
        this.logDebug("Start executing functions group {}", new Object[]{this.getName()});
        for (CommandWrapper functionWrapper : this.elements) {
            try {
                context = (Context)functionWrapper.executeOn((Object)context);
            }
            catch (Throwable exc) {
                this.logError("Exception occurred", exc);
                Functions.castContext(context).putAllDirectives(this.onException);
            }
            if (!context.containsOneOf(this.getName(), new ControllableContext.Directive[]{ControllableContext.Directive.Functions.STOP_PROCESSING})) continue;
            context.removeDirective(this.getName(), ControllableContext.Directive.Functions.STOP_PROCESSING);
            this.logDebug("Stopping processing functions group {}", new Object[]{Optional.ofNullable(this.getName()).orElse("")});
            break;
        }
        this.logDebug("End executing functions group {}", new Object[]{this.getName()});
    }

    protected Function<Throwable, Void> getExceptionHandlingFunction(Context context) {
        return exc -> {
            Optional.ofNullable(exc).ifPresent(exception -> {
                this.logError("Exception occurred", exception.getCause());
                Optional.ofNullable(this.onException).ifPresent(onExc -> Functions.castContext(context).putAllDirectives((Map<String, ControllableContext.Directive>)onExc));
            });
            return null;
        };
    }

    public void close() {
        if (this.elements != null) {
            for (CommandWrapper functionWrapper : this.elements) {
                if (functionWrapper.getTarget() instanceof Functions) {
                    ((Functions)((Object)functionWrapper.getTarget())).close();
                }
                functionWrapper.close();
            }
        }
        if (this.onException != null) {
            this.onException.clear();
            this.onException = null;
        }
        super.close();
    }

    public static class ForCollection<T>
    extends Functions {
        protected AlgorithmsSupplier algorithmsSupplier;

        private ForCollection(AlgorithmsSupplier algorithmsSupplier) {
            this.algorithmsSupplier = algorithmsSupplier;
        }

        protected static <T> ForCollection<T> create(PropertyAccessor.ByFieldOrByMethod byFieldOrByMethodPropertyAccessor, PropertyAccessor.ByMethodOrByField byMethodOrByFieldPropertyAccessor, IterableObjectHelper iterableObjectHelper, AlgorithmsSupplier algorithmsSupplier) {
            return new ForCollection<T>(algorithmsSupplier);
        }

        public static <T> ForCollection<T> create(PropertyAccessor.ByFieldOrByMethod byFieldOrByMethodPropertyAccessor, PropertyAccessor.ByMethodOrByField byMethodOrByFieldPropertyAccessor, IterableObjectHelper iterableObjectHelper, String iterableObjectContextKey, String loopResultContextKey) {
            return ForCollection.create(byFieldOrByMethodPropertyAccessor, byMethodOrByFieldPropertyAccessor, iterableObjectHelper, AlgorithmsSupplier.create(byFieldOrByMethodPropertyAccessor, byMethodOrByFieldPropertyAccessor, iterableObjectHelper, iterableObjectContextKey, loopResultContextKey));
        }

        @Override
        public void executeOn(Object object) {
            Context context = (Context)object;
            this.logDebug("Start executing functions group {}", new Object[]{this.getName()});
            this.algorithmsSupplier.preLoopOperationsRetriever.accept(context);
            AtomicInteger counter = new AtomicInteger(0);
            this.algorithmsSupplier.iterableObjectStreamRetriever.apply(context).filter(item -> {
                int idx = counter.getAndIncrement();
                this.executeOnItem(context, item, idx);
                return context.containsOneOf(this.getName(), new ControllableContext.Directive[]{ControllableContext.Directive.Functions.ForCollection.STOP_ITERATION});
            }).findFirst().ifPresent(functionWrapper -> {
                context.removeDirective(this.getName(), ControllableContext.Directive.Functions.ForCollection.STOP_ITERATION);
                this.logDebug("Stopping iteration of functions group {}", new Object[]{Optional.ofNullable(this.getName()).orElse("")});
            });
            this.algorithmsSupplier.postLoopOperationsRetriever.accept(context);
            this.logDebug("End executing functions group {}", new Object[]{this.getName()});
        }

        void executeOnItem(Context context, T item, int idx) {
            Context clonedContext = this.algorithmsSupplier.putIteratedObjectInContextRetriever.apply(new Object[]{context, item, idx});
            this.elements.stream().filter(functionWrapper -> {
                functionWrapper.executeOn((Object)clonedContext);
                return clonedContext.containsOneOf(this.getName(), new ControllableContext.Directive[]{ControllableContext.Directive.Functions.STOP_PROCESSING});
            }).findFirst().ifPresent(functionWrapper -> {
                clonedContext.removeDirective(this.getName(), ControllableContext.Directive.Functions.STOP_PROCESSING);
                this.logDebug("Stopping processing functions group {}", new Object[]{Optional.ofNullable(this.getName()).orElse("")});
            });
            try {
                clonedContext.close();
            }
            catch (Exception exc) {
                throw Throwables.toRuntimeException((Object)exc);
            }
        }

        @Override
        public void close() {
            this.algorithmsSupplier.close();
            this.algorithmsSupplier = null;
            super.close();
        }

        public static class Async<T>
        extends ForCollection<T> {
            protected ExecutorService executor;

            private Async(AlgorithmsSupplier algorithmsSupplier, ExecutorService executor) {
                super(algorithmsSupplier);
                this.executor = executor;
            }

            protected static <T> Async<T> create(AlgorithmsSupplier algorithmsSupplier, ExecutorService executor) {
                return new Async<T>(algorithmsSupplier, executor);
            }

            public static <T> Async<T> create(PropertyAccessor.ByFieldOrByMethod byFieldOrByMethodPropertyAccessor, PropertyAccessor.ByMethodOrByField byMethodOrByFieldPropertyAccessor, IterableObjectHelper iterableObjectHelper, String iterableObjectContextKey, String loopResultContextKey, ExecutorService executor) {
                return Async.create(AlgorithmsSupplier.create(byFieldOrByMethodPropertyAccessor, byMethodOrByFieldPropertyAccessor, iterableObjectHelper, iterableObjectContextKey, loopResultContextKey), executor);
            }

            public static <T> Async<T> create(PropertyAccessor.ByFieldOrByMethod byFieldOrByMethodPropertyAccessor, PropertyAccessor.ByMethodOrByField byMethodOrByFieldPropertyAccessor, IterableObjectHelper iterableObjectHelper, String collectionContextKey, String loopResultContextKey) {
                return Async.create(byFieldOrByMethodPropertyAccessor, byMethodOrByFieldPropertyAccessor, iterableObjectHelper, collectionContextKey, loopResultContextKey, (ExecutorService)null);
            }

            public static <T> Async<T> create(PropertyAccessor.ByFieldOrByMethod byFieldOrByMethodPropertyAccessor, PropertyAccessor.ByMethodOrByField byMethodOrByFieldPropertyAccessor, IterableObjectHelper iterableObjectHelper, String collectionContextKey, String loopResultContextKey, Integer threadsNumber) {
                return Async.create(byFieldOrByMethodPropertyAccessor, byMethodOrByFieldPropertyAccessor, iterableObjectHelper, collectionContextKey, loopResultContextKey, Executors.newFixedThreadPool(threadsNumber));
            }

            @Override
            public void executeOn(Object object) {
                Context context = (Context)object;
                this.logDebug("Start executing functions group {}", new Object[]{this.getName()});
                CopyOnWriteArrayList completableFutureList = new CopyOnWriteArrayList();
                this.algorithmsSupplier.preLoopOperationsRetriever.accept(context);
                AtomicInteger counter = new AtomicInteger(0);
                this.algorithmsSupplier.iterableObjectStreamRetriever.apply(context).filter(item -> {
                    int idx = counter.getAndIncrement();
                    Runnable executeOnItemFunction = () -> this.executeOnItem(context, item, idx);
                    CompletionStage completableFuture = (this.executor != null ? CompletableFuture.runAsync(executeOnItemFunction, this.executor) : CompletableFuture.runAsync(executeOnItemFunction)).exceptionally((Function)this.getExceptionHandlingFunction(context));
                    completableFutureList.add(completableFuture);
                    ((CompletableFuture)completableFuture).thenAcceptAsync(arg_0 -> Async.lambda$null$1(completableFutureList, (CompletableFuture)completableFuture, arg_0));
                    return context.containsOneOf(this.getName(), new ControllableContext.Directive[]{ControllableContext.Directive.Functions.ForCollection.STOP_ITERATION});
                }).findFirst().ifPresent(functionWrapper -> {
                    context.removeDirective(this.getName(), ControllableContext.Directive.Functions.ForCollection.STOP_ITERATION);
                    this.logDebug("Stopping iteration of functions group {}", new Object[]{Optional.ofNullable(this.getName()).orElse("")});
                });
                this.algorithmsSupplier.postLoopOperationsRetriever.accept(context);
                CompletableFuture.allOf((CompletableFuture[])completableFutureList.stream().toArray(CompletableFuture[]::new)).join();
                completableFutureList.clear();
                this.logDebug("End executing functions group {}", new Object[]{this.getName()});
            }

            @Override
            public void close() {
                if (this.executor != null && !this.executor.isShutdown()) {
                    this.executor.shutdownNow().clear();
                    this.executor = null;
                }
                super.close();
            }

            private static /* synthetic */ void lambda$null$1(List completableFutureList, CompletableFuture completableFuture, Object function) {
                completableFutureList.remove(completableFuture);
            }
        }

        private static class AlgorithmsSupplier
        implements Component {
            PropertyAccessor.ByFieldOrByMethod byFieldOrByMethodPropertyAccessor;
            PropertyAccessor.ByMethodOrByField byMethodOrByFieldPropertyAccessor;
            IterableObjectHelper iterableObjectHelper;
            String iterableObjectContextKey;
            String loopResultContextKey;
            Consumer<Context> preLoopOperationsRetriever = context -> Optional.ofNullable(this.loopResultContextKey).ifPresent(oCDk -> {
                Object[] resultsContainer = new Object[(int)this.iterableObjectHelper.getSize(this.retrieve((Context)context, this.iterableObjectContextKey))];
                this.byMethodOrByFieldPropertyAccessor.set(context, oCDk, (Object)resultsContainer);
            });
            Function<Context, Stream<?>> iterableObjectStreamRetriever = context -> this.iterableObjectHelper.retrieveStream(this.retrieve((Context)context, this.iterableObjectContextKey));
            Function<Object[], Context> putIteratedObjectInContextRetriever = objects -> {
                Context context = (Context)objects[0];
                Context clonedContext = context.createSymmetricClone();
                Object iterableObject = this.retrieve(context, this.iterableObjectContextKey);
                Functions.castContext(clonedContext).setCurrentIterationObjects(iterableObject, Optional.ofNullable(this.loopResultContextKey).map(oCDk -> (Object[])this.retrieve(context, (String)oCDk)).orElse(null), !(iterableObject instanceof Map) ? objects[1] : ((Map)iterableObject).get(objects[1]), (Integer)objects[2], !(iterableObject instanceof Map) ? (Integer)objects[2] : objects[1]);
                return clonedContext;
            };
            Consumer<Context> postLoopOperationsRetriever = context -> {};

            private AlgorithmsSupplier(PropertyAccessor.ByFieldOrByMethod byFieldOrByMethodPropertyAccessor, PropertyAccessor.ByMethodOrByField byMethodOrByFieldPropertyAccessor, IterableObjectHelper iterableObjectHelper, String iterableObjectContextKey, String loopResultContextKey) {
                this.byFieldOrByMethodPropertyAccessor = byFieldOrByMethodPropertyAccessor;
                this.byMethodOrByFieldPropertyAccessor = byMethodOrByFieldPropertyAccessor;
                this.iterableObjectHelper = iterableObjectHelper;
                this.iterableObjectContextKey = iterableObjectContextKey;
                this.loopResultContextKey = loopResultContextKey;
            }

            static AlgorithmsSupplier create(PropertyAccessor.ByFieldOrByMethod byFieldOrByMethodPropertyAccessor, PropertyAccessor.ByMethodOrByField byMethodOrByFieldPropertyAccessor, IterableObjectHelper iterableObjectHelper, String iterableObjectContextKey, String loopResultContextKey) {
                return new AlgorithmsSupplier(byFieldOrByMethodPropertyAccessor, byMethodOrByFieldPropertyAccessor, iterableObjectHelper, iterableObjectContextKey, loopResultContextKey);
            }

            Object retrieve(Context context, String propertyPath) {
                return this.byMethodOrByFieldPropertyAccessor.get((Object)context, propertyPath);
            }

            public void close() {
                this.byFieldOrByMethodPropertyAccessor = null;
                this.byMethodOrByFieldPropertyAccessor = null;
                this.iterableObjectHelper = null;
                this.iterableObjectContextKey = null;
                this.loopResultContextKey = null;
            }
        }
    }

    public static class Async
    extends Functions {
        protected ExecutorService executor;

        private Async(PropertyAccessor.ByFieldOrByMethod byFieldOrByMethodPropertyAccessor, PropertyAccessor.ByMethodOrByField byMethodOrByFieldPropertyAccessor, IterableObjectHelper iterableObjectHelper, ExecutorService executor) {
            this.executor = executor;
        }

        public static Async create(PropertyAccessor.ByFieldOrByMethod byFieldOrByMethodPropertyAccessor, PropertyAccessor.ByMethodOrByField byMethodOrByFieldPropertyAccessor, IterableObjectHelper iterableObjectHelper) {
            return new Async(byFieldOrByMethodPropertyAccessor, byMethodOrByFieldPropertyAccessor, iterableObjectHelper, null);
        }

        public static Async create(PropertyAccessor.ByFieldOrByMethod byFieldOrByMethodPropertyAccessor, PropertyAccessor.ByMethodOrByField byMethodOrByFieldPropertyAccessor, IterableObjectHelper iterableObjectHelper, ExecutorService executor) {
            return new Async(byFieldOrByMethodPropertyAccessor, byMethodOrByFieldPropertyAccessor, iterableObjectHelper, executor);
        }

        public static Async create(PropertyAccessor.ByFieldOrByMethod byFieldOrByMethodPropertyAccessor, PropertyAccessor.ByMethodOrByField byMethodOrByFieldPropertyAccessor, IterableObjectHelper iterableObjectHelper, int threadsNumber) {
            return new Async(byFieldOrByMethodPropertyAccessor, byMethodOrByFieldPropertyAccessor, iterableObjectHelper, Executors.newFixedThreadPool(threadsNumber));
        }

        @Override
        public void executeOn(Object object) {
            Context context = (Context)object;
            this.logDebug("Start executing functions group {}", new Object[]{this.getName()});
            CopyOnWriteArrayList completableFutureList = new CopyOnWriteArrayList();
            this.elements.stream().filter(functionWrapper -> {
                Runnable runnableFunction = () -> {
                    Context cfr_ignored_0 = (Context)functionWrapper.executeOn((Object)context);
                };
                CompletionStage completableFuture = (this.executor != null ? CompletableFuture.runAsync(runnableFunction, this.executor) : CompletableFuture.runAsync(runnableFunction)).exceptionally((Function)this.getExceptionHandlingFunction(context));
                completableFutureList.add(completableFuture);
                ((CompletableFuture)completableFuture).thenAcceptAsync(arg_0 -> Async.lambda$null$1(completableFutureList, (CompletableFuture)completableFuture, arg_0));
                return context.containsOneOf(this.getName(), new ControllableContext.Directive[]{ControllableContext.Directive.Functions.STOP_PROCESSING});
            }).findFirst().ifPresent(functionWrapper -> {
                context.removeDirective(this.getName(), ControllableContext.Directive.Functions.STOP_PROCESSING);
                this.logDebug("Stopping processing functions group {}", new Object[]{Optional.ofNullable(this.getName()).orElse("")});
            });
            CompletableFuture.allOf((CompletableFuture[])completableFutureList.stream().toArray(CompletableFuture[]::new)).join();
            completableFutureList.clear();
            this.logDebug("End executing functions group {}", new Object[]{this.getName()});
        }

        @Override
        public void close() {
            if (this.executor != null && !this.executor.isShutdown()) {
                this.executor.shutdownNow().clear();
                this.executor = null;
            }
            super.close();
        }

        private static /* synthetic */ void lambda$null$1(List completableFutureList, CompletableFuture completableFuture, Object obj) {
            completableFutureList.remove(completableFuture);
        }
    }
}

