/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.json;

import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import com.fasterxml.jackson.module.jsonSchema.types.BooleanSchema;
import com.fasterxml.jackson.module.jsonSchema.types.IntegerSchema;
import com.fasterxml.jackson.module.jsonSchema.types.NumberSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.types.StringSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.burningwave.Strings;
import org.burningwave.Throwables;
import org.burningwave.json.IndexedObjectCheck;
import org.burningwave.json.LeafCheck;
import org.burningwave.json.ObjectCheck;
import org.burningwave.json.ObjectHandler;
import org.burningwave.json.Path;
import org.burningwave.json.SLF4J;
import org.burningwave.json.ValidationConfig;
import org.slf4j.Logger;

public class ValidationContext {
    static final String MOCK_SCHEMA_LABEL;
    protected static final Object logger;
    final Function<Path.ValidationContext<?, ?>, Function<String, Function<Object[], Throwable>>> exceptionBuilder;
    final ValidationConfig<?> validationConfig;
    final ObjectHandler inputHandler;
    final Collection<Throwable> exceptions;
    final Function<Path.ValidationContext<?, ?>, Consumer<Throwable>> exceptionAdder;
    final Collection<ObjectCheck> objectChecks;
    final Collection<IndexedObjectCheck<?>> indexedObjectChecks;
    final Collection<LeafCheck<?, ?>> leafChecks;

    ValidationContext(Function<Path.ValidationContext<?, ?>, Function<String, Function<Object[], Throwable>>> exceptionBuilder, ValidationConfig<?> validationConfig, ObjectHandler jsonObjectWrapper, Collection<ObjectCheck> objectChecks, Collection<IndexedObjectCheck<?>> indexedObjectChecks, Collection<LeafCheck<?, ?>> leafChecks) {
        this.exceptionBuilder = exceptionBuilder;
        this.validationConfig = validationConfig;
        this.inputHandler = jsonObjectWrapper;
        this.exceptions = validationConfig.validateAll ? new ArrayList() : null;
        this.exceptionAdder = validationConfig.validateAll ? pathValidationContext -> this.exceptions::add : pathValidationContext -> exc -> {
            if (logger != null && validationConfig.isErrorLoggingEnabled()) {
                ((Logger)logger).debug("Validation of path {} failed", (Object)pathValidationContext.path);
            }
            Throwables.INSTANCE.throwException(exc);
        };
        this.objectChecks = objectChecks;
        this.indexedObjectChecks = indexedObjectChecks;
        this.leafChecks = leafChecks;
    }

    void rejectValue(Path.ValidationContext<?, ?> pathValidationContext, String checkType, Object ... messageArgs) {
        this.exceptionAdder.apply(pathValidationContext).accept(this.exceptionBuilder.apply(pathValidationContext).apply(checkType).apply(messageArgs));
    }

    boolean checkValue(JsonSchema jsonSchema, Object value) {
        if (value != null) {
            if (!this.checkUnindexedObject(jsonSchema, value)) {
                return false;
            }
            if (jsonSchema instanceof ArraySchema) {
                if (!(value instanceof Collection)) {
                    return false;
                }
                JsonSchema itemsSchema = ((ArraySchema)jsonSchema).getItems().asSingleItems().getSchema();
                for (Object item : (Collection)value) {
                    if (this.checkUnindexedObject(itemsSchema, item)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkUnindexedObject(JsonSchema jsonSchema, Object value) {
        return jsonSchema instanceof ObjectSchema && value instanceof Map || jsonSchema instanceof StringSchema && value instanceof String || jsonSchema instanceof IntegerSchema && value instanceof Integer || jsonSchema instanceof NumberSchema && value instanceof Number || jsonSchema instanceof BooleanSchema && value instanceof Boolean;
    }

    public ObjectHandler getInputHandler() {
        return this.inputHandler;
    }

    static {
        logger = SLF4J.INSTANCE.tryToInitLogger(ValidationContext.class);
        MOCK_SCHEMA_LABEL = Strings.INSTANCE.toStringWithRandomUUIDSuffix("schemaMock");
    }
}

