/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.json;

import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.burningwave.Classes;
import org.burningwave.Strings;
import org.burningwave.json.Check;
import org.burningwave.json.ObjectHandler;

public class Path {
    public static final Path INSTANCE = new Path();
    private final Pattern multipleIndexesSearcher = Pattern.compile("\\[([\\d*\\s*,*]+)\\]");
    private final Pattern singleIndexSearcher = Pattern.compile("\\[([\\d*]+)\\]");
    private final Pattern pathSeparatorSearcher = Pattern.compile("\\.(?![\\/\\.])");
    private final Pattern unvalidCurrentOrParentDirectoryPlaceHolderSearcher = Pattern.compile("(?<![\\.\\/])\\.\\/|(?<!\\/)\\.\\.\\/");

    private Path() {
    }

    public static final String of(String ... pathSegments) {
        return String.join((CharSequence)".", Arrays.asList(pathSegments).stream().filter(value -> !value.isEmpty()).collect(Collectors.toList())).replace("../.", "../").replace("./.", "./");
    }

    public String getName(String path) {
        String[] splittedPath = path.split("\\.");
        return splittedPath[splittedPath.length - 1];
    }

    public String normalize(String basePath, String pathOrRelativePath) {
        String joinCharacter = "";
        if (basePath == null) {
            basePath = "";
        }
        if (pathOrRelativePath == null) {
            pathOrRelativePath = "";
        }
        if (basePath.isEmpty()) {
            if (pathOrRelativePath.startsWith(".")) {
                throw new IllegalArgumentException("Base path cannot be null if the path or relative parameter is a relative path");
            }
        } else if (pathOrRelativePath.startsWith(".") || basePath.endsWith(".")) {
            joinCharacter = "/";
        } else if (!pathOrRelativePath.isEmpty()) {
            joinCharacter = ".";
        }
        return this.normalize(String.join((CharSequence)joinCharacter, Arrays.asList(basePath, pathOrRelativePath)));
    }

    public String normalize(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        String originalPath = path;
        if (this.unvalidCurrentOrParentDirectoryPlaceHolderSearcher.matcher(path).find()) {
            throw new IllegalArgumentException(path + " contains not valid " + "./" + " or " + "../" + " references");
        }
        Matcher matcher = this.singleIndexSearcher.matcher(path);
        int placeHolderIndex = 1;
        LinkedHashMap<String, String> indexesHolder = new LinkedHashMap<String, String>();
        while (matcher.find()) {
            String placeHolder = "${" + placeHolderIndex++ + "}";
            indexesHolder.put("/" + placeHolder, matcher.group(1));
            path = path.replaceFirst(this.singleIndexSearcher.pattern(), "/\\" + placeHolder);
        }
        if ((path = Strings.INSTANCE.normalizePath(this.pathSeparatorSearcher.matcher(path).replaceAll("/"))) == null) {
            throw new IllegalArgumentException(originalPath + " is not a valid path");
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.lastIndexOf("/"));
        }
        for (Map.Entry replacement : indexesHolder.entrySet()) {
            path = path.replace((CharSequence)replacement.getKey(), "[" + (String)replacement.getValue() + "]");
        }
        return path.replace("/", ".");
    }

    public List<Integer> getIndexes(String path) {
        Matcher matcher = this.singleIndexSearcher.matcher(path);
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        while (matcher.find()) {
            indexes.add(Integer.parseInt(matcher.group(1)));
        }
        return indexes;
    }

    public String toEndsWithRegEx(String value) {
        return ".*?" + this.toRegEx(value);
    }

    public String toStartsWithRegEx(String value) {
        return this.toRegEx(value) + ".*?";
    }

    public String toContainsRegEx(String value) {
        return ".*?" + this.toRegEx(value) + ".*?";
    }

    public String toRegEx(String value) {
        Matcher matcher = this.multipleIndexesSearcher.matcher(value);
        return this.multipleIndexesSearcher.splitAsStream(value).map(piece -> piece + (matcher.find() ? "\\[(" + String.join((CharSequence)"|", matcher.group(1).split(",")) + ")\\]" : "")).collect(Collectors.joining()).replace(".", "\\.").replace("[]", "\\[.+?\\]");
    }

    public boolean isRoot(String path) {
        return "".equals(path);
    }

    public static class Segment {
        public static final String root = "";
        public static final String parent = "../";
        public static final String current = "./";

        protected Segment() {
        }

        public static final String toIndexed(String pathSegment, int ... indexes) {
            StringBuilder indexedNameBuilder = new StringBuilder(pathSegment);
            indexedNameBuilder.append("[");
            for (int i = 0; i < indexes.length; ++i) {
                indexedNameBuilder.append(indexes[i]);
                indexedNameBuilder.append(",");
            }
            String indexedName = indexedNameBuilder.toString();
            if (indexedName.endsWith(",")) {
                indexedName = indexedName.substring(0, indexedName.length() - 1);
            }
            return indexedName + "]";
        }
    }

    static abstract class Predicate<P>
    implements java.util.function.Predicate<P> {
        Collection<Map.Entry<String, String>> pathForRegEx = new ArrayList<Map.Entry<String, String>>();

        private Predicate() {
        }

        Predicate(String path, String pathRegEx) {
            this();
            this.pathForRegEx.add(new AbstractMap.SimpleEntry<String, String>(path, pathRegEx));
        }

        @Override
        public Predicate<P> and(java.util.function.Predicate<? super P> other) {
            return this.concat(other, input -> this.test(input) && other.test((P)input));
        }

        @Override
        public Predicate<P> or(java.util.function.Predicate<? super P> other) {
            return this.concat(other, input -> this.test(input) || other.test((P)input));
        }

        @Override
        public Predicate<P> negate() {
            return this.concat(null, input -> !this.test(input));
        }

        Predicate<P> concat(java.util.function.Predicate<? super P> other, final java.util.function.Predicate<? super P> finalPredicate) {
            Collection<Map.Entry<String, String>> otherPathForRegEx = other instanceof Predicate ? ((Predicate)other).pathForRegEx : null;
            Predicate pathPredicate = new Predicate<P>(){

                @Override
                public boolean test(P input) {
                    return finalPredicate.test(input);
                }
            };
            pathPredicate.pathForRegEx.addAll(this.pathForRegEx);
            if (otherPathForRegEx != null) {
                pathPredicate.pathForRegEx.addAll(otherPathForRegEx);
            }
            return pathPredicate;
        }
    }

    public static class ValidationContext<S extends JsonSchema, T> {
        final org.burningwave.json.ValidationContext validationContext;
        final String path;
        final String name;
        final List<Integer> indexes;
        final S jsonSchema;
        final T rawValue;

        ValidationContext(org.burningwave.json.ValidationContext validationContext, String path, S jsonSchema, Object value) {
            this.validationContext = validationContext;
            this.path = path;
            this.jsonSchema = jsonSchema;
            this.name = INSTANCE.getName(path);
            List<Integer> indexes = INSTANCE.getIndexes(this.name);
            this.indexes = !indexes.isEmpty() ? Collections.unmodifiableList(indexes) : null;
            String schemaDescription = jsonSchema.getDescription();
            if (org.burningwave.json.ValidationContext.MOCK_SCHEMA_LABEL.equals(schemaDescription) && !validationContext.checkValue((JsonSchema)jsonSchema, value)) {
                this.rejectValue(Check.Error.UNEXPECTED_TYPE, new Object[0]);
            }
            this.rawValue = value;
        }

        public ObjectHandler getRootHandler() {
            return this.validationContext.getInputHandler();
        }

        public ObjectHandler getObjectHandler() {
            return (ObjectHandler)this.getRootHandler().newFinder().findForPathEquals(new String[]{this.path});
        }

        public void rejectValue(Check.Error checkType, Object ... messageArgs) {
            this.validationContext.rejectValue(this, checkType.name(), messageArgs);
        }

        public void rejectValue(String checkType, Object ... messageArgs) {
            this.validationContext.rejectValue(this, checkType, messageArgs);
        }

        public static <S extends JsonSchema, T> java.util.function.Predicate<ValidationContext<S, T>> predicateFor(Class<T> valueType, java.util.function.Predicate<ValidationContext<S, T>> predicate) {
            return pathValidationContext -> (valueType == null || valueType.isInstance(pathValidationContext.rawValue)) && predicate.test((ValidationContext)pathValidationContext);
        }

        public boolean isFieldRequired() {
            return Optional.ofNullable(this.jsonSchema.getRequired()).orElseGet(() -> false);
        }

        public org.burningwave.json.ValidationContext getValidationContext() {
            return this.validationContext;
        }

        public S getJsonSchema() {
            return this.jsonSchema;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        public T getRawValue() {
            return this.rawValue;
        }

        public T getValue() {
            if (this.rawValue != null && !Classes.INSTANCE.isPrimitive(this.rawValue)) {
                this.getRootHandler().newValueFinder().findForPathEquals(new String[]{this.path});
            }
            return this.rawValue;
        }

        public Integer getIndex() {
            return this.indexes != null ? this.indexes.get(this.indexes.size() - 1) : null;
        }

        public <V> V getParent() {
            return this.findValue("../");
        }

        public <V> V findValue(String ... pathSegmentsOrRelativePathSegments) {
            return (V)this.getRootHandler().newValueFinder().findForPathEquals(new String[]{this.resolvePath(pathSegmentsOrRelativePathSegments)});
        }

        public ObjectHandler findObjectHandler(String ... pathSegmentsOrRelativePathSegments) {
            return (ObjectHandler)this.getRootHandler().newFinder().findForPathEquals(new String[]{this.resolvePath(pathSegmentsOrRelativePathSegments)});
        }

        public <V> V findValueAndConvert(Class<V> targetClass, String ... pathSegmentsOrRelativePathSegments) {
            return (V)this.getRootHandler().newValueFinderAndConverter(targetClass).findForPathEquals(new String[]{this.resolvePath(pathSegmentsOrRelativePathSegments)});
        }

        protected String resolvePath(String ... pathSegmentsOrRelativePathSegments) {
            String pathToFind = Path.of(pathSegmentsOrRelativePathSegments);
            if (!pathToFind.startsWith("/")) {
                return INSTANCE.normalize(this.path, pathToFind);
            }
            return INSTANCE.normalize(pathToFind);
        }

        public boolean isRoot() {
            return INSTANCE.isRoot(this.path);
        }

        public String toString() {
            return this.path + " - " + this.jsonSchema.getClass().getSimpleName().replace("Schema", "") + ": " + Optional.ofNullable(this.rawValue).map(Object::toString).orElseGet(() -> "null");
        }
    }
}

