/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.burningwave.json.ObjectHandler;
import org.burningwave.json.SchemaHolder;
import org.burningwave.json.Validator;

public class Facade {
    private ObjectMapper objectMapper;
    private Validator validator;
    private SchemaHolder schemaHolder;

    private Facade() {
        this(new ObjectMapper());
    }

    private Facade(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.schemaHolder = new SchemaHolder(objectMapper);
        this.validator = new Validator(this.schemaHolder);
    }

    public static Facade create() {
        return new Facade();
    }

    public static Facade create(ObjectMapper objectMapper) {
        return new Facade(objectMapper);
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    public ObjectHandler newObjectHandler(Object jsonObject) {
        return ObjectHandler.create(this.objectMapper, jsonObject);
    }

    public Validator validator() {
        return this.validator;
    }
}

