/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.json;

import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import com.fasterxml.jackson.module.jsonSchema.types.BooleanSchema;
import com.fasterxml.jackson.module.jsonSchema.types.IntegerSchema;
import com.fasterxml.jackson.module.jsonSchema.types.NumberSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.types.StringSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.burningwave.json.IndexedObjectCheck;
import org.burningwave.json.LeafCheck;
import org.burningwave.json.ObjectCheck;
import org.burningwave.json.Path;

public interface Check<S extends JsonSchema, T, O extends Check<S, T, O>> {
    public O execute(Consumer<Path.Validation.Context<S, T>> var1);

    default public O checkMandatory() {
        return this.execute(pathValidationContext -> {
            if (pathValidationContext.isFieldRequired() && pathValidationContext.getRawValue() == null) {
                pathValidationContext.rejectValue("IS_NULL", "is null", new Object[0]);
            }
        });
    }

    public static Group forAll() {
        return Group.of(Check.whenObject(null), Check.whenIndexedObject(null), Check.whenValue(null));
    }

    public static <O> Group when(Predicate<Path.Validation.Context<JsonSchema, O>> predicate) {
        return Group.of(Check.whenObject(predicate), Check.whenIndexedObject(predicate), Check.whenValue(predicate));
    }

    public static Group whenPathStartsWith(String ... pathSegments) {
        return Group.of(Check.whenObjectPathStartsWith(pathSegments), Check.whenIndexedObjectPathStartsWith(pathSegments), Check.whenValuePathStartsWith(pathSegments));
    }

    public static Group whenPathEndsWith(String ... pathSegments) {
        return Group.of(Check.whenObjectPathEndsWith(pathSegments), Check.whenIndexedObjectPathEndsWith(pathSegments), Check.whenValuePathEndsWith(pathSegments));
    }

    public static Group whenPathContains(String ... pathSegments) {
        return Group.of(Check.whenObjectPathContains(pathSegments), Check.whenIndexedObjectPathContains(pathSegments), Check.whenValuePathContains(pathSegments));
    }

    public static Group whenPathEquals(String ... pathSegments) {
        return Group.of(Check.whenObjectPathEquals(pathSegments), Check.whenIndexedObjectPathEquals(pathSegments), Check.whenValuePathEquals(pathSegments));
    }

    public static LeafCheck<JsonSchema, Object> forAllValues() {
        return Check.whenValue(null);
    }

    public static LeafCheck<JsonSchema, Object> whenValue(Predicate<Path.Validation.Context<JsonSchema, Object>> predicate) {
        return new LeafCheck<JsonSchema, Object>(JsonSchema.class, predicate);
    }

    public static LeafCheck<JsonSchema, Object> whenValuePathStartsWith(String ... pathSegments) {
        return new LeafCheck<JsonSchema, Object>(JsonSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toStartsWithRegEx));
    }

    public static LeafCheck<JsonSchema, Object> whenValuePathEndsWith(String ... pathSegments) {
        return new LeafCheck<JsonSchema, Object>(JsonSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toEndsWithRegEx));
    }

    public static LeafCheck<JsonSchema, Object> whenValuePathContains(String ... pathSegments) {
        return new LeafCheck<JsonSchema, Object>(JsonSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toContainsRegEx));
    }

    public static LeafCheck<JsonSchema, Object> whenValuePathEquals(String ... pathSegments) {
        return new LeafCheck<JsonSchema, Object>(JsonSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toRegEx));
    }

    public static LeafCheck<StringSchema, String> forAllStringValues() {
        return Check.whenStringValue(null);
    }

    public static LeafCheck.OfString whenStringValue(Predicate<Path.Validation.Context<StringSchema, String>> predicate) {
        return new LeafCheck.OfString(predicate);
    }

    public static LeafCheck<StringSchema, String> whenStringValuePathStartsWith(String ... pathSegments) {
        return new LeafCheck.OfString(Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toStartsWithRegEx));
    }

    public static LeafCheck<StringSchema, String> whenStringValuePathEndsWith(String ... pathSegments) {
        return new LeafCheck.OfString(Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toEndsWithRegEx));
    }

    public static LeafCheck<StringSchema, String> whenStringValuePathContains(String ... pathSegments) {
        return new LeafCheck.OfString(Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toContainsRegEx));
    }

    public static LeafCheck<StringSchema, String> whenStringValuePathEquals(String ... pathSegments) {
        return new LeafCheck.OfString(Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toRegEx));
    }

    public static LeafCheck<IntegerSchema, Integer> forAllIntegerValues() {
        return Check.whenIntegerValue(null);
    }

    public static LeafCheck<IntegerSchema, Integer> whenIntegerValue(Predicate<Path.Validation.Context<IntegerSchema, Integer>> predicate) {
        return new LeafCheck<IntegerSchema, Integer>(IntegerSchema.class, predicate);
    }

    public static LeafCheck<IntegerSchema, String> whenIntegerValuePathStartsWith(String ... pathSegments) {
        return new LeafCheck<IntegerSchema, String>(IntegerSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toStartsWithRegEx));
    }

    public static LeafCheck<IntegerSchema, String> whenIntegerValuePathEndsWith(String ... pathSegments) {
        return new LeafCheck<IntegerSchema, String>(IntegerSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toEndsWithRegEx));
    }

    public static LeafCheck<IntegerSchema, String> whenIntegerValuePathContains(String ... pathSegments) {
        return new LeafCheck<IntegerSchema, String>(IntegerSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toContainsRegEx));
    }

    public static LeafCheck<IntegerSchema, String> whenIntegerValuePathEquals(String ... pathSegments) {
        return new LeafCheck<IntegerSchema, String>(IntegerSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toRegEx));
    }

    public static LeafCheck<NumberSchema, Number> forAllNumberValues() {
        return Check.whenNumberValue(null);
    }

    public static LeafCheck<NumberSchema, Number> whenNumberValue(Predicate<Path.Validation.Context<NumberSchema, Number>> predicate) {
        return new LeafCheck<NumberSchema, Number>(NumberSchema.class, predicate);
    }

    public static LeafCheck<NumberSchema, String> whenNumberValuePathStartsWith(String ... pathSegments) {
        return new LeafCheck<NumberSchema, String>(NumberSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toStartsWithRegEx));
    }

    public static LeafCheck<NumberSchema, String> whenNumberValuePathEndsWith(String ... pathSegments) {
        return new LeafCheck<NumberSchema, String>(NumberSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toEndsWithRegEx));
    }

    public static LeafCheck<NumberSchema, String> whenNumberValuePathContains(String ... pathSegments) {
        return new LeafCheck<NumberSchema, String>(NumberSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toContainsRegEx));
    }

    public static LeafCheck<NumberSchema, String> whenNumberValuePathEquals(String ... pathSegments) {
        return new LeafCheck<NumberSchema, String>(NumberSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toRegEx));
    }

    public static LeafCheck<BooleanSchema, Boolean> forAllBooleanValues() {
        return Check.whenBooleanValue(null);
    }

    public static LeafCheck<BooleanSchema, Boolean> whenBooleanValue(Predicate<Path.Validation.Context<BooleanSchema, Boolean>> predicate) {
        return new LeafCheck<BooleanSchema, Boolean>(BooleanSchema.class, predicate);
    }

    public static LeafCheck<BooleanSchema, String> whenBooleanValuePathStartsWith(String ... pathSegments) {
        return new LeafCheck<BooleanSchema, String>(BooleanSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toStartsWithRegEx));
    }

    public static LeafCheck<BooleanSchema, String> whenBooleanValuePathEndsWith(String ... pathSegments) {
        return new LeafCheck<BooleanSchema, String>(BooleanSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toEndsWithRegEx));
    }

    public static LeafCheck<BooleanSchema, String> whenBooleanValuePathEquals(String ... pathSegments) {
        return new LeafCheck<BooleanSchema, String>(BooleanSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toContainsRegEx));
    }

    public static LeafCheck<BooleanSchema, String> whenBooleanValuePathContains(String ... pathSegments) {
        return new LeafCheck<BooleanSchema, String>(BooleanSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toRegEx));
    }

    public static ObjectCheck forAllObjects() {
        return Check.whenObject(null);
    }

    public static ObjectCheck whenObject(Predicate<Path.Validation.Context<ObjectSchema, Map<String, Object>>> predicate) {
        return new ObjectCheck(predicate);
    }

    public static ObjectCheck whenObjectPathStartsWith(String ... pathSegments) {
        return new ObjectCheck(Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toStartsWithRegEx));
    }

    public static ObjectCheck whenObjectPathEndsWith(String ... pathSegments) {
        return new ObjectCheck(Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toEndsWithRegEx));
    }

    public static ObjectCheck whenObjectPathContains(String ... pathSegments) {
        return new ObjectCheck(Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toContainsRegEx));
    }

    public static ObjectCheck whenObjectPathEquals(String ... pathSegments) {
        return new ObjectCheck(Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toRegEx));
    }

    public static <I> IndexedObjectCheck<I> forAllIndexedObjects() {
        return Check.whenIndexedObject(null);
    }

    public static <I> IndexedObjectCheck<I> whenIndexedObject(Predicate<Path.Validation.Context<ArraySchema, List<I>>> predicate) {
        return new IndexedObjectCheck<I>((Class<JsonSchema>)null, predicate);
    }

    public static <I> IndexedObjectCheck<I> whenIndexedObjectPathStartsWith(String ... pathSegments) {
        return new IndexedObjectCheck((Class<? extends JsonSchema>)((Class<JsonSchema>)null), Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toStartsWithRegEx));
    }

    public static <I> IndexedObjectCheck<I> whenIndexedObjectPathEndsWith(String ... pathSegments) {
        return new IndexedObjectCheck((Class<? extends JsonSchema>)((Class<JsonSchema>)null), Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toEndsWithRegEx));
    }

    public static <I> IndexedObjectCheck<I> whenIndexedObjectPathContains(String ... pathSegments) {
        return new IndexedObjectCheck((Class<? extends JsonSchema>)((Class<JsonSchema>)null), Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toContainsRegEx));
    }

    public static <I> IndexedObjectCheck<I> whenIndexedObjectPathEquals(String ... pathSegments) {
        return new IndexedObjectCheck((Class<? extends JsonSchema>)((Class<JsonSchema>)null), Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toRegEx));
    }

    public static IndexedObjectCheck<String> forAllIndexedStrings() {
        return Check.whenIndexedStrings(null);
    }

    public static IndexedObjectCheck<String> whenIndexedStrings(Predicate<Path.Validation.Context<ArraySchema, List<String>>> predicate) {
        return new IndexedObjectCheck<String>((Class<JsonSchema>)StringSchema.class, predicate);
    }

    public static IndexedObjectCheck<String> whenIndexedStringsPathStartsWith(String ... pathSegments) {
        return new IndexedObjectCheck<String>((Class<JsonSchema>)StringSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toStartsWithRegEx));
    }

    public static IndexedObjectCheck<String> whenIndexedStringsPathEndsWith(String ... pathSegments) {
        return new IndexedObjectCheck<String>((Class<JsonSchema>)StringSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toEndsWithRegEx));
    }

    public static IndexedObjectCheck<String> whenIndexedStringsPathContains(String ... pathSegments) {
        return new IndexedObjectCheck<String>((Class<JsonSchema>)StringSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toContainsRegEx));
    }

    public static IndexedObjectCheck<String> whenIndexedStringsPathEquals(String ... pathSegments) {
        return new IndexedObjectCheck<String>((Class<JsonSchema>)StringSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toRegEx));
    }

    public static IndexedObjectCheck<Integer> forAllIndexedIntegers() {
        return Check.whenIndexedIntegers(null);
    }

    public static IndexedObjectCheck<Integer> whenIndexedIntegers(Predicate<Path.Validation.Context<ArraySchema, List<Integer>>> predicate) {
        return new IndexedObjectCheck<Integer>((Class<JsonSchema>)IntegerSchema.class, predicate);
    }

    public static IndexedObjectCheck<Integer> whenIndexedIntegersPathStartsWith(String ... pathSegments) {
        return new IndexedObjectCheck<Integer>((Class<JsonSchema>)IntegerSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toStartsWithRegEx));
    }

    public static IndexedObjectCheck<Integer> whenIndexedIntegersPathEndsWith(String ... pathSegments) {
        return new IndexedObjectCheck<Integer>((Class<JsonSchema>)IntegerSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toEndsWithRegEx));
    }

    public static IndexedObjectCheck<Integer> whenIndexedIntegersPathContains(String ... pathSegments) {
        return new IndexedObjectCheck<Integer>((Class<JsonSchema>)IntegerSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toContainsRegEx));
    }

    public static IndexedObjectCheck<Integer> whenIndexedIntegersPathEquals(String ... pathSegments) {
        return new IndexedObjectCheck<Integer>((Class<JsonSchema>)IntegerSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toRegEx));
    }

    public static IndexedObjectCheck<Number> forAllIndexedNumbers() {
        return Check.whenIndexedNumbers(null);
    }

    public static IndexedObjectCheck<Number> whenIndexedNumbers(Predicate<Path.Validation.Context<ArraySchema, List<Number>>> predicate) {
        return new IndexedObjectCheck<Number>((Class<JsonSchema>)NumberSchema.class, predicate);
    }

    public static IndexedObjectCheck<Number> whenIndexedNumbersPathStartsWith(String ... pathSegments) {
        return new IndexedObjectCheck<Number>((Class<JsonSchema>)NumberSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toStartsWithRegEx));
    }

    public static IndexedObjectCheck<Number> whenIndexedNumbersPathEndsWith(String ... pathSegments) {
        return new IndexedObjectCheck<Number>((Class<JsonSchema>)NumberSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toEndsWithRegEx));
    }

    public static IndexedObjectCheck<Number> whenIndexedNumbersPathContains(String ... pathSegments) {
        return new IndexedObjectCheck<Number>((Class<JsonSchema>)NumberSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toContainsRegEx));
    }

    public static IndexedObjectCheck<Number> whenIndexedNumbersPathEquals(String ... pathSegments) {
        return new IndexedObjectCheck<Number>((Class<JsonSchema>)NumberSchema.class, Abst.buildPathPredicate(Path.of(pathSegments), Path.INSTANCE::toRegEx));
    }

    public static IndexedObjectCheck<Boolean> forAllIndexedBooleans() {
        return Check.whenIndexedBooleans(null);
    }

    public static IndexedObjectCheck<Boolean> whenIndexedBooleans(Predicate<Path.Validation.Context<ArraySchema, List<Boolean>>> predicate) {
        return new IndexedObjectCheck<Boolean>((Class<JsonSchema>)BooleanSchema.class, predicate);
    }

    public static IndexedObjectCheck<Boolean> whenIndexedBooleansPathStartsWith(String path) {
        return new IndexedObjectCheck<Boolean>((Class<JsonSchema>)BooleanSchema.class, Abst.buildPathPredicate(path, Path.INSTANCE::toStartsWithRegEx));
    }

    public static IndexedObjectCheck<Boolean> whenIndexedBooleansPathEndsWith(String path) {
        return new IndexedObjectCheck<Boolean>((Class<JsonSchema>)BooleanSchema.class, Abst.buildPathPredicate(path, Path.INSTANCE::toEndsWithRegEx));
    }

    public static IndexedObjectCheck<Boolean> whenIndexedBooleansPathContains(String path) {
        return new IndexedObjectCheck<Boolean>((Class<JsonSchema>)BooleanSchema.class, Abst.buildPathPredicate(path, Path.INSTANCE::toContainsRegEx));
    }

    public static IndexedObjectCheck<Boolean> whenIndexedBooleansPathEquals(String path) {
        return new IndexedObjectCheck<Boolean>((Class<JsonSchema>)BooleanSchema.class, Abst.buildPathPredicate(path, Path.INSTANCE::toRegEx));
    }

    public static class Group
    implements Check<JsonSchema, Object, Group> {
        Collection<Check<?, ?, ?>> items;

        public Group(Check<?, ?, ?> ... items) {
            this.items = new ArrayList(Arrays.asList(items));
        }

        public static Group of(Check<?, ?, ?> ... items) {
            return new Group(items);
        }

        @Override
        public Group execute(Consumer<Path.Validation.Context<JsonSchema, Object>> action) {
            for (Check<?, ?, ?> item : this.items) {
                ((Abst)item).action = action;
            }
            return this;
        }
    }

    public static abstract class Abst<S extends JsonSchema, T, C extends Abst<S, T, C>>
    implements Check<S, T, C> {
        Class<S> schemaClass;
        Predicate<Path.Validation.Context<S, T>> predicate;
        Consumer<Path.Validation.Context<S, T>> action;

        Abst(Class<S> jsonSchemaClass, Predicate<Path.Validation.Context<S, T>> predicate) {
            this.schemaClass = jsonSchemaClass;
            this.predicate = this.buildBasicPredicate(jsonSchemaClass);
            if (predicate != null) {
                this.predicate = this.predicate.and(predicate);
            }
        }

        Predicate<Path.Validation.Context<S, T>> buildBasicPredicate(Class<? extends JsonSchema> jsonSchemaClass) {
            return pathValidationContext -> jsonSchemaClass.isInstance(pathValidationContext.jsonSchema);
        }

        static <S extends JsonSchema, T> Predicate<Path.Validation.Context<S, T>> buildPathPredicate(String path, UnaryOperator<String> pathProcessor) {
            final String pathRegEx = pathProcessor != null ? (String)pathProcessor.apply(path) : path;
            return new Path.Predicate<Path.Validation.Context<S, T>>(path, pathRegEx){

                @Override
                public boolean test(Path.Validation.Context<S, T> pathValidationContext) {
                    return pathValidationContext.path.matches(pathRegEx);
                }
            };
        }

        @Override
        public synchronized C execute(Consumer<Path.Validation.Context<S, T>> action) {
            this.action = this.action != null ? this.action.andThen(action) : action;
            return (C)this;
        }
    }
}

