/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.burningwave.Executor;
import org.burningwave.json.ObjectHandler;
import org.burningwave.json.SchemaHolder;
import org.burningwave.json.Validator;

public class Facade {
    private ObjectMapper objectMapper;
    private Validator validator;
    private SchemaHolder schemaHolder;

    private Facade() {
        this(new ObjectMapper());
    }

    private Facade(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.schemaHolder = new SchemaHolder(objectMapper);
        this.validator = new Validator(this.schemaHolder);
    }

    public static Facade create() {
        return new Facade();
    }

    public static Facade create(ObjectMapper objectMapper) {
        return new Facade(objectMapper);
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    public ObjectHandler newObjectHandler(Object jsonObject) {
        return ObjectHandler.create(this.objectMapper, jsonObject);
    }

    public <T> ObjectHandler newObjectHandler(byte[] src, Class<T> type) {
        return (ObjectHandler)Executor.get(() -> ObjectHandler.create(this.objectMapper, this.objectMapper.readValue(src, type)));
    }

    public <T> ObjectHandler newObjectHandler(File src, Class<T> type) {
        return (ObjectHandler)Executor.get(() -> ObjectHandler.create(this.objectMapper, this.objectMapper.readValue(src, type)));
    }

    public <T> ObjectHandler newObjectHandler(InputStream src, Class<T> type) {
        return (ObjectHandler)Executor.get(() -> ObjectHandler.create(this.objectMapper, this.objectMapper.readValue(src, type)));
    }

    public <T> ObjectHandler newObjectHandler(Reader src, Class<T> type) {
        return (ObjectHandler)Executor.get(() -> ObjectHandler.create(this.objectMapper, this.objectMapper.readValue(src, type)));
    }

    public <T> ObjectHandler newObjectHandler(String src, Class<T> type) {
        return (ObjectHandler)Executor.get(() -> ObjectHandler.create(this.objectMapper, this.objectMapper.readValue(src, type)));
    }

    public <T> ObjectHandler newObjectHandler(URL src, Class<T> type) {
        return (ObjectHandler)Executor.get(() -> ObjectHandler.create(this.objectMapper, this.objectMapper.readValue(src, type)));
    }

    public Validator validator() {
        return this.validator;
    }
}

