/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.json;

import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import com.fasterxml.jackson.module.jsonSchema.types.BooleanSchema;
import com.fasterxml.jackson.module.jsonSchema.types.IntegerSchema;
import com.fasterxml.jackson.module.jsonSchema.types.NumberSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.types.StringSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.burningwave.Strings;
import org.burningwave.Throwables;
import org.burningwave.json.Check;
import org.burningwave.json.IndexedObjectCheck;
import org.burningwave.json.LeafCheck;
import org.burningwave.json.ObjectCheck;
import org.burningwave.json.ObjectHandler;
import org.burningwave.json.Path;
import org.burningwave.json.SLF4J;
import org.slf4j.Logger;

public class Validation {

    public static class Exception
    extends RuntimeException {
        private static final long serialVersionUID = 391707186751457489L;
        protected final String path;

        public Exception(String path, String message) {
            super(message);
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }

    public static class Context {
        static final String MOCK_SCHEMA_LABEL;
        protected static final Object logger;
        final Function<Path.Validation.Context<?, ?>, Function<String, Function<Object[], Throwable>>> exceptionBuilder;
        final Config<?> validationConfig;
        final ObjectHandler inputHandler;
        final Collection<Throwable> exceptions;
        final Function<Path.Validation.Context<?, ?>, Consumer<Throwable>> exceptionAdder;
        final Collection<ObjectCheck> objectChecks;
        final Collection<IndexedObjectCheck<?>> indexedObjectChecks;
        final Collection<LeafCheck<?, ?>> leafChecks;

        Context(Function<Path.Validation.Context<?, ?>, Function<String, Function<Object[], Throwable>>> exceptionBuilder, Config<?> validationConfig, ObjectHandler jsonObjectWrapper, Collection<ObjectCheck> objectChecks, Collection<IndexedObjectCheck<?>> indexedObjectChecks, Collection<LeafCheck<?, ?>> leafChecks) {
            this.exceptionBuilder = exceptionBuilder;
            this.validationConfig = validationConfig;
            this.inputHandler = jsonObjectWrapper;
            this.exceptions = validationConfig.validateAll ? new ArrayList() : null;
            this.exceptionAdder = validationConfig.validateAll ? pathValidationContext -> this.exceptions::add : pathValidationContext -> exc -> {
                if (logger != null && validationConfig.isErrorLoggingEnabled()) {
                    ((Logger)logger).debug("Validation of path {} failed", (Object)pathValidationContext.path);
                }
                Throwables.INSTANCE.throwException(exc);
            };
            this.objectChecks = objectChecks;
            this.indexedObjectChecks = indexedObjectChecks;
            this.leafChecks = leafChecks;
        }

        void rejectValue(Path.Validation.Context<?, ?> pathValidationContext, String checkType, Object ... messageArgs) {
            this.exceptionAdder.apply(pathValidationContext).accept(this.exceptionBuilder.apply(pathValidationContext).apply(checkType).apply(messageArgs));
        }

        boolean checkValue(JsonSchema jsonSchema, Object value) {
            if (value != null) {
                if (!this.checkUnindexedObject(jsonSchema, value)) {
                    return false;
                }
                if (jsonSchema instanceof ArraySchema) {
                    if (!(value instanceof Collection)) {
                        return false;
                    }
                    JsonSchema itemsSchema = ((ArraySchema)jsonSchema).getItems().asSingleItems().getSchema();
                    for (Object item : (Collection)value) {
                        if (this.checkUnindexedObject(itemsSchema, item)) continue;
                        return false;
                    }
                }
            }
            return true;
        }

        private boolean checkUnindexedObject(JsonSchema jsonSchema, Object value) {
            return jsonSchema instanceof ObjectSchema && value instanceof Map || jsonSchema instanceof StringSchema && value instanceof String || jsonSchema instanceof IntegerSchema && value instanceof Integer || jsonSchema instanceof NumberSchema && value instanceof Number || jsonSchema instanceof BooleanSchema && value instanceof Boolean;
        }

        public ObjectHandler getInputHandler() {
            return this.inputHandler;
        }

        static {
            logger = SLF4J.INSTANCE.tryToInitLogger(Context.class);
            MOCK_SCHEMA_LABEL = Strings.INSTANCE.toStringWithRandomUUIDSuffix("schemaMock");
        }
    }

    public static class Config<I> {
        private static final Predicate<Path.Validation.Context<?, ?>> DEFAULT_PATH_FILTER = pathValidationContext -> true;
        private static final Function<Check<?, ?, ?>, Predicate<Path.Validation.Context<?, ?>>> DEFAULT_CHECK_FILTER = check -> pathValidationContext -> true;
        I jsonObjectOrSupplier;
        Predicate<Path.Validation.Context<?, ?>> pathFilter;
        Function<Check<?, ?, ?>, Predicate<Path.Validation.Context<?, ?>>> checkFilter;
        boolean validateAll;
        int logMode;
        Collection<String> checkGroupIds;

        private Config(I jsonObject) {
            this.jsonObjectOrSupplier = jsonObject;
            this.pathFilter = DEFAULT_PATH_FILTER;
            this.checkFilter = DEFAULT_CHECK_FILTER;
            this.logMode = 1;
            this.checkGroupIds = new ArrayList<String>();
        }

        public static <I> Config<I> forJsonObject(I jsonObject) {
            return new Config<I>(jsonObject);
        }

        public Config<I> withPathFilter(Predicate<Path.Validation.Context<?, ?>> pathFilter) {
            this.pathFilter = pathFilter;
            return this;
        }

        public Config<I> withCheckFilter(Function<Check<?, ?, ?>, Predicate<Path.Validation.Context<?, ?>>> checkFilter) {
            this.checkFilter = checkFilter;
            return this;
        }

        public Config<I> withCompleteValidation() {
            this.validateAll = true;
            return this;
        }

        public Config<I> withExitStrategyAtFirstError() {
            this.validateAll = false;
            return this;
        }

        public Config<I> withTheseChecks(String ... checkGroupIds) {
            this.checkGroupIds.addAll(Arrays.asList(checkGroupIds));
            return this;
        }

        public Config<I> disableLogging() {
            this.logMode = 0;
            return this;
        }

        public Config<I> enableDeepLogging() {
            this.logMode = 2;
            return this;
        }

        boolean isDeepLoggingEnabled() {
            return this.logMode == 2;
        }

        boolean isErrorLoggingEnabled() {
            return this.isDeepLoggingEnabled() || this.logMode == 1;
        }

        Collection<String> getGroupIds() {
            return this.checkGroupIds;
        }
    }
}

