/*
 * This file is part of Burningwave JSON.
 *
 * Author: Roberto Gentili
 *
 * Hosted at: https://github.com/burningwave/JSON
 *
 * --
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2023 Roberto Gentili
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without
 * limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial
 * portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
 * LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
 * EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */
package org.burningwave.json;

import java.util.List;
import java.util.function.Predicate;

import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;

public class IndexedObjectCheck<I> extends Check.Abst<ArraySchema, List<I>, IndexedObjectCheck<I>> {
	Class<? extends JsonSchema> itemsSchemaClass;

	IndexedObjectCheck(
		Class<? extends JsonSchema> itemsSchemaClass,
		Predicate<Path.Validation.Context<ArraySchema, List<I>>> predicate
	) {
		super(ArraySchema.class, predicate);
		this.itemsSchemaClass = itemsSchemaClass;
	}

	@Override
	Predicate<Path.Validation.Context<ArraySchema, List<I>>> buildBasicPredicate(Class<? extends JsonSchema> jsonSchemaClass) {
		return pathValidationContext ->
			pathValidationContext.jsonSchema instanceof ArraySchema &&
				(itemsSchemaClass == null || itemsSchemaClass.isInstance((pathValidationContext.jsonSchema).getItems().asSingleItems().getSchema())) ;
	}

}
